/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.wmi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.wmi.model.WMIClassAttribute;
import org.jkiss.dbeaver.ext.wmi.model.WMIClassConstraint;
import org.jkiss.dbeaver.ext.wmi.model.WMIClassInheritance;
import org.jkiss.dbeaver.ext.wmi.model.WMIClassMethod;
import org.jkiss.dbeaver.ext.wmi.model.WMIClassReference;
import org.jkiss.dbeaver.ext.wmi.model.WMIContainer;
import org.jkiss.dbeaver.ext.wmi.model.WMINamespace;
import org.jkiss.dbeaver.ext.wmi.model.WMIObjectCollectorSink;
import org.jkiss.dbeaver.ext.wmi.model.WMIResultSet;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPCloseableObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.utils.CommonUtils;
import org.jkiss.wmi.service.WMIException;
import org.jkiss.wmi.service.WMIObject;
import org.jkiss.wmi.service.WMIObjectAttribute;
import org.jkiss.wmi.service.WMIObjectMethod;
import org.jkiss.wmi.service.WMIQualifiedObject;

public class WMIClass
extends WMIContainer
implements DBSEntity,
DBPCloseableObject,
DBPQualifiedObject,
DBPSystemObject,
DBSDataContainer,
DBPImageProvider {
    private static final Log log = Log.getLog(WMIClass.class);
    static final String ICON_LOCATION_PREFIX = "platform:/plugin/org.jkiss.dbeaver.ext.wmi/icons/";
    private static final DBPImage IMG_CLASS;
    private static final DBPImage IMG_CLASS_ABSTRACT;
    private static final DBPImage IMG_CLASS_FINAL;
    private static final DBPImage IMG_CLASS_ABSTRACT_FINAL;
    private static final DBPImage IMG_ASSOCIATION;
    private static final DBPImage IMG_ASSOCIATION_ABSTRACT;
    private static final DBIcon IMG_ABSTRACT_OVR;
    private static final DBIcon IMG_FINAL_OVR;
    private final WMIClass superClass;
    private WMIObject classObject;
    private String name;
    private List<WMIClass> subClasses = null;
    private List<WMIClassAttribute> attributes = null;
    private List<WMIClassReference> referenceAttributes = null;
    private List<WMIClassMethod> methods = null;

    public WMIClass(WMINamespace parent, WMIClass superClass, WMIObject classObject) {
        super(parent);
        this.superClass = superClass;
        this.classObject = classObject;
    }

    public boolean isAbstract() throws DBException {
        return this.getFlagQualifier("Abstract");
    }

    public boolean isAssociation() throws DBException {
        return this.getFlagQualifier("Association");
    }

    public boolean isAggregation() throws DBException {
        return this.getFlagQualifier("Aggregation");
    }

    public boolean isFinal() throws DBException {
        return this.getFlagQualifier("Terminal");
    }

    @Property(viewable=true, order=10)
    public WMIClass getSuperClass() {
        return this.superClass;
    }

    public WMINamespace getNamespace() {
        return this.parent;
    }

    public WMIObject getClassObject() {
        return this.classObject;
    }

    @Association
    public List<WMIClass> getSubClasses() {
        return this.subClasses;
    }

    @Association
    public Collection<WMIClass> getClasses(DBRProgressMonitor monitor) throws DBException {
        return this.subClasses;
    }

    void addSubClass(WMIClass wmiClass) {
        if (this.subClasses == null) {
            this.subClasses = new ArrayList<WMIClass>();
        }
        this.subClasses.add(wmiClass);
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        if (this.name == null && this.classObject != null) {
            try {
                this.name = CommonUtils.toString((Object)this.classObject.getValue("__CLASS"));
            }
            catch (WMIException e) {
                log.error((Object)e);
                return e.getMessage();
            }
        }
        if (this.name == null) {
            this.name = "?" + this.hashCode();
        }
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getPath() {
        try {
            return CommonUtils.toString((Object)this.classObject.getValue("__PATH"));
        }
        catch (WMIException e) {
            log.error((Object)e);
            return e.getMessage();
        }
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return this.getName();
    }

    public boolean isSystem() {
        return this.getName().startsWith("__");
    }

    @NotNull
    public DBSEntityType getEntityType() {
        try {
            if (this.isAssociation()) {
                return DBSEntityType.ASSOCIATION;
            }
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
        return DBSEntityType.CLASS;
    }

    public Collection<WMIClassReference> getReferenceAttributes(DBRProgressMonitor monitor) throws DBException {
        if (this.attributes == null) {
            this.readAttributes(monitor);
        }
        return this.referenceAttributes;
    }

    public List<WMIClassAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.attributes == null) {
            this.readAttributes(monitor);
        }
        return this.attributes;
    }

    @Nullable
    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<WMIClassConstraint> constraints = null;
        for (WMIClassAttribute attr : this.getAllAttributes(monitor)) {
            if (!attr.isKey()) continue;
            if (constraints == null) {
                constraints = new ArrayList<WMIClassConstraint>();
            }
            constraints.add(new WMIClassConstraint(this, attr));
        }
        return constraints;
    }

    public WMIClassAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (WMIClassAttribute)DBUtils.findObject(this.getAttributes(monitor), (String)attributeName);
    }

    @Association
    public Collection<WMIClassAttribute> getAllAttributes(DBRProgressMonitor monitor) throws DBException {
        if (this.superClass == null) {
            return this.getAttributes(monitor);
        }
        ArrayList<WMIClassAttribute> allAttrs = new ArrayList<WMIClassAttribute>();
        WMIClass c = this;
        while (c != null) {
            for (WMIClassAttribute attr : c.getAttributes(monitor)) {
                boolean overridden = false;
                for (WMIClassAttribute a : allAttrs) {
                    if (!attr.getName().equals(a.getName())) continue;
                    overridden = true;
                    break;
                }
                if (overridden) continue;
                allAttrs.add(attr);
            }
            c = c.superClass;
        }
        return allAttrs;
    }

    private synchronized void readAttributes(DBRProgressMonitor monitor) throws DBException {
        if (this.attributes != null) {
            return;
        }
        try {
            this.attributes = new ArrayList<WMIClassAttribute>();
            for (WMIObjectAttribute prop : this.classObject.getAttributes(512L)) {
                if (!monitor.isCanceled()) {
                    if (prop.getType() == 102) {
                        Object refClassPath = prop.getQualifier("CIMTYPE");
                        if (refClassPath == null) {
                            log.warn((Object)"No CIMTYPE qualifier for reference property");
                            continue;
                        }
                        String refClassName = refClassPath.toString();
                        if (!refClassName.startsWith("ref:")) {
                            log.warn((Object)("Invalid class reference qualifier: " + refClassName));
                            continue;
                        }
                        refClassName = refClassName.substring(4);
                        WMIClass refClass = this.getNamespace().getClass(monitor, refClassName);
                        if (refClass == null) {
                            log.warn((Object)("Referenced class '" + refClassName + "' not found in '" + this.getNamespace().getName() + "'"));
                            continue;
                        }
                        if (this.referenceAttributes == null) {
                            this.referenceAttributes = new ArrayList<WMIClassReference>();
                        }
                        WMIClassReference reference = new WMIClassReference(this, prop, refClass);
                        this.referenceAttributes.add(reference);
                        this.attributes.add(reference);
                        continue;
                    }
                    if (prop.isSystem()) continue;
                    this.attributes.add(new WMIClassAttribute(this, prop));
                    continue;
                }
                break;
            }
        }
        catch (WMIException e) {
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    @Association
    public List<WMIClassMethod> getMethods(DBRProgressMonitor monitor) throws DBException {
        if (this.methods == null) {
            this.readMethods(monitor);
        }
        return this.methods;
    }

    public WMIClassMethod getMethod(DBRProgressMonitor monitor, String methodName) throws DBException {
        if (this.methods == null) {
            this.readMethods(monitor);
        }
        return (WMIClassMethod)DBUtils.findObject(this.methods, (String)methodName);
    }

    private synchronized void readMethods(DBRProgressMonitor monitor) throws DBException {
        if (this.methods != null) {
            return;
        }
        try {
            this.methods = new ArrayList<WMIClassMethod>();
            for (WMIObjectMethod prop : this.classObject.getMethods(16L)) {
                if (!monitor.isCanceled()) {
                    this.methods.add(new WMIClassMethod(this, prop));
                    continue;
                }
                break;
            }
        }
        catch (WMIException e) {
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    public List<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.getAttributes(monitor);
        if (this.superClass == null && CommonUtils.isEmpty(this.referenceAttributes)) {
            return null;
        }
        ArrayList<Object> associations = new ArrayList<Object>();
        if (this.superClass != null) {
            associations.add(new WMIClassInheritance(this.superClass, this));
        }
        if (this.referenceAttributes != null) {
            associations.addAll(this.referenceAttributes);
        }
        return associations;
    }

    public List<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<Object> references = new ArrayList<Object>();
        if (this.subClasses != null) {
            for (WMIClass ss : this.subClasses) {
                references.add(new WMIClassInheritance(this, ss));
            }
        }
        if (!this.isAssociation()) {
            block1: for (WMIClass assoc : this.getNamespace().getAssociations(monitor)) {
                Collection<WMIClassReference> refAttrs = assoc.getReferenceAttributes(monitor);
                if (refAttrs == null) continue;
                for (WMIClassReference ref : refAttrs) {
                    if (ref.getAssociatedEntity() != this) continue;
                    references.add(ref);
                    continue block1;
                }
            }
        }
        return references;
    }

    public void close() {
        if (this.classObject != null) {
            this.classObject.release();
            this.classObject = null;
        }
    }

    public String toString() {
        if (this.classObject == null) {
            return super.toString();
        }
        return this.getName();
    }

    public String[] getSupportedFeatures() {
        return new String[]{"data.select"};
    }

    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBException {
        DBCStatistics statistics = new DBCStatistics();
        try {
            WMIResultSet resultSet;
            long startTime = System.currentTimeMillis();
            WMIObjectCollectorSink sink = new WMIObjectCollectorSink(session.getProgressMonitor(), this.getNamespace().getService(), firstRow, maxRows);
            this.getNamespace().getService().enumInstances(this.getName(), sink, 1L);
            statistics.setExecuteTime(System.currentTimeMillis() - startTime);
            sink.waitForFinish();
            try (WMIResultSet wMIResultSet = resultSet = new WMIResultSet(session, this, sink.getObjectList());){
                DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (long)firstRow, (long)maxRows);
                DBDDataReceiver.fetchRowsWithStatistics((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (DBCStatistics)statistics);
            }
            return statistics;
        }
        catch (WMIException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) {
        return -1L;
    }

    @Nullable
    public DBPImage getObjectImage() {
        try {
            if (this.isAssociation()) {
                return this.isAbstract() ? IMG_ASSOCIATION_ABSTRACT : IMG_ASSOCIATION;
            }
            if (this.isAbstract()) {
                return this.isFinal() ? IMG_CLASS_ABSTRACT_FINAL : IMG_CLASS_ABSTRACT;
            }
            if (this.isFinal()) {
                return IMG_CLASS_FINAL;
            }
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
        return IMG_CLASS;
    }

    @Override
    protected WMIQualifiedObject getQualifiedObject() {
        return this.classObject;
    }

    static {
        IMG_ABSTRACT_OVR = new DBIcon("platform:/plugin/org.jkiss.dbeaver.ext.wmi/icons/ovr_abstract.png");
        IMG_FINAL_OVR = new DBIcon("platform:/plugin/org.jkiss.dbeaver.ext.wmi/icons/ovr_final.png");
        IMG_CLASS = DBIcon.TREE_CLASS;
        IMG_CLASS_ABSTRACT = new DBIconComposite(IMG_CLASS, false, null, (DBPImage)IMG_ABSTRACT_OVR, null, null);
        IMG_CLASS_ABSTRACT_FINAL = new DBIconComposite(IMG_CLASS, false, null, (DBPImage)IMG_ABSTRACT_OVR, null, (DBPImage)IMG_FINAL_OVR);
        IMG_CLASS_FINAL = new DBIconComposite(IMG_CLASS, false, null, null, null, (DBPImage)IMG_FINAL_OVR);
        IMG_ASSOCIATION = DBIcon.TREE_ASSOCIATION;
        IMG_ASSOCIATION_ABSTRACT = new DBIconComposite(IMG_ASSOCIATION, false, null, (DBPImage)IMG_ABSTRACT_OVR, null, null);
    }
}

