/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.BeanUtils;

public class DB2Sqlca {
    private static final Log LOG = Log.getLog(DB2Sqlca.class);
    private final Object delegate;

    private DB2Sqlca(Object delegate) {
        this.delegate = delegate;
    }

    @Nullable
    public char[] getSqlWarn() {
        try {
            return (char[])BeanUtils.invokeObjectMethod((Object)this.delegate, (String)"getSqlWarn");
        }
        catch (Throwable t) {
            LOG.error((Object)"Unable to invoke getSqlWarn()", t);
            return null;
        }
    }

    @Nullable
    static DB2Sqlca from(@NotNull Connection connection) throws SQLException {
        return DB2Sqlca.from(connection.getWarnings());
    }

    @Nullable
    static DB2Sqlca from(@Nullable SQLWarning warning) throws SQLException {
        if (warning == null) {
            return null;
        }
        try {
            Object value = BeanUtils.invokeObjectMethod((Object)warning, (String)"getSqlca");
            if (value != null) {
                return new DB2Sqlca(value);
            }
        }
        catch (Throwable t) {
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            LOG.error((Object)"Unable to reflectively access DB2 SQLCA", t);
        }
        return null;
    }
}

