/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.output.DBCOutputSeverity;
import org.jkiss.dbeaver.model.exec.output.DBCOutputWriter;
import org.jkiss.dbeaver.model.exec.output.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.output.DBCServerOutputReaderExt;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.MenuCreator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorOutputConsoleViewer;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;

public class SQLEditorOutputViewer
extends Composite
implements DBCOutputWriter {
    private static final int INITIAL_OUTPUT_RECORD_CAPACITY = 1000;
    private final Set<DBCOutputSeverity> severities = new HashSet<DBCOutputSeverity>();
    private final Deque<OutputRecord> records = new ArrayDeque<OutputRecord>(1000);
    private final Text filterText;
    private final ToolBarManager filterToolbar;
    private final SQLEditorOutputConsoleViewer viewer;
    private DBCExecutionContext executionContext;

    public SQLEditorOutputViewer(@NotNull IWorkbenchPartSite site, @NotNull Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(1808));
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        Composite filterComposite = UIUtils.createPlaceholder((Composite)this, (int)2);
        filterComposite.setLayoutData((Object)new GridData(768));
        this.filterText = new Text(filterComposite, 388);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.setMessage(SQLEditorMessages.sql_editor_panel_output_filter_message);
        this.filterText.addModifyListener(e -> this.filterOutput());
        this.filterToolbar = new ToolBarManager();
        this.filterToolbar.add((IAction)new ConfigureSeverityAction());
        this.filterToolbar.createControl(filterComposite);
        this.viewer = new SQLEditorOutputConsoleViewer(site, this, 0){

            @Override
            public void clearOutput() {
                super.clearOutput();
                SQLEditorOutputViewer.this.records.clear();
            }
        };
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)site, (Control)this.filterText);
        this.updateControls();
    }

    public void println(@Nullable DBCOutputSeverity severity, @Nullable String message) {
        if (message == null) {
            return;
        }
        if (severity == null || severity.isForced() || this.severities.contains(severity)) {
            PrintWriter writer = this.viewer.getOutputWriter();
            if (severity != null && severity.isForced()) {
                writer.print("[" + severity.getName() + "] ");
            }
            writer.println(message);
        }
        this.records.offer(new OutputRecord(severity, message));
    }

    public void flush() {
        this.viewer.getOutputWriter().flush();
    }

    @NotNull
    public SQLEditorOutputConsoleViewer getViewer() {
        return this.viewer;
    }

    public boolean isHasNewOutput() {
        return this.viewer.isHasNewOutput();
    }

    public void refreshStyles() {
        this.viewer.refreshStyles();
    }

    public void resetNewOutput() {
        this.viewer.resetNewOutput();
    }

    public void clearOutput() {
        this.viewer.clearOutput();
    }

    public void setExecutionContext(@Nullable DBCExecutionContext executionContext) {
        if (this.executionContext != executionContext) {
            this.executionContext = executionContext;
            this.updateControls();
        }
    }

    private void updateControls() {
        this.clearOutput();
        this.severities.clear();
        DBPDataSource dataSource = this.executionContext != null ? this.executionContext.getDataSource() : null;
        DBCServerOutputReader reader = (DBCServerOutputReader)DBUtils.getAdapter(DBCServerOutputReader.class, (Object)dataSource);
        if (reader instanceof DBCServerOutputReaderExt) {
            DBCServerOutputReaderExt readerExt = (DBCServerOutputReaderExt)reader;
            DBCOutputSeverity[] supportedSeverities = readerExt.getSupportedSeverities(this.executionContext);
            this.severities.addAll(List.of(supportedSeverities));
            UIUtils.setControlVisible((Control)this.filterToolbar.getControl(), (supportedSeverities.length > 0 ? 1 : 0) != 0);
        } else {
            UIUtils.setControlVisible((Control)this.filterToolbar.getControl(), (boolean)false);
        }
        this.filterToolbar.getControl().getParent().layout(true, true);
    }

    private void filterOutput() {
        this.viewer.getConsole().clearConsole();
        PrintWriter writer = this.viewer.getOutputWriter();
        String filter = this.filterText.getText().trim();
        for (OutputRecord record : this.records) {
            if (record.severity != null && !record.severity.isForced() && !this.severities.contains(record.severity) || !filter.isEmpty() && !record.line.contains(filter)) continue;
            writer.println(record.line);
        }
        writer.flush();
    }

    private class ConfigureSeverityAction
    extends Action {
        public ConfigureSeverityAction() {
            super(null, 4);
            MenuManager filterMenu = new MenuManager();
            filterMenu.setRemoveAllWhenShown(true);
            filterMenu.addMenuListener(manager -> {
                DBCServerOutputReader reader = (DBCServerOutputReader)DBUtils.getAdapter(DBCServerOutputReader.class, (Object)SQLEditorOutputViewer.this.executionContext.getDataSource());
                if (!(reader instanceof DBCServerOutputReaderExt)) {
                    return;
                }
                DBCServerOutputReaderExt readerExt = (DBCServerOutputReaderExt)reader;
                for (DBCOutputSeverity severity : readerExt.getSupportedSeverities(SQLEditorOutputViewer.this.executionContext)) {
                    manager.add((IAction)new ToggleSeverityAction(severity));
                }
            });
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.FILTER));
            this.setToolTipText(SQLEditorMessages.sql_editor_panel_output_filter_hint);
            this.setMenuCreator((IMenuCreator)new MenuCreator(control -> filterMenu));
        }
    }

    private static class OutputRecord {
        private final DBCOutputSeverity severity;
        private final String line;

        public OutputRecord(@Nullable DBCOutputSeverity severity, @NotNull String line) {
            this.severity = severity;
            this.line = line;
        }
    }

    private class ToggleSeverityAction
    extends Action {
        private final DBCOutputSeverity severity;

        public ToggleSeverityAction(DBCOutputSeverity severity) {
            super(severity.getName(), 2);
            this.severity = severity;
        }

        public boolean isChecked() {
            return SQLEditorOutputViewer.this.severities.contains(this.severity);
        }

        public void run() {
            if (SQLEditorOutputViewer.this.severities.contains(this.severity)) {
                SQLEditorOutputViewer.this.severities.remove(this.severity);
            } else {
                SQLEditorOutputViewer.this.severities.add(this.severity);
            }
            SQLEditorOutputViewer.this.filterOutput();
        }
    }
}

