/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.ai;

import arc.math.Mathf;
import arc.math.geom.Position;
import mindustry.Vars;
import mindustry.ai.types.DefenderAI;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Healthc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.blocks.storage.CoreBlock;

public class DefenderHealAI
extends DefenderAI {
    public boolean targetUnit;
    public boolean targetBuilding;

    public DefenderHealAI(boolean targetUnit, boolean targetBuilding) {
        this.targetUnit = targetUnit;
        this.targetBuilding = targetBuilding;
    }

    public DefenderHealAI() {
        this(true, true);
    }

    public void updateMovement() {
        if (this.target != null) {
            Healthc hc;
            Teamc teamc;
            boolean shoot = false;
            if (this.target.within((Position)this.unit, this.unit.type.range) && (teamc = this.target) instanceof Healthc && (hc = (Healthc)teamc).health() < hc.maxHealth() - 0.001f && this.target.team() == this.unit.team && (this.targetUnit && this.target instanceof Unit || this.targetBuilding && this.target instanceof Building)) {
                this.unit.aim((Position)this.target);
                shoot = true;
            }
            this.unit.controlWeapons(shoot);
        } else {
            this.unit.controlWeapons(false);
        }
        if (this.target != null && this.unit.type != null) {
            if (this.unit.type.flying) {
                if (!this.target.within((Position)this.unit, this.unit.type.range * 0.7f)) {
                    this.moveTo((Position)this.target, this.unit.type.range * 0.7f);
                }
                this.unit.lookAt((Position)this.target);
            } else {
                if (!this.target.within((Position)this.unit, this.unit.type.range * 0.7f)) {
                    this.moveTo((Position)this.target, this.unit.type.range * 0.7f);
                    if (!this.target.within((Position)this.unit, this.unit.type.range * 1.2f) && (this.unit.type.canBoost || this.unit.type.naval && !this.unit.floorOn().isLiquid)) {
                        this.unit.elevation = Mathf.approachDelta((float)this.unit.elevation, (float)1.0f, (float)this.unit.type.riseSpeed);
                    }
                }
                if (this.target.within((Position)this.unit, this.unit.type.range * 1.2f) && this.unit.type.canBoost && (double)this.unit.elevation > 0.001 && !this.unit.onSolid() && (!this.unit.type.naval || this.unit.floorOn().isLiquid)) {
                    this.unit.elevation = Mathf.approachDelta((float)this.unit.elevation, (float)0.0f, (float)this.unit.type.riseSpeed);
                }
                this.unit.lookAt((Position)this.target);
            }
        }
        if (!this.targetUnit && (this.target == null || this.target instanceof Unit || this.target.team() != this.unit.team) && this.unit.type != null) {
            boolean shootA = false;
            boolean air = this.unit.type.targetAir;
            boolean ground = this.unit.type.targetGround;
            Teamc enemy = Units.closestTarget((Team)this.unit.team, (float)this.unit.x, (float)this.unit.y, (float)this.unit.type.maxRange, u -> u.checkTarget(air, ground), t -> ground);
            if (enemy != null) {
                this.unit.aim((Position)enemy);
                shootA = true;
            }
            this.unit.controlWeapons(shootA);
        }
    }

    public Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        Building build;
        Unit result = Units.closest((Team)this.unit.team, (float)x, (float)y, (float)Math.max(range, 400.0f), u -> !u.dead && u.type != this.unit.type && u.damaged());
        if (result != null) {
            return result;
        }
        if (this.targetBuilding && (build = Units.findAllyTile((Team)this.unit.team, (float)x, (float)y, (float)Math.max(range, 400.0f), Building::damaged)) != null) {
            return build;
        }
        Unit strong = Units.closest((Team)this.unit.team, (float)x, (float)y, (float)Math.max(range, 400.0f), u -> !u.dead && u.type != this.unit.type, (u, tx, ty) -> -u.maxHealth + Mathf.dst2((float)u.x, (float)u.y, (float)tx, (float)ty) / 6400.0f);
        if (strong != null) {
            return strong;
        }
        CoreBlock.CoreBuild core = this.unit.closestCore();
        if (core != null) {
            return core;
        }
        if (Vars.state.rules.waves && this.unit.team == Vars.state.rules.waveTeam) {
            return this.unit.closestEnemyCore();
        }
        return null;
    }
}

