/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.ai;

import arc.math.geom.Position;
import mindustry.content.Blocks;
import mindustry.entities.units.AIController;
import mindustry.gen.Building;
import mindustry.gen.BuildingTetherc;
import mindustry.gen.Call;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.world.Tile;

public class MinerPointAI
extends AIController {
    public boolean mining = true;
    public Tile ore;

    public void updateMovement() {
        Unit unit;
        if (this.unit.stack.amount > 0 && !this.checkDrop(this.ore)) {
            this.mining = false;
        }
        if ((unit = this.unit) instanceof BuildingTetherc) {
            BuildingTetherc tether = (BuildingTetherc)unit;
            if (tether.building() == null) {
                return;
            }
            if (this.unit.mineTile != null && !this.unit.mineTile.within((Position)this.unit, this.unit.type.mineRange)) {
                this.unit.mineTile(null);
            }
            Building build = tether.building();
            if (this.mining) {
                if (this.unit.stack.amount >= this.unit.type.itemCapacity) {
                    this.mining = false;
                } else if (this.ore != null) {
                    this.moveTo((Position)this.ore, this.unit.type.mineRange / 2.0f, 20.0f);
                    if ((this.ore.block() == Blocks.air || this.ore.wallDrop() != null) && this.unit.within((Position)this.ore, this.unit.type.mineRange)) {
                        this.unit.mineTile = this.ore;
                    }
                    if (this.ore.block() != Blocks.air && this.ore.wallDrop() == null) {
                        this.mining = false;
                    }
                }
            } else {
                this.unit.mineTile = null;
                if (this.unit.stack.amount == 0) {
                    this.mining = true;
                    return;
                }
                if (this.unit.within((Position)build, this.unit.type.range)) {
                    if (build.acceptStack(this.unit.item(), this.unit.stack.amount, (Teamc)this.unit) > 0) {
                        Call.transferItemTo((Unit)this.unit, (Item)this.unit.stack.item, (int)this.unit.stack.amount, (float)this.unit.x, (float)this.unit.y, (Building)build);
                        this.unit.clearItem();
                        this.mining = true;
                    } else if (!this.checkDrop(this.ore)) {
                        this.unit.clearItem();
                        this.mining = true;
                    }
                }
                this.circle((Position)build, this.unit.type.range / 1.8f);
            }
        }
    }

    private boolean checkDrop(Tile t) {
        if (t == null) {
            return false;
        }
        return t.solid() ? t.wallDrop() == this.unit.stack.item : t.drop() == this.unit.stack.item;
    }
}

