/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.content;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUAttribute;
import ExtraUtilities.content.EUBlocks;
import ExtraUtilities.content.EUBulletTypes;
import ExtraUtilities.content.EUItems;
import ExtraUtilities.content.EUUnitTypes;
import ExtraUtilities.content.TDPlanet;
import ExtraUtilities.worlds.entity.bullet.ChainLightningFade;
import ExtraUtilities.worlds.entity.bullet.CtrlMissile;
import ExtraUtilities.worlds.entity.bullet.liLaserBullet;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Planets;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.MissileBulletType;
import mindustry.entities.bullet.ShrapnelBulletType;
import mindustry.entities.effect.ExplosionEffect;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.effect.WaveEffect;
import mindustry.entities.effect.WrapEffect;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.FlarePart;
import mindustry.entities.part.ShapePart;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.mod.Mods;
import mindustry.type.Category;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.PayloadStack;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.payloads.Constructor;
import mindustry.world.blocks.payloads.PayloadConveyor;
import mindustry.world.blocks.payloads.PayloadRouter;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.blocks.units.UnitFactory;

public class EUOverride {
    public static void overrideBlockAll(boolean hard, boolean coreResetV7, boolean coreReset) {
        for (int i = 0; i < Vars.content.blocks().size; ++i) {
            Block block = (Block)Vars.content.blocks().get(i);
            if (block != null && (coreResetV7 || coreReset)) {
                if (block.requirements.length == 0) {
                    block.shownPlanets.addAll(Vars.content.planets().copy().removeAll(p -> p == Planets.sun));
                } else {
                    block.shownPlanets.clear();
                }
                block.postInit();
            }
            if (!hard) continue;
            if (block != null) {
                block.canOverdrive = false;
            }
            if (!(block instanceof Turret) || block.size < 5 || block.requirements == null || block.requirements.length == 0) continue;
            boolean has = false;
            for (ItemStack stack : block.requirements) {
                if (stack.item != EUItems.lightninAlloy) continue;
                has = true;
                break;
            }
            if (has) continue;
            ItemStack[] copy = new ItemStack[block.requirements.length + 1];
            System.arraycopy(block.requirements, 0, copy, 0, block.requirements.length);
            copy[block.requirements.length] = new ItemStack(EUItems.lightninAlloy, 50 * (block.size - 4));
            block.requirements = copy;
        }
    }

    public static void overrideTDRules(boolean coreReset) {
        if (coreReset) {
            for (Item i : Vars.content.items()) {
                if (i == null) continue;
                i.shownPlanets.clear();
                i.shownPlanets.addAll(Vars.content.planets().copy().removeAll(p -> p == Planets.sun));
                i.postInit();
            }
            for (Liquid l : Vars.content.liquids()) {
                if (l == null) continue;
                l.shownPlanets.clear();
                l.shownPlanets.addAll(Vars.content.planets().copy().removeAll(p -> p == Planets.sun));
                l.postInit();
            }
        } else {
            for (Item i : Vars.content.items()) {
                if (i == null || i.shownPlanets.isEmpty()) continue;
                i.shownPlanets.add((Object)TDPlanet.TD);
                if (i.shownPlanets.contains((Object)Planets.serpulo)) {
                    i.shownPlanets.add((Object)TDPlanet.supEX);
                }
                i.postInit();
            }
            for (Liquid l : Vars.content.liquids()) {
                if (l == null || l.shownPlanets.isEmpty()) continue;
                l.shownPlanets.add((Object)TDPlanet.TD);
                if (l.shownPlanets.contains((Object)Planets.serpulo)) {
                    l.shownPlanets.add((Object)TDPlanet.supEX);
                }
                l.postInit();
            }
            EUItems.lightninAlloy.shownPlanets.clear();
            EUItems.crispSteel.shownPlanets.clear();
            EUBlocks.LA.shownPlanets.clear();
            EUBlocks.LA.postInit();
            EUBlocks.ELA.shownPlanets.clear();
            EUBlocks.ELA.postInit();
            EUItems.lightninAlloy.shownPlanets.addAll(EUBlocks.LA.shownPlanets);
            EUItems.lightninAlloy.shownPlanets.addAll(EUBlocks.ELA.shownPlanets);
            EUItems.lightninAlloy.postInit();
            Block crispSteelCrafter = Vars.content.block(ExtraUtilitiesMod.name("crisp-steel-smelter"));
            if (crispSteelCrafter != null) {
                crispSteelCrafter.shownPlanets.clear();
                crispSteelCrafter.postInit();
                EUItems.crispSteel.shownPlanets.addAll(crispSteelCrafter.shownPlanets);
                EUItems.crispSteel.postInit();
            }
        }
    }

    public static void overrideBlock1() {
        Blocks.sandWater.itemDrop = Items.sand;
        Blocks.sandWater.playerUnmineable = true;
        Blocks.darksandWater.itemDrop = Items.sand;
        Blocks.darksandWater.playerUnmineable = true;
        Blocks.darksandTaintedWater.itemDrop = Items.sand;
        Blocks.darksandTaintedWater.playerUnmineable = true;
        Blocks.oxidationChamber.canOverdrive = true;
        Blocks.neoplasiaReactor.canOverdrive = true;
        Blocks.stone.attributes.set(EUAttribute.stone, 0.3f);
        Blocks.basalt.attributes.set(EUAttribute.stone, 0.2f);
        Blocks.shale.attributes.set(EUAttribute.stone, 0.1f);
        Blocks.pebbles.attributes.set(EUAttribute.stone, 0.25f);
        Blocks.craters.attributes.set(EUAttribute.stone, 0.15f);
        Blocks.yellowStone.attributes.set(EUAttribute.stone, 0.25f);
        Blocks.carbonStone.attributes.set(EUAttribute.stone, 0.2f);
        Blocks.rhyolite.attributes.set(EUAttribute.stone, 0.2f);
        Blocks.rhyoliteCrater.attributes.set(EUAttribute.stone, 0.15f);
        Blocks.roughRhyolite.attributes.set(EUAttribute.stone, 0.1f);
        Blocks.ferricStone.attributes.set(EUAttribute.stone, 0.2f);
        Blocks.ferricCraters.attributes.set(EUAttribute.stone, 0.15f);
        Blocks.arkyicStone.attributes.set(EUAttribute.EKOil, 0.11111111f);
        Blocks.beryllicStone.attributes.set(EUAttribute.EKOil, 0.07777778f);
        Blocks.arc.consumePower(2.5f);
        ((ItemTurret)Blocks.foreshadow).ammoTypes.put((Object)EUItems.lightninAlloy, (Object)EUBulletTypes.foreshadowEUBullet);
        Blocks.smite.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.oxide, 200, Items.silicon, 800, Items.carbide, 500, Items.phaseFabric, 350, EUItems.lightninAlloy, 350}));
        Blocks.malign.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.carbide, 400, Items.beryllium, 2000, Items.silicon, 800, Items.graphite, 800, Items.phaseFabric, 300, Items.surgeAlloy, 200}));
        ((BaseTurret)Blocks.scathe).fogRadiusMultiplier = 0.75f;
        ((UnitFactory)Blocks.airFactory).plans.add((Object)new UnitFactory.UnitPlan(EUUnitTypes.winglet, 1800.0f, ItemStack.with((Object[])new Object[]{Items.silicon, 20, Items.titanium, 10, Items.lead, 15})));
        ((PayloadConveyor)Blocks.reinforcedPayloadConveyor).payloadLimit = 3.25f;
        ((PayloadRouter)Blocks.reinforcedPayloadRouter).payloadLimit = 3.25f;
        Block rwl = Vars.content.block(ExtraUtilitiesMod.name("rwl"));
        if (rwl != null) {
            Blocks.constructor.description = Blocks.constructor.description + "\n[accent]Resetting py EU mod.";
            ((Constructor)Blocks.constructor).filter = new Seq();
            Blocks.largeConstructor.description = Blocks.largeConstructor.description + "\n[accent]Resetting py EU mod.";
            ((Constructor)Blocks.largeConstructor).filter = new Seq();
            ((UnitAssembler)Blocks.tankAssembler).plans.add((Object)new UnitAssembler.AssemblerUnitPlan(EUUnitTypes.napoleon, 14400.0f, PayloadStack.list((Object[])new Object[]{UnitTypes.precept, 8, rwl, 20})));
            ((UnitAssembler)Blocks.shipAssembler).plans.add((Object)new UnitAssembler.AssemblerUnitPlan(EUUnitTypes.havoc, 14400.0f, PayloadStack.list((Object[])new Object[]{UnitTypes.obviate, 8, rwl, 20})));
            ((UnitAssembler)Blocks.mechAssembler).plans.add((Object)new UnitAssembler.AssemblerUnitPlan(EUUnitTypes.arcana, 14400.0f, PayloadStack.list((Object[])new Object[]{UnitTypes.anthicus, 8, rwl, 20})));
        }
    }

    public static void overrideUnit1() {
        UnitTypes.corvus.mineTier = 2;
        UnitTypes.corvus.mineSpeed = 7.0f;
        UnitTypes.corvus.buildSpeed = 2.0f;
        UnitTypes.quell.health = 6500.0f;
        UnitTypes.quell.armor = 7.0f;
        UnitTypes.disrupt.health = 13000.0f;
        ((Weapon)UnitTypes.tecta.weapons.get((int)0)).bullet.damage = 60.0f;
        ((Weapon)UnitTypes.tecta.weapons.get((int)0)).bullet.splashDamage = 95.0f;
        UnitTypes.tecta.health = 9000.0f;
        UnitTypes.obviate.hitSize = 20.0f;
    }

    public static void overrideUnitMissile() {
        UnitTypes.quell.targetAir = true;
        ((Weapon)UnitTypes.quell.weapons.get((int)0)).bullet = new CtrlMissile("quell-missile", -1.0f, -1.0f){
            {
                this.shootEffect = Fx.shootBig;
                this.smokeEffect = Fx.shootBigSmoke2;
                this.speed = 4.3f;
                this.keepVelocity = false;
                this.maxRange = 6.0f;
                this.lifetime = 96.0f;
                this.damage = 100.0f;
                this.splashDamage = 100.0f;
                this.splashDamageRadius = 25.0f;
                this.buildingDamageMultiplier = 0.5f;
                this.hitEffect = this.despawnEffect = Fx.massiveExplosion;
                this.trailColor = Pal.sapBulletBack;
            }
        };
        ((Weapon)UnitTypes.quell.weapons.get((int)0)).shake = 1.0f;
        UnitTypes.disrupt.targetAir = true;
        ((Weapon)UnitTypes.disrupt.weapons.get((int)0)).bullet = new CtrlMissile("disrupt-missile", -1.0f, -1.0f){
            {
                this.shootEffect = Fx.sparkShoot;
                this.smokeEffect = Fx.shootSmokeTitan;
                this.hitColor = Pal.suppress;
                this.maxRange = 5.0f;
                this.speed = 4.6f;
                this.keepVelocity = false;
                this.homingDelay = 10.0f;
                this.trailColor = Pal.sapBulletBack;
                this.trailLength = 8;
                this.hitEffect = this.despawnEffect = new ExplosionEffect(){
                    {
                        this.lifetime = 50.0f;
                        this.waveStroke = 5.0f;
                        this.waveLife = 8.0f;
                        this.waveColor = Color.white;
                        this.sparkColor = this.smokeColor = Pal.suppress;
                        this.waveRad = 40.0f;
                        this.smokeSize = 4.0f;
                        this.smokes = 7;
                        this.smokeSizeBase = 0.0f;
                        this.sparks = 10;
                        this.sparkRad = 40.0f;
                        this.sparkLen = 6.0f;
                        this.sparkStroke = 2.0f;
                    }
                };
                this.damage = 135.0f;
                this.splashDamage = 135.0f;
                this.splashDamageRadius = 25.0f;
                this.buildingDamageMultiplier = 0.5f;
                this.parts.add((Object)new ShapePart(){
                    {
                        this.layer = 110.0f;
                        this.circle = true;
                        this.y = -3.5f;
                        this.radius = 1.6f;
                        this.color = Pal.suppress;
                        this.colorTo = Color.white;
                        this.progress = DrawPart.PartProgress.life.curve((Interp)Interp.pow5In);
                    }
                });
            }
        };
        ((Weapon)UnitTypes.disrupt.weapons.get((int)0)).shake = 1.0f;
        ((Weapon)UnitTypes.anthicus.weapons.get((int)0)).bullet = new CtrlMissile("anthicus-missile", -1.0f, -1.0f){
            {
                this.shootEffect = new MultiEffect(new Effect[]{Fx.shootBigColor, new Effect(9.0f, e -> {
                    Draw.color((Color)Color.white, (Color)e.color, (float)e.fin());
                    Lines.stroke((float)(0.7f + e.fout()));
                    Lines.square((float)e.x, (float)e.y, (float)(e.fin() * 5.0f), (float)(e.rotation + 45.0f));
                    Drawf.light((float)e.x, (float)e.y, (float)23.0f, (Color)e.color, (float)(e.fout() * 0.7f));
                }), new WaveEffect(){
                    {
                        this.colorFrom = this.colorTo = Pal.techBlue;
                        this.sizeTo = 15.0f;
                        this.lifetime = 12.0f;
                        this.strokeFrom = 3.0f;
                    }
                }});
                this.smokeEffect = Fx.shootBigSmoke2;
                this.speed = 3.7f;
                this.keepVelocity = false;
                this.inaccuracy = 2.0f;
                this.maxRange = 6.0f;
                this.trailWidth = 2.0f;
                this.trailColor = Pal.techBlue;
                this.low = true;
                this.absorbable = true;
                this.damage = 110.0f;
                this.splashDamage = 110.0f;
                this.splashDamageRadius = 25.0f;
                this.buildingDamageMultiplier = 0.8f;
                this.despawnEffect = this.hitEffect = new MultiEffect(new Effect[]{Fx.massiveExplosion, new WrapEffect(Fx.dynamicSpikes, Pal.techBlue, 24.0f), new WaveEffect(){
                    {
                        this.colorFrom = this.colorTo = Pal.techBlue;
                        this.sizeTo = 40.0f;
                        this.lifetime = 12.0f;
                        this.strokeFrom = 4.0f;
                    }
                }});
                this.parts.add((Object)new FlarePart(){
                    {
                        this.progress = DrawPart.PartProgress.life.slope().curve((Interp)Interp.pow2In);
                        this.radius = 0.0f;
                        this.radiusTo = 35.0f;
                        this.stroke = 3.0f;
                        this.rotation = 45.0f;
                        this.y = -5.0f;
                        this.followRotation = true;
                    }
                });
            }
        };
        ((Weapon)UnitTypes.anthicus.weapons.get((int)0)).shake = 2.0f;
        ((Weapon)UnitTypes.anthicus.weapons.get((int)0)).reload = 120.0f;
    }

    public static void overrideUnitForAll(boolean armor, boolean coreReset) {
        for (int i = 0; i < Vars.content.units().size; ++i) {
            StatusEffect s;
            UnitType u = Vars.content.unit(i);
            if (u != null) {
                if (coreReset) {
                    if (u.shownPlanets.isEmpty()) continue;
                    u.shownPlanets.addAll(Vars.content.planets().copy().removeAll(p -> p == Planets.sun));
                    u.postInit();
                } else {
                    if (u.shownPlanets.isEmpty()) continue;
                    u.shownPlanets.add((Object)TDPlanet.TD);
                    if (u.shownPlanets.contains((Object)Planets.serpulo)) {
                        u.shownPlanets.add((Object)TDPlanet.supEX);
                    }
                    u.postInit();
                }
            }
            if (u != null && armor) {
                u.armor = Math.min(u.armor, 80.0f);
                u.health = Math.min(u.health, 130000.0f);
            }
            if (u == null || !(u.buildSpeed > 0.0f) || (s = Vars.content.statusEffect("new-horizon-scanner-down")) == null) continue;
            u.immunities.add((Object)s);
        }
    }

    public static void ap4sOverride() {
        Seq sc = Vars.content.blocks().copy();
        sc.removeAll(b -> b.localizedName == null || b.description == null);
        for (int i = 0; i < sc.size; ++i) {
            Block b2 = (Block)sc.get(i);
            if (b2 == null) continue;
            String l = b2.localizedName;
            String n = b2.description;
            int d = Mathf.random((int)(sc.size - 1));
            while (d == i) {
                d = Mathf.random((int)(sc.size - 1));
            }
            Block b1 = (Block)sc.get(d);
            if (b1 == null) continue;
            b2.localizedName = b1.localizedName;
            b2.description = b1.description;
            b1.localizedName = l;
            b1.description = n;
        }
        Seq ic = Vars.content.items().copy();
        ic.removeAll(it -> it.localizedName == null || it.description == null);
        for (int i = 0; i < ic.size; ++i) {
            Item b3 = (Item)ic.get(i);
            if (b3 == null) continue;
            String l = b3.localizedName;
            String n = b3.description;
            int d = Mathf.random((int)(ic.size - 1));
            while (d == i) {
                d = Mathf.random((int)(ic.size - 1));
            }
            Item b1 = (Item)ic.get(d);
            if (b1 == null) continue;
            b3.localizedName = b1.localizedName;
            b3.description = b1.description;
            b1.localizedName = l;
            b1.description = n;
        }
        Seq uc = Vars.content.units().copy();
        uc.removeAll(u -> u.localizedName == null || u.description == null);
        for (int i = 0; i < uc.size; ++i) {
            UnitType b4 = (UnitType)uc.get(i);
            if (b4 == null) continue;
            String l = b4.localizedName;
            String n = b4.description;
            int d = Mathf.random((int)(uc.size - 1));
            while (d == i) {
                d = Mathf.random((int)(uc.size - 1));
            }
            UnitType b1 = (UnitType)uc.get(d);
            if (b1 == null) continue;
            b4.localizedName = b1.localizedName;
            b4.description = b1.description;
            b1.localizedName = l;
            b1.description = n;
        }
    }

    public static void overrideVersion() {
        for (int i = 0; i < Vars.mods.list().size; ++i) {
            Mods.LoadedMod mod = (Mods.LoadedMod)Vars.mods.list().get(i);
            if (mod == null) continue;
            mod.meta.description = Core.bundle.get("mod.extra-utilities.version") + mod.meta.version + "\n\n" + mod.meta.description;
        }
    }

    public static void overrideJs() {
        ((ItemTurret)Blocks.swarmer).ammoTypes.put((Object)Items.graphite, (Object)new MissileBulletType(3.2f, 10.0f){
            {
                this.width = 7.0f;
                this.height = 8.0f;
                this.shrinkY = 0.0f;
                this.homingPower = 0.08f;
                this.reloadMultiplier = 1.2f;
                this.splashDamageRadius = 25.0f;
                this.splashDamage = 20.0f;
                this.hitEffect = this.despawnEffect = Fx.blastExplosion;
                if (Core.atlas != null) {
                    this.backRegion = Core.atlas.find("missile-back");
                    this.frontRegion = Core.atlas.find("missile");
                }
            }
        });
        ((ItemTurret)Blocks.swarmer).limitRange(5.0f);
        ItemTurret miniSw = (ItemTurret)Vars.content.block(ExtraUtilitiesMod.name("mini-swarmer"));
        ItemTurret T2Sw = (ItemTurret)Vars.content.block(ExtraUtilitiesMod.name("T2-swarmer"));
        ObjectMap ammo = ((ItemTurret)Blocks.swarmer).ammoTypes;
        Seq is = ammo.keys().toSeq();
        for (Item i : is) {
            miniSw.ammoTypes.put((Object)i, (Object)((BulletType)ammo.get((Object)i)).copy());
            T2Sw.ammoTypes.put((Object)i, (Object)((BulletType)ammo.get((Object)i)).copy());
        }
        miniSw.limitRange(5.0f);
        T2Sw.limitRange(5.0f);
        ShrapnelBulletType sp = new ShrapnelBulletType(){
            {
                this.length = 100.0f;
                this.damage = 84 - (ExtraUtilitiesMod.hardMod ? 10 : 0);
                this.width = 17.0f;
                this.reloadMultiplier = 1.2f;
                this.ammoMultiplier = 8.0f;
                this.toColor = EUItems.lightninAlloy.color.cpy().mul(Pal.surge);
                this.shootEffect = this.smokeEffect = Fx.none;
                this.fragBullet = new liLaserBullet(this.damage / 2.0f){
                    {
                        super(arg0);
                        this.length = 100.0f;
                        this.lifetime = 15.0f;
                        this.width = 18.0f;
                        this.colors = new Color[]{EUItems.lightninAlloy.color.cpy().a(0.5f), EUItems.lightninAlloy.color, Color.white};
                        this.spacing = 4;
                        this.status = StatusEffects.shocked;
                        this.color = EUItems.lightninAlloy.color;
                        this.lAmount = 1;
                        this.chain = new ChainLightningFade(this.lifetime, -1.0f, 2.5f, this.color, 20.0f, this.hitEffect);
                    }
                };
                this.fragAngle = 3.0f;
                this.fragBullets = 2;
                this.fragSpread = 6.0f;
                this.fragRandomSpread = 0.0f;
            }

            public void init(Bullet b) {
                super.init(b);
                this.createFrags(b, b.x, b.y);
            }
        };
        ((ItemTurret)Blocks.fuse).ammoTypes.put((Object)EUItems.crispSteel, (Object)new ShrapnelBulletType(){
            {
                this.length = 100.0f;
                this.damage = 66.0f;
                this.width = 17.0f;
                this.reloadMultiplier = 2.0f;
                this.ammoMultiplier = 6.0f;
                this.toColor = Color.blue.cpy().mul(EUItems.crispSteel.color);
            }
        });
        ((ItemTurret)Blocks.fuse).ammoTypes.put((Object)EUItems.lightninAlloy, (Object)sp);
        ItemTurret T2fuse = (ItemTurret)Vars.content.block(ExtraUtilitiesMod.name("T2-fuse"));
        ItemTurret T3fuse = (ItemTurret)Vars.content.block(ExtraUtilitiesMod.name("T3-fuse"));
        ObjectMap ammo2 = ((ItemTurret)Blocks.fuse).ammoTypes;
        Seq is2 = ammo2.keys().toSeq();
        for (Item i : is2) {
            BulletType bsp = (BulletType)ammo2.get((Object)i);
            BulletType bt = bsp.copy();
            bt.damage += 1.0f;
            ShrapnelBulletType b1 = (ShrapnelBulletType)bt;
            b1.length = T2fuse.range + bt.rangeChange + 12.0f;
            if (bsp == sp) {
                bt.fragBullet = sp.fragBullet.copy();
                bt.fragBullet.damage += 1.0f;
                ((liLaserBullet)bt.fragBullet).length = T2fuse.range + bt.rangeChange + 12.0f;
            }
            T2fuse.ammoTypes.put((Object)i, (Object)bt);
            BulletType bt2 = bsp.copy();
            bt2.damage += 3.0f;
            ShrapnelBulletType b2 = (ShrapnelBulletType)bt2;
            b2.length = T3fuse.range + bt2.rangeChange + 16.0f;
            if (bsp == sp) {
                bt2.fragBullet = sp.fragBullet.copy();
                bt2.fragBullet.damage += 2.0f;
                ((liLaserBullet)bt2.fragBullet).length = T3fuse.range + bt2.rangeChange + 16.0f;
            }
            T3fuse.ammoTypes.put((Object)i, (Object)bt2);
        }
    }

    public static void overrideItem() {
        Items.serpuloItems.addAll((Object[])new Item[]{EUItems.crispSteel, EUItems.lightninAlloy});
        Items.erekirItems.add((Object)EUItems.lightninAlloy);
    }

    public static void overrideHard() {
        for (UnitType u : Vars.content.units()) {
            if (u == null) continue;
            u.health = (float)Math.ceil(u.health * 1.3f);
        }
        Block T2duo = Vars.content.block(ExtraUtilitiesMod.name("T2-duo"));
        EUOverride.changeInHard(T2duo);
        Block T3duo = Vars.content.block(ExtraUtilitiesMod.name("T3-duo"));
        EUOverride.changeInHard(T3duo);
        Block magstorm = Vars.content.block(ExtraUtilitiesMod.name("magstorm"));
        EUOverride.changeInHard(magstorm);
        Block sancta = Vars.content.block(ExtraUtilitiesMod.name("sancta"));
        EUOverride.changeInHard(sancta);
    }

    private static void changeInHard(Block block) {
        String nam = Core.bundle.getOrNull("block." + block.name + "-hard.name");
        String des = Core.bundle.getOrNull("block." + block.name + "-hard.description");
        String dtl = Core.bundle.getOrNull("block." + block.name + "-hard.details");
        if (nam != null) {
            block.localizedName = nam;
        }
        if (des != null) {
            block.description = des;
        }
        block.details = dtl;
    }
}

