/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.content;

import ExtraUtilities.content.EUGet;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.units.StatusEntry;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class EUStatusEffects {
    public static Seq<StatusEffect> elements = new Seq();
    public static StatusEffect poison = new StatusEffect("poison"){
        {
            this.transitionDamage = 156.0f;
            this.color = Color.valueOf((String)"#cbd97f");
            this.speedMultiplier = 0.4f;
            this.damage = 2.0f;
            this.healthMultiplier = 0.7f;
            this.effect = Fx.oily;
            this.init(() -> this.affinity(StatusEffects.sapped, (unit, result, time) -> {
                unit.damagePierce(this.transitionDamage);
                Fx.oily.at(unit.x + Mathf.range((float)(unit.bounds() / 2.0f)), unit.y + Mathf.range((float)(unit.bounds() / 2.0f)));
                result.set(poison, Math.min(time + result.time, 200.0f));
            }));
        }
    };
    public static StatusEffect speedUp = new StatusEffect("speedUp"){
        {
            this.color = Color.valueOf((String)"ea8878");
            this.buildSpeedMultiplier = 2.0f;
            this.speedMultiplier = 1.3f;
            this.reloadMultiplier = 2.0f;
            this.damage = -0.2f;
            this.effectChance = 0.07f;
            this.effect = Fx.overclocked;
        }
    };
    public static StatusEffect speedDown = new StatusEffect("speedDown"){
        {
            this.color = Color.valueOf((String)"8b9bb4");
            this.speedMultiplier = 0.4f;
            this.reloadMultiplier = 0.5f;
            this.damage = 0.25f;
            this.effectChance = 0.07f;
            this.effect = Fx.overclocked;
        }
    };
    public static StatusEffect regenBoost = new StatusEffect("regenBoost"){
        {
            this.color = Pal.heal;
            this.reloadMultiplier = 1.2f;
            this.damage = -1.3333334f;
            this.healthMultiplier = 1.5f;
            this.effect = Fx.none;
        }
    };
    public static StatusEffect fireSpeedUp = new StatusEffect("fireSpeedUp"){
        {
            this.color = Color.valueOf((String)"fa1111");
            this.reloadMultiplier = 1.5f;
            this.effect = Fx.none;
        }
    };
    public static StatusEffect fireDamageUp = new StatusEffect("fireDamageUp"){
        {
            this.color = Color.valueOf((String)"fa1112");
            this.damageMultiplier = 2.0f;
            this.effect = Fx.none;
        }
    };
    public static StatusEffect defenseUp = new StatusEffect("defenseUp"){
        {
            this.color = Color.valueOf((String)"fa1113");
            this.healthMultiplier = 1.3f;
            this.effect = Fx.none;
        }
    };
    public static StatusEffect EUUnmoving = new StatusEffect("unmoving"){
        {
            this.color = Pal.gray;
            this.speedMultiplier = 0.0f;
        }
    };
    public static StatusEffect EUDisarmed = new StatusEffect("disarmed"){
        {
            this.color = Color.valueOf((String)"e9ead3");
            this.disarm = true;
        }
    };
    public static StatusEffect awsl = new StatusEffect("awsl"){
        {
            this.disarm = true;
            this.speedMultiplier = 0.0f;
            this.applyEffect = new Effect(60.0f, e -> {
                int i = 0;
                while (i < 10) {
                    float dx = EUGet.dx(e.x, 6.0f, e.time * 12.0f + (float)(i * 8));
                    float dy = EUGet.dy(e.y, 6.0f, e.time * 12.0f + (float)(i * 8));
                    int finalI = i++;
                    e.scaled(60.0f, b -> {
                        Draw.color((Color)Pal.accent);
                        Fill.circle((float)dx, (float)dy, (float)(2.0f * (float)finalI / 10.0f + 0.2f));
                    });
                }
            });
        }
    };
    public static StatusEffect flamePoint = new StatusEffect("flame-point"){
        {
            this.damage = 0.2f;
            this.color = Pal.lightFlame;
            this.parentizeEffect = true;
            this.effect = new Effect(36.0f, e -> {
                Object patt3906$temp = e.data;
                if (!(patt3906$temp instanceof Unit)) {
                    return;
                }
                Unit unit = (Unit)patt3906$temp;
                Lines.stroke((float)(2.0f * e.foutpow()), (Color)Items.blastCompound.color);
                for (int i = 0; i < 3; ++i) {
                    float a = 120.0f * (float)i + e.time * 6.0f;
                    float x = EUGet.dx(e.x, Math.max(6.0f, unit.hitSize / 2.0f), a);
                    float y = EUGet.dy(e.y, Math.max(6.0f, unit.hitSize / 2.0f), a);
                    Lines.lineAngle((float)x, (float)y, (float)(a - 120.0f), (float)(Math.max(3.0f, unit.hitSize / 4.0f) * e.foutpow()));
                    Lines.lineAngle((float)x, (float)y, (float)(a + 120.0f), (float)(Math.max(3.0f, unit.hitSize / 4.0f) * e.foutpow()));
                }
            });
            this.speedMultiplier = 0.9f;
        }

        public void update(Unit unit, StatusEntry entry) {
            if (this.damage > 0.0f) {
                unit.damageContinuousPierce(this.damage);
            } else if (this.damage < 0.0f) {
                unit.heal(-1.0f * this.damage * Time.delta);
            }
            if (this.effect != Fx.none && Mathf.chanceDelta((double)this.effectChance)) {
                this.effect.at(unit.x, unit.y, 0.0f, this.color, this.parentizeEffect ? unit : null);
            }
        }
    };
    public static StatusEffect starFlame = new StatusEffect("star-flame"){
        {
            this.damage = 1.0f;
            this.color = Pal.thoriumPink;
            this.effectChance = 0.03f;
            this.effect = new Effect(24.0f, e -> Angles.randLenVectors((long)e.id, (int)3, (float)(13.0f * e.finpow()), (float)e.rotation, (float)180.0f, (x, y) -> {
                Draw.color((Color)Tmp.c4.set(EUGet.rainBowRed).shiftHue(Mathf.randomSeed((long)e.id, (float)360.0f) + x * x + y * y + e.time * 2.0f));
                Drawf.tri((float)(e.x + x), (float)(e.y + y), (float)(3.0f * e.foutpow()), (float)7.0f, (float)(e.rotation + 90.0f));
                Drawf.tri((float)(e.x + x), (float)(e.y + y), (float)(3.0f * e.foutpow()), (float)7.0f, (float)(e.rotation - 90.0f));
                Drawf.tri((float)(e.x + x), (float)(e.y + y), (float)(3.0f * e.foutpow()), (float)5.0f, (float)e.rotation);
                Drawf.tri((float)(e.x + x), (float)(e.y + y), (float)(3.0f * e.foutpow()), (float)5.0f, (float)(e.rotation + 180.0f));
            }));
        }
    };
    public static StatusEffect breakage = new StatusEffect("breakage"){
        {
            this.damage = -1.0f;
            this.parentizeApplyEffect = true;
            this.applyColor = Pal.techBlue;
            this.applyEffect = new Effect(45.0f, e -> {
                float ly;
                float lx;
                float a;
                int i;
                Object patt5928$temp = e.data;
                if (!(patt5928$temp instanceof Unit)) {
                    return;
                }
                Unit u = (Unit)patt5928$temp;
                float size = u.hitSize * 2.0f;
                Fx.rand.setSeed((long)e.id);
                float pin = 1.0f - e.foutpow();
                Lines.stroke((float)(size / 24.0f * e.foutpow()), (Color)e.color);
                Lines.circle((float)e.x, (float)e.y, (float)(size * pin));
                for (i = 0; i < 5; ++i) {
                    a = Fx.rand.random(180);
                    lx = EUGet.dx(e.x, size * pin, a);
                    ly = EUGet.dy(e.y, size * pin, a);
                    Drawf.tri((float)lx, (float)ly, (float)(size / 32.0f * e.foutpow()), (float)((size + Fx.rand.random(-size, size)) * e.foutpow()), (float)(a + 180.0f));
                }
                for (i = 0; i < 5; ++i) {
                    a = 180 + Fx.rand.random(180);
                    lx = EUGet.dx(e.x, size * pin, a);
                    ly = EUGet.dy(e.y, size * pin, a);
                    Drawf.tri((float)lx, (float)ly, (float)(size / 32.0f * e.foutpow()), (float)((size + Fx.rand.random(-size, size)) * e.foutpow()), (float)(a + 180.0f));
                }
            });
        }

        public void setStats() {
            super.setStats();
            this.stats.remove(Stat.healing);
            this.stats.addMultModifier(Stat.damageMultiplier, 0.8f);
            this.stats.addMultModifier(Stat.speedMultiplier, 0.4f);
            this.stats.addMultModifier(Stat.reloadMultiplier, 0.5f);
            this.stats.add(Stat.damage, 60.0f, StatUnit.perSecond);
        }

        public void applied(Unit unit, float time, boolean extend) {
            super.applied(unit, time, extend);
            unit.health -= 100.0f;
        }

        public void update(Unit unit, StatusEntry entry) {
            unit.damageMultiplier *= 0.8f;
            unit.speedMultiplier *= 0.4f;
            unit.reloadMultiplier *= 0.5f;
            unit.health -= Time.delta;
            if (this.effect != Fx.none && Mathf.chanceDelta((double)this.effectChance)) {
                Tmp.v1.rnd(Mathf.range((float)(unit.type.hitSize / 2.0f)));
                this.effect.at(unit.x + Tmp.v1.x, unit.y + Tmp.v1.y, 0.0f, this.color, this.parentizeEffect ? unit : null);
            }
        }
    };

    public static void load() {
        elements.addAll((Object[])new StatusEffect[]{breakage});
    }
}

