/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.distribution;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.worlds.drawer.DrawInvertedJunction;
import ExtraUtilities.worlds.meta.BufferItem;
import ExtraUtilities.worlds.meta.DirectionalItemBuffer;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;
import mindustry.world.meta.BlockGroup;

public class InvertedJunction
extends Block {
    public String placeSprite;
    public DrawBlock drawer = new DrawInvertedJunction();
    public final int size = 1;
    public Color[] colors = new Color[]{Color.valueOf((String)"bf92f9"), Color.valueOf((String)"c0ecff"), Color.valueOf((String)"84f491"), Color.valueOf((String)"fffa763")};
    public TextureRegion arrow1;
    public TextureRegion arrow2;
    public TextureRegion place;
    public float speed = 26.0f;
    public int capacity = 6;

    public InvertedJunction(String name) {
        super(name);
        this.update = true;
        this.solid = false;
        this.underBullets = true;
        this.group = BlockGroup.transportation;
        this.unloadable = false;
        this.floating = true;
        this.noUpdateDisabled = true;
        this.sync = true;
        this.configurable = true;
        this.config(Integer.class, (build, loc) -> {
            build.loc = loc;
        });
    }

    public void load() {
        super.load();
        this.arrow1 = Core.atlas.find(ExtraUtilitiesMod.name("arrow-1"));
        this.arrow2 = Core.atlas.find(ExtraUtilitiesMod.name("arrow-2"));
        this.place = Core.atlas.find(this.placeSprite);
    }

    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        if (plan.config == null) {
            return;
        }
        Draw.rect((TextureRegion)this.place, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)Core.atlas.find(ExtraUtilitiesMod.ModName + "-junction-" + plan.config), (float)plan.drawx(), (float)plan.drawy());
        Draw.color();
    }

    public boolean outputsItems() {
        return true;
    }

    public class InvertedJunctionBuild
    extends Building {
        public DirectionalItemBuffer buffer;
        public int loc;

        public InvertedJunctionBuild() {
            this.buffer = new DirectionalItemBuffer(InvertedJunction.this.capacity);
            this.loc = 1;
        }

        public void configured(Unit player, Object value) {
            super.configured(player, value);
            this.loc = (Integer)value;
        }

        public void updateTile() {
            for (int i = 0; i < 4; ++i) {
                long l;
                float time;
                int p = (i + this.loc) % 4;
                if (this.buffer.indexes[i] <= 0) continue;
                if (this.buffer.indexes[i] > InvertedJunction.this.capacity) {
                    this.buffer.indexes[i] = InvertedJunction.this.capacity;
                }
                if (!(Time.time >= (time = BufferItem.time(l = this.buffer.buffers[i][0])) + InvertedJunction.this.speed / this.timeScale) && !(Time.time < time)) continue;
                Item item = Vars.content.item((int)BufferItem.item(l));
                Building dest = this.nearby(p);
                if (item == null || dest == null || !dest.acceptItem((Building)this, item) || dest.team != this.team) continue;
                dest.handleItem((Building)this, item);
                System.arraycopy(this.buffer.buffers[i], 1, this.buffer.buffers[i], 0, this.buffer.indexes[i] - 1);
                int n = i;
                this.buffer.indexes[n] = this.buffer.indexes[n] - 1;
            }
        }

        public void draw() {
            InvertedJunction.this.drawer.draw((Building)this);
        }

        public boolean acceptItem(Building source, Item item) {
            byte relative = source.relativeTo(this.tile);
            if (relative == -1 || !this.buffer.accepts(relative)) {
                return false;
            }
            Building to = this.nearby((relative + this.loc) % 4);
            return to != null && to.team == this.team;
        }

        public int acceptStack(Item item, int amount, Teamc source) {
            return 0;
        }

        public void handleItem(Building source, Item item) {
            byte relative = source.relativeTo(this.tile);
            this.buffer.accept(relative, item);
        }

        public void drawSelect() {
            super.drawSelect();
            float sin = Mathf.sin((float)Time.time, (float)6.0f, (float)0.6f);
            for (int i = 0; i < 4; ++i) {
                Draw.color((Color)InvertedJunction.this.colors[i]);
                int in = this.loc == 1 ? 3 : 1;
                int input = (i + in) % 4;
                Draw.rect((TextureRegion)InvertedJunction.this.arrow1, (float)(this.x + (float)Geometry.d4x((int)i) * (8.0f + sin)), (float)(this.y + (float)Geometry.d4y((int)i) * (8.0f + sin)), (float)(90 * i));
                Draw.rect((TextureRegion)InvertedJunction.this.arrow2, (float)(this.x + (float)Geometry.d4x((int)input) * (8.0f - sin)), (float)(this.y + (float)Geometry.d4y((int)input) * (8.0f - sin)), (float)(90 * input));
                Draw.color();
            }
        }

        public void buildConfiguration(Table table) {
            table.button((Drawable)new TextureRegionDrawable(Core.atlas.find(ExtraUtilitiesMod.ModName + "-flip", (TextureRegion)Core.atlas.find("clear"))), Styles.cleari, this::switchf).size(36.0f).tooltip("switch");
        }

        public void switchf() {
            this.loc = this.loc == 1 ? 3 : 1;
            this.deselect();
            this.configure(this.loc);
        }

        public Integer config() {
            return this.loc;
        }

        public void write(Writes write) {
            super.write(write);
            this.buffer.write(write);
            write.i(this.loc);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.buffer.read(read);
            this.loc = read.i();
        }
    }
}

