/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.distribution;

import ExtraUtilities.worlds.drawer.DrawPhaseNode;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Circle;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawMulti;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class PhaseNode
extends ItemBridge {
    public DrawBlock drawer = new DrawMulti(new DrawBlock[]{new DrawDefault(), new DrawPhaseNode()});

    public PhaseNode(String name) {
        super(name);
        this.swapDiagonalPlacement = true;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPotentialLinks(x, y);
        this.drawOverlay((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, rotation);
        Drawf.dashCircle((float)(x * 8), (float)(y * 8), (float)(this.range * 8), (Color)Pal.accent);
    }

    public boolean linkValid(Tile tile, Tile other, boolean checkDouble) {
        if (other == null || tile == null || other == tile) {
            return false;
        }
        if (!tile.within((Position)other, (float)((this.range + this.size) * 8))) {
            return false;
        }
        return (other.block() == tile.block() && tile.block() == this || !(tile.block() instanceof PhaseNode) && other.block() == this) && (other.team() == tile.team() || tile.block() != this) && (!checkDouble || ((PhaseNodeBuild)other.build).link != tile.pos());
    }

    public Tile findLink(int x, int y) {
        return null;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, (float)this.range, StatUnit.blocks);
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    public boolean overlaps(@Nullable Tile src, @Nullable Tile other) {
        if (src == null || other == null) {
            return true;
        }
        return Intersector.overlaps((Circle)Tmp.cr1.set(src.worldx() + this.offset, src.worldy() + this.offset, (float)(this.range * 8)), (Rect)Tmp.r1.setSize((float)(this.size * 8)).setCenter(other.worldx() + this.offset, other.worldy() + this.offset));
    }

    public boolean positionsValid(int x1, int y1, int x2, int y2) {
        return Mathf.dst((float)x1, (float)y1, (float)x2, (float)y2) <= (float)((this.range + this.size) * 8);
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> this.overlaps(Vars.world.tile(point.x, point.y), Vars.world.tile(other.x, other.y)));
    }

    public class PhaseNodeBuild
    extends ItemBridge.ItemBridgeBuild {
        public PhaseNodeBuild() {
            super((ItemBridge)PhaseNode.this);
        }

        public void updateTile() {
            Building other = Vars.world.build(this.link);
            if (other != null && !PhaseNode.this.linkValid(this.tile, other.tile)) {
                this.link = -1;
            }
            super.updateTile();
        }

        public void updateTransport(Building other) {
            if (PhaseNode.this.hasItems) {
                super.updateTransport(other);
            }
            if (PhaseNode.this.hasLiquids && this.warmup >= 0.25f) {
                this.moved |= this.moveLiquid(other, this.liquids.current()) > 0.05f;
            }
        }

        public void doDump() {
            if (PhaseNode.this.hasItems) {
                int i = 0;
                while ((float)i < (float)this.items.total() / PhaseNode.this.transportTime) {
                    this.dumpAccumulate();
                    ++i;
                }
            }
            if (PhaseNode.this.hasLiquids) {
                this.dumpLiquid(this.liquids.current(), 1.0f);
            }
        }

        public void drawConfigure() {
            float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f);
            Draw.color((Color)Pal.accent);
            Lines.stroke((float)1.0f);
            Drawf.circles((float)this.x, (float)this.y, (float)(((float)this.block.size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.accent);
            Building other = Vars.world.build(this.link);
            if (other != null) {
                Drawf.circles((float)other.x, (float)other.y, (float)(((float)this.block.size / 3.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.place);
                Drawf.arrow((float)this.x, (float)this.y, (float)other.x, (float)other.y, (float)((float)(this.block.size * 8) + sin), (float)(4.0f + sin), (Color)Pal.accent);
            }
            Drawf.dashCircle((float)this.x, (float)this.y, (float)(PhaseNode.this.range * 8), (Color)Pal.accent);
        }

        public void draw() {
            PhaseNode.this.drawer.draw((Building)this);
        }

        protected boolean checkAccept(Building source, Tile other) {
            if (this.tile == null || this.linked(source)) {
                return true;
            }
            return PhaseNode.this.linkValid(this.tile, other);
        }

        protected boolean checkDump(Building to) {
            return true;
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (other == this) {
                this.configure(-1);
            }
            return super.onConfigureBuildTapped(other);
        }
    }
}

