/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.effect;

import ExtraUtilities.content.EUFx;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.modules.ItemModule;

public class CoreKeeper
extends StorageBlock {
    public float warmupSpeed;
    public float downSpeed;
    public int range = 15;
    public DrawBlock drawer = new DrawDefault();
    private final String[] load = new String[]{"loading", "loading .", "loading ..", "loading ..."};

    public CoreKeeper(String name) {
        super(name);
        this.update = true;
        this.hasItems = true;
        this.itemCapacity = 0;
        this.configurable = true;
        this.replaceable = false;
        this.warmupSpeed = 0.01f;
        this.downSpeed = 0.04f;
        this.canOverdrive = false;
        this.buildCostMultiplier = 0.0f;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        if (Vars.state.rules.infiniteResources) {
            return;
        }
        if (Vars.world.tile(x, y) != null && !this.canPlaceOn(Vars.world.tile(x, y), Vars.player.team(), rotation)) {
            this.drawPlaceText(Core.bundle.get(Vars.player.team().core() != null && Vars.player.team().core().items.has(this.requirements, Vars.state.rules.buildCostMultiplier) || Vars.state.rules.infiniteResources ? "bar.extra-utilities-close" : "bar.noresources"), x, y, valid);
        }
        Drawf.square((float)(x *= 8), (float)(y *= 8), (float)((float)(this.range * 8) * 1.414f), (float)90.0f, (Color)Vars.player.team().color);
    }

    public Rect getRect(Rect rect, float x, float y, float range) {
        rect.setCentered(x, y, range * 2.0f * 8.0f);
        return rect;
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        if (Vars.state.rules.infiniteResources) {
            return true;
        }
        CoreBlock.CoreBuild core = team.core();
        if (core == null || !Vars.state.rules.infiniteResources && !core.items.has(this.requirements, Vars.state.rules.buildCostMultiplier)) {
            return false;
        }
        Rect rect = this.getRect(Tmp.r1, tile.worldx() + this.offset, tile.worldy() + this.offset, this.range).grow(0.1f);
        return !Vars.indexer.getFlagged(team, BlockFlag.storage).contains(b -> {
            if (b instanceof CoreKeeperBuild) {
                CoreKeeperBuild build = (CoreKeeperBuild)((Object)b);
                CoreKeeper block = (CoreKeeper)b.block;
                return this.getRect(Tmp.r2, build.x, build.y, block.range).overlaps(rect);
            }
            return false;
        });
    }

    public boolean isAccessible() {
        return true;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, Core.bundle.format("stat.core-keeper-range", new Object[]{this.range}), new Object[0]);
    }

    public void setBars() {
        super.setBars();
        this.addBar("warmup", entity -> new Bar(() -> (double)entity.warmup() > 0.999 ? "complete" : this.load[(int)(Time.time / (float)(this.load.length * 10)) % this.load.length], () -> Color.valueOf((String)"ffd06d"), entity::warmup));
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    public class CoreKeeperBuild
    extends StorageBlock.StorageBuild {
        public float warmup;
        public float progress;
        public boolean dw;
        public transient Trail trail;

        public CoreKeeperBuild() {
            super((StorageBlock)CoreKeeper.this);
            this.dw = false;
            this.trail = new Trail(50);
        }

        public boolean canPickup() {
            return false;
        }

        public void updateTile() {
            boolean work = false;
            if (this.efficiency > 0.0f && this.core() != null) {
                if (Mathf.equal((float)this.warmup, (float)1.0f, (float)0.01f)) {
                    this.warmup = 1.0f;
                    work = true;
                } else {
                    this.warmup = Mathf.lerpDelta((float)this.warmup, (float)1.0f, (float)CoreKeeper.this.warmupSpeed);
                }
            } else {
                this.warmup = Mathf.equal((float)this.warmup, (float)0.0f, (float)0.01f) ? 0.0f : Mathf.lerpDelta((float)this.warmup, (float)0.0f, (float)CoreKeeper.this.downSpeed);
            }
            this.progress += Time.delta * this.warmup * this.efficiency;
            if (work) {
                if (this.linkedCore == null || !this.linkedCore.isValid()) {
                    this.linkedCore = this.core();
                    this.items = this.linkedCore.items;
                }
                if (!this.dw) {
                    EUFx.diffuse.at(this.x, this.y, 0.0f, this.team.color, (Object)CoreKeeper.this.size);
                    this.dw = true;
                }
            } else {
                this.linkedCore = null;
                this.items = new ItemModule();
                this.dw = false;
            }
        }

        public void draw() {
            super.draw();
            CoreKeeper.this.drawer.draw((Building)this);
        }

        public void drawSelect() {
        }

        public void drawConfigure() {
            float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f);
            Draw.color((Color)Pal.accent);
            Lines.stroke((float)1.0f);
            Drawf.circles((float)this.x, (float)this.y, (float)(((float)CoreKeeper.this.size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.accent);
            if (this.linkedCore != null && this.linkedCore.block != null) {
                float px = this.x - (float)(CoreKeeper.this.size * 8) / 2.0f;
                float py = this.y + (float)(CoreKeeper.this.size * 8) / 2.0f;
                Draw.rect((TextureRegion)this.linkedCore.block.uiIcon, (float)px, (float)py, (float)8.0f, (float)8.0f);
                Drawf.arrow((float)px, (float)py, (float)this.linkedCore.x, (float)this.linkedCore.y, (float)(8.0f + sin), (float)(2.0f + sin));
            }
        }

        public float warmup() {
            return this.warmup;
        }

        public float progress() {
            return this.progress;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.warmup);
            write.bool(this.dw);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.warmup = read.f();
            this.dw = read.bool();
        }
    }
}

