/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.effect;

import ExtraUtilities.net.EUCall;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.entities.Effect;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;

public class WaterBomb
extends Block {
    public int fillSize = 3;
    public float readyTime = 300.0f;
    public boolean forceFill = true;
    public Effect fillEffect = new Effect(60.0f, e -> {
        Draw.color((Color)Tmp.c4.set(Pal.accent).a(e.foutpow()));
        float size = 8.0f * Math.min(1.0f, 3.0f * e.finpow());
        Fill.rect((float)e.x, (float)e.y, (float)size, (float)size);
    });

    public WaterBomb(String name) {
        super(name);
        this.size = 1;
        this.placeableLiquid = true;
        this.floating = true;
        this.destructible = true;
        this.update = true;
        this.rebuildable = false;
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return tile != null && tile.floor() != null && tile.floor().isDeep();
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Lines.stroke((float)1.4f, (Color)(valid ? Pal.accent : Pal.remove));
        Lines.square((float)(x * 8), (float)(y * 8), (float)((float)this.fillSize / 2.0f * 8.0f));
    }

    public class WaterBombBuild
    extends Building {
        public float ready = 0.0f;

        public void updateTile() {
            this.ready += Time.delta;
            if (this.ready >= WaterBomb.this.readyTime) {
                this.boom();
                this.kill();
            }
        }

        private void boom() {
            short tx = this.tile.x;
            short ty = this.tile.y;
            int range = WaterBomb.this.fillSize / 2;
            for (int fx = -range; fx <= range; ++fx) {
                for (int fy = -range; fy <= range; ++fy) {
                    Tile ft = Vars.world.tile(tx + fx, ty + fy);
                    if (ft == null || ft.floor() == null || !ft.floor().isDeep()) continue;
                    WaterBomb.this.fillEffect.at(ft.worldx(), ft.worldy());
                    EUCall.setFloor(ft, Blocks.metalFloor);
                }
            }
        }

        public void draw() {
            super.draw();
            int s = Mathf.ceil((float)((WaterBomb.this.readyTime - this.ready) / 60.0f));
            String text = "|" + s + "|";
            Fonts.def.draw((CharSequence)text, this.x, this.y, Color.red, 0.35f, true, 1);
            Draw.color((Color)Pal.gray);
            Draw.alpha((float)0.4f);
            Fill.rect((float)this.x, (float)this.y, (float)(WaterBomb.this.fillSize * 8), (float)(WaterBomb.this.fillSize * 8));
        }
    }
}

