/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.heat;

import ExtraUtilities.ExtraUtilitiesMod;
import arc.Core;
import arc.math.Mathf;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.heat.HeatBlock;
import mindustry.world.blocks.power.ThermalGenerator;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawHeatOutput;
import mindustry.world.draw.DrawMulti;
import mindustry.world.meta.Stat;

public class ThermalHeater
extends ThermalGenerator {
    public float basicHeatOut = 5.0f;
    public float warmupRate = 0.15f;
    public float sec = 1.0f;

    public ThermalHeater(String name) {
        super(name);
        this.drawer = new DrawMulti(new DrawBlock[]{new DrawDefault(), new DrawHeatOutput()});
        this.rotateDraw = false;
        this.rotate = true;
        this.canOverdrive = false;
        this.drawArrow = true;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, Core.bundle.format("stat." + ExtraUtilitiesMod.name("basicHeat"), new Object[]{Float.valueOf(this.basicHeatOut * this.sec)}), new Object[0]);
    }

    public void setBars() {
        super.setBars();
        this.addBar("heat", entity -> new Bar("bar.heat", Pal.lightOrange, () -> entity.heat > 0.0f ? 1.0f : 0.0f));
    }

    public class ThermalHeaterBuild
    extends ThermalGenerator.ThermalGeneratorBuild
    implements HeatBlock {
        public float heat;

        public ThermalHeaterBuild() {
            super((ThermalGenerator)ThermalHeater.this);
        }

        public void updateTile() {
            super.updateTile();
            this.heat = Mathf.approachDelta((float)this.heat, (float)(ThermalHeater.this.basicHeatOut * this.efficiency * this.productionEfficiency), (float)(ThermalHeater.this.warmupRate * this.delta()));
        }

        public float heatFrac() {
            return this.heat / ThermalHeater.this.basicHeatOut;
        }

        public float heat() {
            return this.heat;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.heat);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.heat = read.f();
        }
    }
}

