/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.liquid;

import ExtraUtilities.worlds.drawer.DrawLiquidDriver;
import ExtraUtilities.worlds.entity.bullet.LiquidMassDriverBolt;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.struct.OrderedSet;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class LiquidMassDriver
extends Block {
    public float range;
    public float rotateSpeed = 5.0f;
    public float translation = 7.0f;
    public int minDistribute = 50;
    public float knockback = 4.0f;
    public float reload = 100.0f;
    public LiquidMassDriverBolt bullet = new LiquidMassDriverBolt();
    public float bulletSpeed = 5.5f;
    public float bulletLifetime = 200.0f;
    public Effect shootEffect = Fx.shootBig2;
    public Effect smokeEffect = Fx.shootBigSmoke2;
    public Effect receiveEffect = Fx.mineBig;
    public Sound shootSound = Sounds.shootBig;
    public float shake = 3.0f;
    public DrawBlock drawer = new DrawLiquidDriver();

    public LiquidMassDriver(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.configurable = true;
        this.hasLiquids = true;
        this.liquidCapacity = 120.0f;
        this.hasPower = true;
        this.sync = true;
        this.envEnabled |= 2;
        this.outputsLiquid = true;
        this.group = BlockGroup.liquids;
        this.config(Point2.class, (tile, point) -> {
            tile.link = Point2.pack((int)(point.x + tile.tileX()), (int)(point.y + tile.tileY()));
        });
        this.config(Integer.class, (tile, point) -> {
            tile.link = point;
        });
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shootRange, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.reload, 60.0f / this.reload, StatUnit.perSecond);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8), (float)(y * 8), (float)this.range, (Color)Pal.accent);
        if (!Vars.control.input.config.isShown()) {
            return;
        }
        Building selected = Vars.control.input.config.getSelected();
        if (selected == null || selected.block != this || !selected.within((float)(x * 8), (float)(y * 8), this.range)) {
            return;
        }
        float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f);
        Tmp.v1.set((float)(x * 8) + this.offset, (float)(y * 8) + this.offset).sub(selected.x, selected.y).limit(((float)this.size / 2.0f + 1.0f) * 8.0f + sin + 0.5f);
        float x2 = (float)(x * 8) - Tmp.v1.x;
        float y2 = (float)(y * 8) - Tmp.v1.y;
        float x1 = selected.x + Tmp.v1.x;
        float y1 = selected.y + Tmp.v1.y;
        int segs = (int)(selected.dst((float)(x * 8), (float)(y * 8)) / 8.0f);
        Lines.stroke((float)4.0f, (Color)Pal.gray);
        Lines.dashLine((float)x1, (float)y1, (float)x2, (float)y2, (int)segs);
        Lines.stroke((float)2.0f, (Color)Pal.placing);
        Lines.dashLine((float)x1, (float)y1, (float)x2, (float)y2, (int)segs);
        Draw.reset();
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    protected TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    public class LiquidMassDriverBuild
    extends Building {
        public int link = -1;
        public float rotation = 90.0f;
        public float reloadCounter = 0.0f;
        public DriverState state = DriverState.idle;
        public OrderedSet<Building> waitingShooters = new OrderedSet();

        public Building currentShooter() {
            return this.waitingShooters.isEmpty() ? null : (Building)this.waitingShooters.first();
        }

        public float liquidTotal() {
            return this.liquids.get(this.liquids.current());
        }

        public void updateTile() {
            Building current;
            Building link = Vars.world.build(this.link);
            boolean hasLink = this.linkValid();
            if (hasLink) {
                this.link = link.pos();
            }
            if (this.reloadCounter > 0.0f) {
                this.reloadCounter = Mathf.clamp((float)(this.reloadCounter - this.edelta() / LiquidMassDriver.this.reload));
            }
            if ((current = this.currentShooter()) != null && !this.shooterValid(current)) {
                this.waitingShooters.remove((Object)current);
            }
            if (this.state == DriverState.idle) {
                if (!this.waitingShooters.isEmpty() && LiquidMassDriver.this.liquidCapacity - this.liquidTotal() >= (float)LiquidMassDriver.this.minDistribute) {
                    this.state = DriverState.accepting;
                } else if (hasLink) {
                    this.state = DriverState.shooting;
                }
            }
            if (this.state == DriverState.idle || this.state == DriverState.accepting) {
                this.dumpLiquid(this.liquids.current());
            }
            if (this.efficiency <= 0.0f) {
                return;
            }
            if (this.state == DriverState.accepting) {
                if (this.currentShooter() == null || LiquidMassDriver.this.liquidCapacity - this.liquidTotal() < (float)LiquidMassDriver.this.minDistribute) {
                    this.state = DriverState.idle;
                    return;
                }
                this.rotation = Angles.moveToward((float)this.rotation, (float)this.angleTo((Position)this.currentShooter()), (float)(LiquidMassDriver.this.rotateSpeed * this.efficiency));
            } else if (this.state == DriverState.shooting) {
                if (!hasLink || !this.waitingShooters.isEmpty() && LiquidMassDriver.this.liquidCapacity - this.liquidTotal() >= (float)LiquidMassDriver.this.minDistribute) {
                    this.state = DriverState.idle;
                    return;
                }
                float targetRotation = this.angleTo((Position)link);
                if (this.liquidTotal() >= (float)LiquidMassDriver.this.minDistribute && link.block.liquidCapacity - link.liquids.get(link.liquids.current()) >= (float)LiquidMassDriver.this.minDistribute) {
                    LiquidMassDriverBuild other = (LiquidMassDriverBuild)link;
                    other.waitingShooters.add((Object)this);
                    if (this.reloadCounter <= 1.0E-4f) {
                        this.rotation = Angles.moveToward((float)this.rotation, (float)targetRotation, (float)(LiquidMassDriver.this.rotateSpeed * this.efficiency));
                        if (other.currentShooter() == this && other.state == DriverState.accepting && Angles.near((float)this.rotation, (float)targetRotation, (float)2.0f) && Angles.near((float)other.rotation, (float)(targetRotation + 180.0f), (float)2.0f)) {
                            this.fire(other);
                            float timeToArrive = Math.min(LiquidMassDriver.this.bulletLifetime, this.dst((Position)other) / LiquidMassDriver.this.bulletSpeed);
                            Time.run((float)timeToArrive, () -> {
                                other.waitingShooters.remove((Object)this);
                                other.state = DriverState.idle;
                            });
                            this.state = DriverState.idle;
                        }
                    }
                }
            }
        }

        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return Mathf.clamp((float)(1.0f - this.reloadCounter / LiquidMassDriver.this.reload));
            }
            return super.sense(sensor);
        }

        public void draw() {
            LiquidMassDriver.this.drawer.draw((Building)this);
        }

        public void drawConfigure() {
            float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f);
            Draw.color((Color)Pal.accent);
            Lines.stroke((float)1.0f);
            Drawf.circles((float)this.x, (float)this.y, (float)(((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.accent);
            for (Building shooter : this.waitingShooters) {
                Drawf.circles((float)shooter.x, (float)shooter.y, (float)(((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.place);
                Drawf.arrow((float)shooter.x, (float)shooter.y, (float)this.x, (float)this.y, (float)((float)(LiquidMassDriver.this.size * 8) + sin), (float)(4.0f + sin), (Color)Pal.place);
            }
            if (this.linkValid()) {
                Building target = Vars.world.build(this.link);
                Drawf.circles((float)target.x, (float)target.y, (float)(((float)target.block.size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.place);
                Drawf.arrow((float)this.x, (float)this.y, (float)target.x, (float)target.y, (float)((float)(LiquidMassDriver.this.size * 8) + sin), (float)(4.0f + sin));
            }
            Drawf.dashCircle((float)this.x, (float)this.y, (float)LiquidMassDriver.this.range, (Color)Pal.accent);
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (this == other) {
                if (this.link == -1) {
                    this.deselect();
                }
                this.configure(-1);
                return false;
            }
            if (this.link == other.pos()) {
                this.configure(-1);
                return false;
            }
            if (other.block == this.block && other.dst((Position)this.tile) <= LiquidMassDriver.this.range && other.team == this.team) {
                this.configure(other.pos());
                return false;
            }
            return true;
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return this.liquidTotal() < LiquidMassDriver.this.liquidCapacity && this.linkValid();
        }

        public void dumpLiquid(Liquid liquid) {
            if (this.linkValid()) {
                return;
            }
            super.dumpLiquid(liquid);
        }

        protected void fire(LiquidMassDriverBuild target) {
            this.reloadCounter = 1.0f;
            LiquidBulletData data = (LiquidBulletData)Pools.obtain(LiquidBulletData.class, LiquidBulletData::new);
            data.from = this;
            data.to = target;
            data.liquid = this.liquids.current();
            data.amount = this.liquidTotal();
            this.liquids.clear();
            float angle = this.tile.angleTo((Position)target);
            LiquidMassDriver.this.bullet.create((Entityc)this, this.team, this.x + Angles.trnsx((float)angle, (float)LiquidMassDriver.this.translation), this.y + Angles.trnsy((float)angle, (float)LiquidMassDriver.this.translation), angle, -1.0f, LiquidMassDriver.this.bulletSpeed, LiquidMassDriver.this.bulletLifetime, data);
            LiquidMassDriver.this.shootEffect.at(this.x + Angles.trnsx((float)angle, (float)LiquidMassDriver.this.translation), this.y + Angles.trnsy((float)angle, (float)LiquidMassDriver.this.translation), angle);
            LiquidMassDriver.this.smokeEffect.at(this.x + Angles.trnsx((float)angle, (float)LiquidMassDriver.this.translation), this.y + Angles.trnsy((float)angle, (float)LiquidMassDriver.this.translation), angle);
            Effect.shake((float)LiquidMassDriver.this.shake, (float)LiquidMassDriver.this.shake, (Position)this);
            LiquidMassDriver.this.shootSound.at((Position)this.tile, Mathf.random((float)0.9f, (float)1.1f));
        }

        public void handlePayload(Bullet bullet, LiquidBulletData data) {
            this.liquids.add(data.liquid, data.amount);
            Effect.shake((float)LiquidMassDriver.this.shake, (float)LiquidMassDriver.this.shake, (Position)this);
            LiquidMassDriver.this.receiveEffect.at((Position)bullet);
            this.reloadCounter = 1.0f;
            bullet.remove();
        }

        protected boolean shooterValid(Building other) {
            if (other instanceof LiquidMassDriverBuild) {
                LiquidMassDriverBuild entity = (LiquidMassDriverBuild)other;
                if (other.isValid() && other.efficiency > 0.0f) {
                    return entity.block == this.block && entity.link == this.pos() && this.within((Position)other, LiquidMassDriver.this.range);
                }
            }
            return false;
        }

        protected boolean linkValid() {
            if (this.link == -1) {
                return false;
            }
            Building linked = Vars.world.build(this.link);
            if (linked instanceof LiquidMassDriverBuild) {
                LiquidMassDriverBuild other = (LiquidMassDriverBuild)linked;
                return other.block == this.block && other.team == this.team && this.within((Position)other, LiquidMassDriver.this.range);
            }
            return false;
        }

        public Point2 config() {
            if (this.tile == null) {
                return null;
            }
            return Point2.unpack((int)this.link).sub((int)this.tile.x, (int)this.tile.y);
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.f(this.rotation);
            write.b((int)((byte)this.state.ordinal()));
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.link = read.i();
            this.rotation = read.f();
            this.state = DriverState.all[read.b()];
        }
    }

    public static enum DriverState {
        idle,
        accepting,
        shooting;

        public static final DriverState[] all;

        static {
            all = DriverState.values();
        }
    }

    public static class LiquidBulletData
    implements Pool.Poolable {
        public LiquidMassDriverBuild from;
        public LiquidMassDriverBuild to;
        public Liquid liquid = Liquids.water;
        public float amount = 0.0f;

        public void reset() {
            this.from = null;
            this.to = null;
            this.liquid = Liquids.water;
            this.amount = 0.0f;
        }
    }
}

