/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.production;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUFx;
import ExtraUtilities.worlds.drawer.DrawFunc;
import ExtraUtilities.worlds.meta.EUStatValues;
import arc.Core;
import arc.audio.Sound;
import arc.func.Boolf;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.ObjectFloatMap;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.InputHandler;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Tile;
import mindustry.world.blocks.production.Drill;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class ExplodeDrill
extends Drill {
    public float drillTimeBurst = 270.0f;
    public Interp speedCurve = Interp.pow2In;
    public float shake = 2.0f;
    public float invertedTime = 200.0f;
    public int reRange = 4;
    public float reFindTimer = 60.0f;
    public int digAmount = 5;
    public Color glowColor = Color.valueOf((String)"bf92f9");
    @Nullable
    public ConsumeLiquidBase coolant;
    public float coolantMultiplier = 1.0f;
    public ObjectFloatMap<Item> drillMultipliers = new ObjectFloatMap();
    public TextureRegion bottom;
    public TextureRegion top;
    public TextureRegion[] plasmaRegions;
    public int plasmas = 4;
    public float circleRange = 0.0f;
    public float stroke = 1.5f;
    public Sound burstSound = Sounds.laser;

    public ExplodeDrill(String name) {
        super(name);
        this.hardnessDrillMultiplier = 0.0f;
        this.liquidBoostIntensity = 1.0f;
    }

    public void load() {
        super.load();
        this.bottom = Core.atlas.find(this.name + "-bottom");
        this.plasmaRegions = new TextureRegion[this.plasmas];
        for (int i = 0; i < this.plasmaRegions.length; ++i) {
            this.plasmaRegions[i] = Core.atlas.find(this.name + "-plasma-" + i);
        }
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.drillSpeed, 60.0f / this.drillTimeBurst * (float)this.size * (float)this.size, StatUnit.itemsSecond);
        this.stats.add(Stat.drillSpeed, (float)this.digAmount / (this.reFindTimer / 60.0f), StatUnit.itemsSecond);
        if (this.coolant != null) {
            this.stats.add(Stat.booster, EUStatValues.stringBoosters(this.drillTime, this.coolant.amount, this.coolantMultiplier, false, (Boolf<Liquid>)((Boolf)l -> l.coolant && this.consumesLiquid((Liquid)l)), "stat.extra-utilities-upSpeed"));
        }
        this.stats.add(Stat.range, Core.bundle.format("stat.extra-utilities-digRange", new Object[]{this.reRange - this.size / 2}), new Object[0]);
    }

    public void setBars() {
        super.setBars();
        this.addBar(ExtraUtilitiesMod.name("drillspeed"), e -> new Bar(() -> Core.bundle.format("bar." + ExtraUtilitiesMod.name("drillspeed"), new Object[]{Strings.fixed((float)(e.lastDrillSpeedBurst * 60.0f * e.timeScale()), (int)2)}), () -> Pal.ammo, () -> e.warmupBurst));
        this.addBar(ExtraUtilitiesMod.name("digspeed"), e -> new Bar(() -> Core.bundle.format("bar." + ExtraUtilitiesMod.name("digspeed"), new Object[]{Strings.fixed((float)((float)this.digAmount / (this.reFindTimer / 60.0f) * e.timeScale() * e.efficiency * (float)e.reFindT()), (int)2)}), () -> Pal.ammo, () -> e.efficiency * (float)e.reFindT()));
    }

    public float getDrillTimeBurst(Item item) {
        return this.drillTimeBurst / this.drillMultipliers.get((Object)item, 1.0f);
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottom, this.region};
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.bottom, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashSquare((Color)Pal.accent, (float)(x *= 8), (float)(y *= 8), (float)(((float)this.reRange + 0.5f) * 8.0f * 2.0f));
    }

    public class ExplodeDrillBuild
    extends Drill.DrillBuild {
        public float smoothProgress;
        public float invertTime;
        public float progressBurst;
        public float warmupBurst;
        public float timeDrilledBurst;
        public float lastDrillSpeedBurst;
        public float reFindTime;
        public Seq<Tile> tiles;

        public ExplodeDrillBuild() {
            super((Drill)ExplodeDrill.this);
            this.smoothProgress = 0.0f;
            this.invertTime = 0.0f;
            this.reFindTime = 0.0f;
            this.tiles = new Seq();
        }

        public int reFindT() {
            return this.tiles.size > 0 ? 1 : 0;
        }

        private boolean validOre(Tile tile, Item item) {
            return tile.solid() && tile.wallDrop() != null && tile.wallDrop() == item || tile.block() == Blocks.air && tile.drop() != null && tile.drop() == item;
        }

        public void findOre(Item item) {
            this.tiles.clear();
            int tx = World.toTile((float)this.x);
            int ty = World.toTile((float)this.y);
            for (int x = -ExplodeDrill.this.reRange; x <= ExplodeDrill.this.reRange; ++x) {
                for (int y = -ExplodeDrill.this.reRange; y <= ExplodeDrill.this.reRange; ++y) {
                    Tile t = Vars.world.tile(x + tx, y + ty);
                    if (t == null || !this.validOre(t, item)) continue;
                    this.tiles.addUnique((Object)t);
                }
            }
        }

        public void updateTile() {
            if (this.dominantItem == null) {
                return;
            }
            if (this.invertTime > 0.0f) {
                this.invertTime -= this.delta() / ExplodeDrill.this.invertedTime;
            }
            if (this.timer(ExplodeDrill.this.timerDump, ExplodeDrill.this.dumpTime)) {
                for (int i = this.items.total(); i > 0; --i) {
                    this.dump(this.items.has(this.dominantItem) ? this.dominantItem : null);
                }
            }
            this.timeDrilled += this.warmup * this.delta();
            float delay = ExplodeDrill.this.getDrillTime(this.dominantItem);
            if (this.items.total() < ExplodeDrill.this.itemCapacity && this.dominantItems > 0 && this.efficiency > 0.0f) {
                float speed = Mathf.lerp((float)1.0f, (float)ExplodeDrill.this.liquidBoostIntensity, (float)this.optionalEfficiency) * this.efficiency * this.EFF();
                this.lastDrillSpeed = speed * (float)this.dominantItems * this.warmup / delay;
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)speed, (float)ExplodeDrill.this.warmupSpeed);
                this.progress += this.delta() * (float)this.dominantItems * speed * this.warmup;
                if (Mathf.chanceDelta((double)(ExplodeDrill.this.updateEffectChance * this.warmup))) {
                    ExplodeDrill.this.updateEffect.at(this.x + Mathf.range((float)((float)ExplodeDrill.this.size * 2.0f)), this.y + Mathf.range((float)((float)ExplodeDrill.this.size * 2.0f)));
                }
            } else {
                this.lastDrillSpeed = 0.0f;
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)ExplodeDrill.this.warmupSpeed);
                return;
            }
            if (this.dominantItems > 0 && this.progress >= delay && this.items.total() < ExplodeDrill.this.itemCapacity) {
                this.offload(this.dominantItem);
                this.progress %= delay;
                if (this.wasVisible) {
                    ExplodeDrill.this.drillEffect.at(this.x + Mathf.range((float)ExplodeDrill.this.drillEffectRnd), this.y + Mathf.range((float)ExplodeDrill.this.drillEffectRnd), this.dominantItem.color);
                }
            }
            float drillTime = ExplodeDrill.this.getDrillTimeBurst(this.dominantItem);
            this.smoothProgress = Mathf.lerpDelta((float)this.smoothProgress, (float)(this.progressBurst / (drillTime - 20.0f)), (float)0.1f);
            if (this.items.total() <= ExplodeDrill.this.itemCapacity - this.dominantItems && this.dominantItems > 0 && this.efficiency > 0.0f) {
                this.warmupBurst = Mathf.approachDelta((float)this.warmupBurst, (float)(this.progressBurst / drillTime), (float)0.01f);
                float speed = this.efficiency * this.EFF() * this.EFF();
                this.timeDrilledBurst += ExplodeDrill.this.speedCurve.apply(this.progressBurst / drillTime) * speed;
                this.lastDrillSpeedBurst = 1.0f / drillTime * speed * (float)this.dominantItems;
                this.progressBurst += this.delta() * speed;
            } else {
                this.warmupBurst = Mathf.approachDelta((float)this.warmupBurst, (float)0.0f, (float)0.01f);
                this.lastDrillSpeedBurst = 0.0f;
                return;
            }
            if (this.dominantItems > 0 && this.progressBurst >= drillTime && this.items.total() < ExplodeDrill.this.itemCapacity) {
                for (int i = 0; i < this.dominantItems; ++i) {
                    this.offload(this.dominantItem);
                }
                this.invertTime = 1.0f;
                this.progressBurst %= drillTime;
                if (this.wasVisible) {
                    Effect.shake((float)ExplodeDrill.this.shake, (float)ExplodeDrill.this.shake, (Position)this);
                    ExplodeDrill.this.burstSound.at(this.x, this.y, 1.0f, 0.3f);
                    EUFx.expDillEffect(ExplodeDrill.this.size * 2, ExplodeDrill.this.glowColor).at((Position)this);
                }
            }
            if (ExplodeDrill.this.reRange <= 0) {
                return;
            }
            if (this.items.total() < ExplodeDrill.this.itemCapacity) {
                float f;
                this.reFindTime += this.edelta();
                if (f > ExplodeDrill.this.reFindTimer) {
                    this.findOre(this.dominantItem);
                    if (this.tiles.size > 0) {
                        int i = Mathf.random((int)(this.tiles.size - 1));
                        Tile t = (Tile)this.tiles.get(i);
                        EUFx.digTile(this.dominantItem.color).at((Position)t);
                        Fx.chainLightning.at(t.worldx(), t.worldy(), 0.0f, this.dominantItem.color, (Object)this);
                        InputHandler.createItemTransfer((Item)this.dominantItem, (int)2, (float)t.worldx(), (float)t.worldy(), (Position)this, () -> {
                            for (int o = 0; o < ExplodeDrill.this.digAmount; ++o) {
                                this.offload(this.dominantItem);
                            }
                        });
                    }
                    this.reFindTime -= ExplodeDrill.this.reFindTimer;
                }
            }
        }

        public void draw() {
            Color dc = this.dominantItem == null ? Color.white : this.dominantItem.color;
            Draw.rect((TextureRegion)ExplodeDrill.this.bottom, (float)this.x, (float)this.y);
            Draw.blend((Blending)Blending.additive);
            for (int i = 0; i < ExplodeDrill.this.plasmaRegions.length; ++i) {
                float r = (float)ExplodeDrill.this.plasmaRegions[i].width * 1.2f * Draw.scl - 3.0f + Mathf.absin((float)Time.time, (float)(2.0f + (float)i * 1.0f), (float)(5.0f - (float)i * 0.5f));
                Draw.color((Color)dc, (Color)ExplodeDrill.this.glowColor, (float)((float)i / (float)ExplodeDrill.this.plasmaRegions.length));
                Draw.alpha((float)((0.3f + Mathf.absin((float)Time.time, (float)(2.0f + (float)i * 2.0f), (float)(0.3f + (float)i * 0.05f))) * this.warmup));
                Draw.rect((TextureRegion)ExplodeDrill.this.plasmaRegions[i], (float)this.x, (float)this.y, (float)r, (float)r, (float)(this.totalProgress() / 2.0f * (12.0f + (float)i * 6.0f)));
            }
            Draw.color();
            Draw.blend();
            Draw.rect((TextureRegion)ExplodeDrill.this.region, (float)this.x, (float)this.y);
            if (ExplodeDrill.this.drawRim) {
                Draw.color((Color)ExplodeDrill.this.glowColor);
                Draw.alpha((float)(this.warmup * 0.6f * (0.8f + Mathf.absin((float)Time.time, (float)4.0f, (float)0.2f))));
                Draw.blend((Blending)Blending.additive);
                Draw.rect((TextureRegion)ExplodeDrill.this.rimRegion, (float)this.x, (float)this.y);
                Draw.blend();
                Draw.color();
            }
            Draw.color((Color)dc);
            Draw.rect((TextureRegion)ExplodeDrill.this.itemRegion, (float)this.x, (float)this.y);
            Draw.z((float)99.99f);
            Lines.stroke((float)ExplodeDrill.this.stroke);
            DrawFunc.circlePercent(this.x, this.y, ExplodeDrill.this.circleRange > 0.0f ? ExplodeDrill.this.circleRange : (float)(ExplodeDrill.this.size * ExplodeDrill.this.size), this.warmup, 135.0f);
            Draw.color((Color)ExplodeDrill.this.glowColor);
            DrawFunc.circlePercent(this.x, this.y, ExplodeDrill.this.circleRange > 0.0f ? ExplodeDrill.this.circleRange : (float)(ExplodeDrill.this.size * ExplodeDrill.this.size), Math.min(this.warmupBurst, this.warmup), 135.0f);
            Draw.color();
        }

        public void drawSelect() {
            super.drawSelect();
            if (ExplodeDrill.this.reRange <= 0) {
                return;
            }
            Drawf.dashSquare((Color)Pal.accent, (float)this.x, (float)this.y, (float)(((float)ExplodeDrill.this.reRange + 0.5f) * 8.0f * 2.0f));
            Color dc = this.dominantItem == null ? Color.white : this.dominantItem.color;
            float sin = Mathf.absin((float)Time.time, (float)4.0f, (float)1.0f);
            for (int i = 0; i < this.tiles.size; ++i) {
                Tile t = (Tile)this.tiles.get(i);
                Draw.color((Color)dc);
                Draw.alpha((float)sin);
                Fill.square((float)t.worldx(), (float)t.worldy(), (float)4.0f);
            }
        }

        public float EFF() {
            Liquid liquid = this.liquids.current();
            return (liquid.heatCapacity - Liquids.water.heatCapacity + 1.0f) * ExplodeDrill.this.coolantMultiplier;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.progressBurst);
            write.f(this.warmupBurst);
            write.f(this.reFindTime);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.progressBurst = read.f();
                this.warmupBurst = read.f();
                this.reFindTime = read.f();
            }
        }
    }
}

