/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.production;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Nullable;
import mindustry.content.Liquids;
import mindustry.entities.Effect;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.world.blocks.production.Separator;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;

public class OutLiquidSeparator
extends Separator {
    @Nullable
    public LiquidStack outputLiquid;
    Effect fullEffect = new Effect(30.0f, e -> {
        Draw.color((Color)Liquids.water.color);
        Angles.randLenVectors((long)e.id, (int)3, (float)(2.0f + 16.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.foutpow() * 5.0f)));
    }).layer(29.0f);

    public OutLiquidSeparator(String name) {
        super(name);
        this.liquidCapacity = 20.0f;
    }

    public void init() {
        if (this.outputLiquid != null) {
            this.outputsLiquid = true;
            this.hasLiquids = true;
        }
        super.init();
    }

    public void setStats() {
        super.setStats();
        if (this.outputLiquid != null) {
            this.stats.add(Stat.output, StatValues.liquid((Liquid)this.outputLiquid.liquid, (float)(this.outputLiquid.amount * 60.0f), (boolean)true));
        }
    }

    public class LiquidSeparatorBuild
    extends Separator.SeparatorBuild {
        public LiquidSeparatorBuild() {
            super((Separator)OutLiquidSeparator.this);
        }

        public void updateTile() {
            super.updateTile();
            if (OutLiquidSeparator.this.outputLiquid != null) {
                if (this.liquids.get(OutLiquidSeparator.this.outputLiquid.liquid) >= OutLiquidSeparator.this.liquidCapacity && Mathf.chanceDelta((double)(0.5f * this.edelta()))) {
                    OutLiquidSeparator.this.fullEffect.at((Position)this);
                }
                float added = Math.min(this.edelta() * OutLiquidSeparator.this.outputLiquid.amount, OutLiquidSeparator.this.liquidCapacity - this.liquids.get(OutLiquidSeparator.this.outputLiquid.liquid));
                this.liquids.add(OutLiquidSeparator.this.outputLiquid.liquid, added);
                this.dumpLiquid(OutLiquidSeparator.this.outputLiquid.liquid);
            }
        }
    }
}

