/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.production;

import ExtraUtilities.content.EUFx;
import ExtraUtilities.ui.ItemDisplay;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Icosphere;
import arc.math.geom.MeshResult;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.scene.Element;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.gen.Player;
import mindustry.graphics.Drawf;
import mindustry.type.Item;
import mindustry.ui.Styles;
import mindustry.world.blocks.production.Drill;
import mindustry.world.meta.Stat;

public class PhasicDrill
extends Drill {
    public Item boostItem = Items.phaseFabric;
    public float consumeTime = 120.0f;
    public float pop = 0.1f;
    public float popAfter = 0.5f;
    public int upTimes = 2;
    public float camHeight = 80.0f;
    public Effect boostEffect = Fx.none;

    public PhasicDrill(String name) {
        super(name);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.abilities, t -> {
            t.row();
            t.table(Styles.grayPanel, nt -> {
                nt.add((CharSequence)Core.bundle.format("stat.doubleGet", new Object[]{this.upTimes, Float.valueOf(this.pop * 100.0f)})).pad(10.0f).left();
                nt.table(p2 -> {
                    p2.right().defaults().padRight(3.0f).left();
                    p2.add((CharSequence)Core.bundle.get("stat.doubleGetCan")).pad(8.0f).left();
                    p2.row();
                    p2.add((Element)new ItemDisplay(this.boostItem, 1, this.consumeTime, true)).pad(10.0f).left();
                    p2.add((CharSequence)Core.bundle.format("stat.doubleGetBoost", new Object[]{Float.valueOf((this.popAfter - this.pop) * 100.0f)})).left();
                }).growX().pad(5.0f).padRight(15.0f).padBottom(-5.0f).row();
            }).growX().colspan(t.getColumns());
            t.row();
        });
    }

    public void init() {
        if (this.boostItem == null) {
            this.boostItem = Items.silicon;
        }
        this.blockedItem = this.boostItem;
        this.boostEffect = EUFx.diffuse(this.size, this.boostItem.color, 30.0f);
        this.itemCapacity = 20;
        super.init();
    }

    public class PhasicDrillBuild
    extends Drill.DrillBuild {
        public float consumeTimer;
        public float boostWarm;
        Vec2 tmpVec;
        MeshResult r;

        public PhasicDrillBuild() {
            super((Drill)PhasicDrill.this);
            this.consumeTimer = 0.0f;
            this.boostWarm = 0.0f;
            this.tmpVec = new Vec2();
            this.r = Icosphere.create((int)0);
        }

        public void updateTile() {
            int amountGet = this.dominantItem == null ? this.items.total() : this.items.get(this.dominantItem);
            for (int i = 0; i < amountGet; ++i) {
                this.dump(this.dominantItem);
            }
            if (this.dominantItem == null || this.dominantItem == PhasicDrill.this.boostItem) {
                return;
            }
            this.timeDrilled += this.warmup * this.delta();
            float delay = PhasicDrill.this.getDrillTime(this.dominantItem);
            if (this.items.get(this.dominantItem) < PhasicDrill.this.itemCapacity && this.dominantItems > 0 && this.efficiency > 0.0f) {
                float speed = Mathf.lerp((float)1.0f, (float)PhasicDrill.this.liquidBoostIntensity, (float)this.optionalEfficiency) * this.efficiency;
                this.lastDrillSpeed = speed * (float)this.dominantItems * this.warmup / delay;
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)speed, (float)PhasicDrill.this.warmupSpeed);
                this.progress += this.delta() * (float)this.dominantItems * speed * this.warmup;
                if (Mathf.chanceDelta((double)(PhasicDrill.this.updateEffectChance * this.warmup))) {
                    PhasicDrill.this.updateEffect.at(this.x + Mathf.range((float)((float)PhasicDrill.this.size * 2.0f)), this.y + Mathf.range((float)((float)PhasicDrill.this.size * 2.0f)));
                }
            } else {
                this.lastDrillSpeed = 0.0f;
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)PhasicDrill.this.warmupSpeed);
                return;
            }
            if (this.dominantItems > 0 && this.progress >= delay && this.items.get(this.dominantItem) < PhasicDrill.this.itemCapacity) {
                boolean hasBoost = this.items.has(PhasicDrill.this.boostItem) && Mathf.chance((double)PhasicDrill.this.popAfter) || !this.items.has(PhasicDrill.this.boostItem) && Mathf.chance((double)PhasicDrill.this.pop);
                int up = hasBoost ? PhasicDrill.this.upTimes : 1;
                for (int i = 0; i < up; ++i) {
                    this.offload(this.dominantItem);
                }
                this.progress %= delay;
                if (this.wasVisible) {
                    if (hasBoost) {
                        PhasicDrill.this.boostEffect.at(this.x, this.y);
                    } else if (Mathf.chanceDelta((double)(PhasicDrill.this.updateEffectChance * this.warmup))) {
                        PhasicDrill.this.drillEffect.at(this.x + Mathf.range((float)PhasicDrill.this.drillEffectRnd), this.y + Mathf.range((float)PhasicDrill.this.drillEffectRnd), this.dominantItem.color);
                    }
                }
            }
            if (this.items.has(PhasicDrill.this.boostItem)) {
                this.boostWarm = Mathf.lerpDelta((float)this.boostWarm, (float)1.0f, (float)0.05f);
                this.consumeTimer += this.edelta();
                if (this.consumeTimer >= PhasicDrill.this.consumeTime) {
                    this.items.remove(PhasicDrill.this.boostItem, 1);
                    this.consumeTimer -= PhasicDrill.this.consumeTime;
                }
            } else {
                this.boostWarm = Mathf.lerpDelta((float)this.boostWarm, (float)0.0f, (float)0.05f);
            }
        }

        public boolean acceptItem(Building source, Item item) {
            return item == PhasicDrill.this.boostItem && this.items.get(item) < this.getMaximumAccepted(item);
        }

        public boolean shouldConsume() {
            return this.dominantItem != null && this.items.get(this.dominantItem) < PhasicDrill.this.itemCapacity && this.enabled;
        }

        public boolean shouldAmbientSound() {
            return this.efficiency > 0.01f && this.dominantItem != null && this.items.get(this.dominantItem) < PhasicDrill.this.itemCapacity;
        }

        public void draw() {
            float w = Math.min(1.0f, this.warmup);
            Draw.rect((TextureRegion)PhasicDrill.this.region, (float)this.x, (float)this.y);
            Draw.z((float)30.1f);
            this.drawDefaultCracks();
            Draw.z((float)30.2f);
            Lines.stroke((float)(2.0f * w), (Color)PhasicDrill.this.boostItem.color);
            Lines.poly((float)this.x, (float)this.y, (int)6, (float)6.0f, (float)(-this.timeDrilled * PhasicDrill.this.rotateSpeed));
            Draw.reset();
            if (PhasicDrill.this.drawSpinSprite) {
                Drawf.spinSprite((TextureRegion)PhasicDrill.this.rotatorRegion, (float)this.x, (float)this.y, (float)(this.timeDrilled * PhasicDrill.this.rotateSpeed));
            } else {
                Draw.rect((TextureRegion)PhasicDrill.this.rotatorRegion, (float)this.x, (float)this.y, (float)(this.timeDrilled * PhasicDrill.this.rotateSpeed));
            }
            Draw.rect((TextureRegion)PhasicDrill.this.topRegion, (float)this.x, (float)this.y);
            if (this.dominantItem != null && PhasicDrill.this.drawMineItem) {
                Draw.color((Color)this.dominantItem.color);
                Draw.rect((TextureRegion)PhasicDrill.this.itemRegion, (float)this.x, (float)this.y);
                Draw.color();
            }
            if ((w *= this.boostWarm) < 0.001f) {
                return;
            }
            float z = Draw.z();
            Draw.color((Color)PhasicDrill.this.boostItem.color);
            for (int i = 0; i < this.r.indices.size - 1; i += 3) {
                Vec3 v31 = Tmp.v31.set(this.r.vertices.items, this.r.indices.items[i] * 3).setLength((float)(PhasicDrill.this.size * 5) * w);
                Vec3 v32 = Tmp.v32.set(this.r.vertices.items, this.r.indices.items[i + 1] * 3).setLength((float)(PhasicDrill.this.size * 5) * w);
                Vec3 v33 = Tmp.v33.set(this.r.vertices.items, this.r.indices.items[i + 2] * 3).setLength((float)(PhasicDrill.this.size * 5) * w);
                v31.rotate(Vec3.Y, this.timeDrilled * 0.8f);
                v32.rotate(Vec3.Y, this.timeDrilled * 0.8f);
                v33.rotate(Vec3.Y, this.timeDrilled * 0.8f);
                v31.add(this.x, this.y, 0.0f);
                v32.add(this.x, this.y, 0.0f);
                v33.add(this.x, this.y, 0.0f);
                int amount = 3;
                for (int k = 1; k <= amount; ++k) {
                    Vec3 vz1 = Tmp.v34.set(v31).lerp(v32, 1.0f / (float)(amount + 1) * (float)k);
                    Vec2 v = this.calculation(vz1);
                    Draw.z((float)Math.max(29.99f, Math.min(30.0f + vz1.z, 35.0f)));
                    Fill.circle((float)v.x, (float)v.y, (float)Math.max(0.1f, vz1.z / 8.0f * 0.5f * w));
                    vz1 = Tmp.v34.set(v32).lerp(v33, 1.0f / (float)(amount + 1) * (float)k);
                    v = this.calculation(vz1);
                    Draw.z((float)Math.max(29.99f, Math.min(30.0f + vz1.z, 35.0f)));
                    Fill.circle((float)v.x, (float)v.y, (float)Math.max(0.1f, vz1.z / 8.0f * 0.5f * w));
                    vz1 = Tmp.v34.set(v33).lerp(v31, 1.0f / (float)(amount + 1) * (float)k);
                    v = this.calculation(vz1);
                    Draw.z((float)Math.max(29.99f, Math.min(30.0f + vz1.z, 35.0f)));
                    Fill.circle((float)v.x, (float)v.y, (float)Math.max(0.1f, vz1.z / 8.0f * 0.5f * w));
                }
                Vec2 v1 = this.calculation(v31);
                Draw.z((float)Math.max(29.99f, Math.min(30.0f + v31.z, 35.0f)));
                Fill.circle((float)v1.x, (float)v1.y, (float)Math.max(0.1f, v31.z / 8.0f * 0.55f * w));
                Vec2 v2 = this.calculation(v32);
                Draw.z((float)Math.max(29.99f, Math.min(30.0f + v32.z, 35.0f)));
                Fill.circle((float)v2.x, (float)v2.y, (float)Math.max(0.1f, v32.z / 8.0f * 0.55f * w));
                Vec2 v3 = this.calculation(v33);
                Draw.z((float)Math.max(29.99f, Math.min(30.0f + v33.z, 35.0f)));
                Fill.circle((float)v3.x, (float)v3.y, (float)Math.max(0.1f, v33.z / 8.0f * 0.55f * w));
            }
            Draw.z((float)z);
        }

        public Vec2 calculation(Vec3 vec) {
            Player c = Vars.player;
            float z = vec.z / 8.0f;
            float s = z / (z - this.getCamHeight());
            return this.tmpVec.set(s, s).scl(c.x() - vec.x, c.y() - vec.y).add(vec.x, vec.y);
        }

        float getCamHeight() {
            return PhasicDrill.this.camHeight / Vars.renderer.getDisplayScale();
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.consumeTimer);
            write.f(this.boostWarm);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.consumeTimer = read.f();
                this.boostWarm = read.f();
            }
        }
    }
}

