/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import ExtraUtilities.worlds.meta.EUStatValues;
import arc.Core;
import arc.Events;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.Element;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Items;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.gen.Teamc;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.ui.MultiReqImage;
import mindustry.ui.ReqImage;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItemFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;

public class MultiBulletTurret
extends Turret {
    public ObjectMap<Item, BulletType[]> ammoTypes = new ObjectMap();
    public boolean all = false;
    public boolean autoResetBid = false;

    public MultiBulletTurret(String name) {
        super(name);
    }

    public void ammo(Object ... objects) {
        this.ammoTypes = ObjectMap.of((Object[])objects);
    }

    public void limitRange() {
        this.limitRange(9.0f);
    }

    public void limitRange(float margin) {
        for (ObjectMap.Entry entry : this.ammoTypes.entries()) {
            for (BulletType b : (BulletType[])entry.value) {
                this.limitRange(b, margin);
            }
        }
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.itemCapacity);
        this.stats.add(Stat.ammo, EUStatValues.ammo(this.ammoTypes, this.all));
        if (this.all) {
            this.stats.remove(Stat.reload);
            this.stats.add(Stat.reload, Core.bundle.format("stat.extra-utilities-shootTime", new Object[]{Strings.autoFixed((float)(this.reload / 60.0f), (int)2)}), new Object[0]);
        }
    }

    public void init() {
        this.consume((Consume)new ConsumeItemFilter(i -> this.ammoTypes.containsKey(i)){

            public void build(Building build, Table table) {
                MultiReqImage image = new MultiReqImage();
                Vars.content.items().each(i -> this.filter.get(i) && i.unlockedNow(), item -> image.add(new ReqImage((Element)new Image(item.uiIcon), () -> build instanceof MultiBulletBuild && !((MultiBulletBuild)build).ammo.isEmpty() && ((ItemEntry)((MultiBulletBuild)build).ammo.peek()).item == item)));
                table.add((Element)image).size(32.0f);
            }

            public float efficiency(Building build) {
                return build instanceof MultiBulletBuild && !((MultiBulletBuild)build).ammo.isEmpty() ? 1.0f : 0.0f;
            }

            public void display(Stats stats) {
            }
        });
        this.ammoTypes.each((item, type) -> {
            float rangeChange = type[0].rangeChange;
            this.placeOverlapRange = Math.max(this.placeOverlapRange, this.range + rangeChange + this.placeOverlapMargin);
        });
        super.init();
    }

    public class ItemEntry {
        public Item item;
        public int amount;

        ItemEntry(Item item, int amount) {
            this.item = item;
            this.amount = amount;
        }

        public BulletType[] type() {
            return (BulletType[])MultiBulletTurret.this.ammoTypes.get((Object)this.item);
        }

        public String toString() {
            return "ItemEntry{item=" + this.item + ", amount=" + this.amount + '}';
        }
    }

    public class MultiBulletBuild
    extends Turret.TurretBuild {
        public Seq<ItemEntry> ammo;
        public int bid;
        public float ResetBidTimer;

        public MultiBulletBuild() {
            super((Turret)MultiBulletTurret.this);
            this.ammo = new Seq();
            this.bid = 0;
            this.ResetBidTimer = 0.0f;
        }

        public void onProximityAdded() {
            super.onProximityAdded();
            if (this.cheating() && this.ammo.size > 0) {
                this.handleItem((Building)this, (Item)MultiBulletTurret.this.ammoTypes.entries().next().key);
            }
        }

        public void updateTile() {
            this.unit.ammo((float)this.unit.type().ammoCapacity * (float)this.totalAmmo / (float)MultiBulletTurret.this.maxAmmo);
            if (MultiBulletTurret.this.autoResetBid && this.bid > 0) {
                if (this.target == null) {
                    this.ResetBidTimer += Time.delta;
                    if (this.ResetBidTimer >= 60.0f) {
                        this.bid = 0;
                        this.ResetBidTimer = 0.0f;
                    }
                } else {
                    this.ResetBidTimer = 0.0f;
                }
            }
            super.updateTile();
        }

        public void displayBars(Table bars) {
            super.displayBars(bars);
            bars.add((Element)new Bar("stat.ammo", Pal.ammo, () -> (float)this.totalAmmo / (float)MultiBulletTurret.this.maxAmmo)).growX();
            bars.row();
        }

        public int acceptStack(Item item, int amount, Teamc source) {
            BulletType[] types = (BulletType[])MultiBulletTurret.this.ammoTypes.get((Object)item);
            if (types == null) {
                return 0;
            }
            for (BulletType type : types) {
                if (type != null) continue;
                return 0;
            }
            return Math.min((int)((float)(MultiBulletTurret.this.maxAmmo - this.totalAmmo) / types[0].ammoMultiplier), amount);
        }

        public void handleStack(Item item, int amount, Teamc source) {
            for (int i = 0; i < amount; ++i) {
                this.handleItem(null, item);
            }
        }

        public int removeStack(Item item, int amount) {
            return 0;
        }

        public void handleItem(Building source, Item item) {
            BulletType[] types;
            if (item == Items.pyratite) {
                Events.fire((Enum)EventType.Trigger.flameAmmo);
            }
            if (this.totalAmmo == 0) {
                Events.fire((Enum)EventType.Trigger.resupplyTurret);
            }
            if ((types = (BulletType[])MultiBulletTurret.this.ammoTypes.get((Object)item)) == null) {
                return;
            }
            for (BulletType type : types) {
                if (type != null) continue;
                return;
            }
            float ammoMultiplier = types[0].ammoMultiplier;
            this.totalAmmo = (int)((float)this.totalAmmo + ammoMultiplier);
            for (int i = 0; i < this.ammo.size; ++i) {
                ItemEntry entry = (ItemEntry)this.ammo.get(i);
                if (entry.item != item) continue;
                entry.amount = (int)((float)entry.amount + ammoMultiplier);
                this.ammo.swap(i, this.ammo.size - 1);
                return;
            }
            this.ammo.add((Object)new ItemEntry(item, (int)ammoMultiplier));
        }

        public boolean acceptItem(Building source, Item item) {
            BulletType[] types = (BulletType[])MultiBulletTurret.this.ammoTypes.get((Object)item);
            if (types == null) {
                return false;
            }
            for (BulletType type : types) {
                if (type != null) continue;
                return false;
            }
            float ammoMultiplier = 1.0f;
            for (BulletType type : types) {
                ammoMultiplier = Math.max(ammoMultiplier, type.ammoMultiplier);
            }
            return (float)this.totalAmmo + ammoMultiplier <= (float)MultiBulletTurret.this.maxAmmo;
        }

        public BulletType useAmmo() {
            if (this.cheating()) {
                return this.peekAmmo();
            }
            ItemEntry entry = (ItemEntry)this.ammo.peek();
            entry.amount -= MultiBulletTurret.this.ammoPerShot;
            if (entry.amount <= 0) {
                this.ammo.pop();
            }
            this.totalAmmo -= MultiBulletTurret.this.ammoPerShot;
            this.totalAmmo = Math.max(this.totalAmmo, 0);
            return entry.type()[0];
        }

        public BulletType peekAmmo() {
            return this.ammo.size == 0 ? null : ((ItemEntry)this.ammo.peek()).type()[0];
        }

        public boolean hasAmmo() {
            if (!this.canConsume()) {
                return false;
            }
            if (this.ammo.size >= 2 && ((ItemEntry)this.ammo.peek()).amount < MultiBulletTurret.this.ammoPerShot && ((ItemEntry)this.ammo.get((int)(this.ammo.size - 2))).amount >= MultiBulletTurret.this.ammoPerShot) {
                this.ammo.swap(this.ammo.size - 1, this.ammo.size - 2);
            }
            return this.ammo.size > 0 && ((ItemEntry)this.ammo.peek()).amount >= MultiBulletTurret.this.ammoPerShot;
        }

        @Nullable
        public BulletType[] peekAmmos() {
            BulletType[] bulletTypeArray;
            if (this.ammo.size == 0) {
                BulletType[] bulletTypeArray2 = new BulletType[1];
                bulletTypeArray = bulletTypeArray2;
                bulletTypeArray2[0] = null;
            } else {
                bulletTypeArray = ((ItemEntry)this.ammo.peek()).type();
            }
            return bulletTypeArray;
        }

        protected void updateShooting() {
            if (this.reloadCounter >= MultiBulletTurret.this.reload && !this.charging() && this.shootWarmup >= MultiBulletTurret.this.minWarmup) {
                BulletType[] type = this.peekAmmos();
                this.shoots(type);
                this.reloadCounter %= MultiBulletTurret.this.reload;
            }
        }

        protected void shoots(BulletType[] type) {
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)MultiBulletTurret.this.shootX, (float)MultiBulletTurret.this.shootY);
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)MultiBulletTurret.this.shootX, (float)MultiBulletTurret.this.shootY);
            if (MultiBulletTurret.this.shoot.firstShotDelay > 0.0f) {
                MultiBulletTurret.this.chargeSound.at(bulletX, bulletY, Mathf.random((float)MultiBulletTurret.this.soundPitchMin, (float)MultiBulletTurret.this.soundPitchMax));
                type[0].chargeEffect.at(bulletX, bulletY, this.rotation);
            }
            MultiBulletTurret.this.shoot.shoot(this.totalShots, (xOffset, yOffset, angle, delay, mover) -> {
                ++this.queuedBullets;
                if (delay > 0.0f) {
                    Time.run((float)delay, () -> this.bullets(type, xOffset, yOffset, angle, mover));
                } else {
                    this.bullets(type, xOffset, yOffset, angle, mover);
                }
                ++this.totalShots;
            });
            if (MultiBulletTurret.this.consumeAmmoOnce) {
                this.useAmmo();
            }
            if (!MultiBulletTurret.this.all) {
                ++this.bid;
            }
        }

        protected void bullets(BulletType[] type, float xOffset, float yOffset, float angleOffset, Mover mover) {
            --this.queuedBullets;
            if (this.dead || !MultiBulletTurret.this.consumeAmmoOnce && !this.hasAmmo() || type == null) {
                return;
            }
            for (BulletType b : type) {
                if (b != null) continue;
                return;
            }
            float xSpread = Mathf.range((float)MultiBulletTurret.this.xRand);
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)(MultiBulletTurret.this.shootX + xOffset + xSpread), (float)(MultiBulletTurret.this.shootY + yOffset));
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)(MultiBulletTurret.this.shootX + xOffset + xSpread), (float)(MultiBulletTurret.this.shootY + yOffset));
            if (MultiBulletTurret.this.all) {
                for (BulletType b : type) {
                    float shootAngle = this.rotation + angleOffset + Mathf.range((float)(MultiBulletTurret.this.inaccuracy + b.inaccuracy));
                    float lifeScl = b.scaleLife ? Mathf.clamp((float)(Mathf.dst((float)bulletX, (float)bulletY, (float)this.targetPos.x, (float)this.targetPos.y) / b.range), (float)(MultiBulletTurret.this.minRange / b.range), (float)(this.range() / b.range)) : 1.0f;
                    this.handleBullet(b.create((Entityc)this, this.team, bulletX, bulletY, shootAngle, -1.0f, 1.0f - MultiBulletTurret.this.velocityRnd + Mathf.random((float)MultiBulletTurret.this.velocityRnd), lifeScl, null, mover, this.targetPos.x, this.targetPos.y), xOffset, yOffset, shootAngle - this.rotation);
                }
                (MultiBulletTurret.this.shootEffect == null ? type[0].shootEffect : MultiBulletTurret.this.shootEffect).at(bulletX, bulletY, this.rotation + angleOffset, type[0].hitColor);
                (MultiBulletTurret.this.smokeEffect == null ? type[0].smokeEffect : MultiBulletTurret.this.smokeEffect).at(bulletX, bulletY, this.rotation + angleOffset, type[0].hitColor);
            } else {
                BulletType b;
                b = type[this.bid % ((BulletType[])type).length];
                float shootAngle = this.rotation + angleOffset + Mathf.range((float)(MultiBulletTurret.this.inaccuracy + b.inaccuracy));
                float lifeScl = b.scaleLife ? Mathf.clamp((float)(Mathf.dst((float)bulletX, (float)bulletY, (float)this.targetPos.x, (float)this.targetPos.y) / b.range), (float)(MultiBulletTurret.this.minRange / b.range), (float)(this.range() / b.range)) : 1.0f;
                this.handleBullet(b.create((Entityc)this, this.team, bulletX, bulletY, shootAngle, -1.0f, 1.0f - MultiBulletTurret.this.velocityRnd + Mathf.random((float)MultiBulletTurret.this.velocityRnd), lifeScl, null, mover, this.targetPos.x, this.targetPos.y), xOffset, yOffset, shootAngle - this.rotation);
                (MultiBulletTurret.this.shootEffect == null ? b.shootEffect : MultiBulletTurret.this.shootEffect).at(bulletX, bulletY, this.rotation + angleOffset, b.hitColor);
                (MultiBulletTurret.this.smokeEffect == null ? b.smokeEffect : MultiBulletTurret.this.smokeEffect).at(bulletX, bulletY, this.rotation + angleOffset, b.hitColor);
            }
            MultiBulletTurret.this.shootSound.at(bulletX, bulletY, Mathf.random((float)MultiBulletTurret.this.soundPitchMin, (float)MultiBulletTurret.this.soundPitchMax));
            MultiBulletTurret.this.ammoUseEffect.at(this.x - Angles.trnsx((float)this.rotation, (float)MultiBulletTurret.this.ammoEjectBack), this.y - Angles.trnsy((float)this.rotation, (float)MultiBulletTurret.this.ammoEjectBack), this.rotation * (float)Mathf.sign((float)xOffset));
            if (MultiBulletTurret.this.shake > 0.0f) {
                Effect.shake((float)MultiBulletTurret.this.shake, (float)MultiBulletTurret.this.shake, (Position)this);
            }
            this.curRecoil = 1.0f;
            this.heat = 1.0f;
            if (!MultiBulletTurret.this.consumeAmmoOnce) {
                this.useAmmo();
            }
        }

        public byte version() {
            return 2;
        }

        public void write(Writes write) {
            super.write(write);
            write.b(this.ammo.size);
            for (ItemEntry entry : this.ammo) {
                write.s((int)entry.item.id);
                write.s(entry.amount);
            }
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.ammo.clear();
            this.totalAmmo = 0;
            int amount = read.ub();
            for (int i = 0; i < amount; ++i) {
                Item item = Vars.content.item(revision < 2 ? read.ub() : (int)read.s());
                short a = read.s();
                if (item == null || !MultiBulletTurret.this.ammoTypes.containsKey((Object)item)) continue;
                this.totalAmmo += a;
                this.ammo.add((Object)new ItemEntry(item, a));
            }
        }
    }
}

