/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import ExtraUtilities.content.EUBulletTypes;
import ExtraUtilities.content.EUGet;
import ExtraUtilities.worlds.blocks.turret.LoadTurret;
import ExtraUtilities.worlds.meta.EUStatValues;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.world.meta.Stat;

public class Penitent
extends LoadTurret {
    public float damagePerShot = 0.02f;
    public float impasseReload = 900.0f;
    public float impasseTime = 240.0f;
    public float endTime = 120.0f;

    public Penitent(String name) {
        super(name);
        this.targetInterval = 6.0f;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.abilities, EUStatValues.ability(this.name, 3));
    }

    public class PenitentBuild
    extends LoadTurret.LoadTurretBuild {
        public boolean impasse = false;
        public boolean inImp = false;
        public boolean impReload = false;
        public boolean end = false;
        public float impTimer = 0.0f;
        public float impReloadTimer = 0.0f;
        public Bullet[] effectBullets = new Bullet[]{null, null};

        @Override
        public void updateTile() {
            int i;
            super.updateTile();
            if (this.impasse) {
                for (i = 0; i < 2; ++i) {
                    if (this.effectBullets[i] == null) {
                        this.effectBullets[i] = EUBulletTypes.effectForPenitent.create((Entityc)this, this.team, this.x, this.y, 0.0f);
                        continue;
                    }
                    float fin = Math.min(1.0f, this.impTimer / 30.0f);
                    fin = Interp.fastSlow.apply(fin);
                    float ex = EUGet.dx(this.x, (float)(Penitent.this.size * 8) * fin, this.impTimer * 5.0f + (float)(180 * i));
                    float ey = EUGet.dy(this.y, (float)(Penitent.this.size * 8) * fin, this.impTimer * 5.0f + (float)(180 * i));
                    this.effectBullets[i].set(ex, ey);
                    this.effectBullets[i].rotation(this.impTimer * 5.0f + (float)(180 * i) + 90.0f);
                    this.effectBullets[i].time = 0.0f;
                }
            } else {
                for (i = 0; i < 2; ++i) {
                    if (this.effectBullets[i] == null) continue;
                    this.effectBullets[i].remove();
                    this.effectBullets[i] = null;
                }
            }
            if (this.end) {
                this.impTimer += Time.delta;
                if (this.impTimer >= Penitent.this.endTime) {
                    for (i = 0; i < 2; ++i) {
                        if (this.effectBullets[i] == null) continue;
                        this.effectBullets[i].remove();
                        this.effectBullets[i] = null;
                    }
                    this.kill();
                }
                return;
            }
            if (this.reRot > Penitent.this.loadReload) {
                this.heal(this.maxHealth() * 0.02f / 60.0f * Time.delta * this.power.status);
            }
            float stop = this.maxHealth() * 0.01f;
            if (this.health() <= stop + 0.01f && !this.inImp && !this.impReload) {
                this.impasse = true;
                this.inImp = true;
            }
            if (this.inImp) {
                this.impTimer += Time.delta;
                if (this.impTimer >= Penitent.this.impasseTime) {
                    this.impasse = false;
                    this.inImp = false;
                    this.impReload = true;
                    this.impTimer = 0.0f;
                }
            }
            if (this.impReload) {
                this.impReloadTimer += Time.delta;
                if (this.impReloadTimer >= Penitent.this.impasseReload) {
                    this.impReload = false;
                    this.impReloadTimer = 0.0f;
                }
            }
        }

        protected void handleBullet(Bullet bullet, float offsetX, float offsetY, float angleOffset) {
            if (bullet != null) {
                float lif = this.maxHealth() * Penitent.this.damagePerShot;
                float stop = this.maxHealth() * 0.01f;
                if (this.health() - lif >= stop) {
                    this.health -= lif;
                } else if (this.health > stop) {
                    this.health = stop;
                }
                float pt = (1.0f + (this.maxHealth() - this.health() + stop) / this.maxHealth()) * (this.impasse ? 1.2f : 1.0f);
                bullet.damage *= pt;
            }
        }

        public void draw() {
            super.draw();
            Lines.stroke((float)2.0f, (Color)this.team.color);
            if (this.end) {
                Lines.poly((float)this.x, (float)this.y, (int)6, (float)(Penitent.this.size * 8), (float)(-this.impTimer * 3.0f));
            }
            Draw.reset();
        }

        public boolean damaged() {
            return super.damaged() && !this.impasse;
        }

        public void heal(float amount) {
            if (!this.impasse) {
                super.heal(amount);
            }
        }

        public void damage(float damage) {
            if (!this.impasse) {
                float stop = this.maxHealth() * 0.01f;
                if (damage >= this.health()) {
                    this.health(stop);
                    this.impasse = true;
                    this.end = true;
                    return;
                }
                super.damage(damage);
            }
        }

        public void write(Writes write) {
            super.write(write);
            write.bool(this.impasse);
            write.bool(this.inImp);
            write.bool(this.impReload);
            write.bool(this.end);
            write.f(this.impTimer);
            write.f(this.impReloadTimer);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.impasse = read.bool();
            this.inImp = read.bool();
            this.impReload = read.bool();
            this.end = read.bool();
            this.impTimer = read.f();
            this.impReloadTimer = read.f();
        }
    }
}

