/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import ExtraUtilities.worlds.entity.bullet.RainBullet;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.blocks.defense.turrets.PowerTurret;

public class Stinger
extends PowerTurret {
    public float delay = 300.0f;
    public float killTrigger = 0.25f;
    public float killChance = 0.05f;
    public BulletType rainBullet = new RainBullet(){
        {
            this.damage = 0.0f;
            this.speed = 0.0f;
            this.lifetime = 66.0f;
            this.hitEffect = this.despawnEffect = Fx.none;
            this.hittable = false;
            this.absorbable = false;
            this.keepVelocity = false;
            this.collides = false;
            this.rain = new LaserBulletType(60.0f){
                {
                    this.colors = new Color[]{Color.valueOf((String)"C6D676"), Color.valueOf((String)"C6D676"), Color.white};
                    this.hitSize = 4.0f;
                    this.lifetime = 16.0f;
                    this.drawSize = 340.0f;
                    this.collidesAir = false;
                    this.length = 130.0f;
                    this.keepVelocity = false;
                    this.pierceCap = 3;
                }
            };
        }
    };

    public Stinger(String name) {
        super(name);
    }

    public class StingerBuild
    extends PowerTurret.PowerTurretBuild {
        public ObjectMap<Unit, Float> unitMap;

        public StingerBuild() {
            super((PowerTurret)Stinger.this);
            this.unitMap = new ObjectMap();
        }

        public void updateTile() {
            super.updateTile();
            for (Unit unit : this.unitMap.keys()) {
                if (unit == null) {
                    this.unitMap.clear();
                    return;
                }
                if (!unit.dead && unit.type != null && unit.type.isEnemy && unit.type.killable) continue;
                this.unitMap.remove((Object)unit);
            }
            for (Unit unit : this.unitMap.keys()) {
                if (unit == null) continue;
                this.unitMap.put((Object)unit, (Object)Float.valueOf(((Float)this.unitMap.get((Object)unit)).floatValue() + Time.delta));
                if (!(((Float)this.unitMap.get((Object)unit)).floatValue() > Stinger.this.delay)) continue;
                this.unitMap.remove((Object)unit);
                if (Stinger.this.killTrigger > 0.0f && unit.health < unit.maxHealth * Stinger.this.killTrigger && Mathf.chance((double)Stinger.this.killChance)) {
                    unit.health -= unit.health;
                    unit.kill();
                    continue;
                }
                unit.apply(StatusEffects.unmoving, 90.0f);
                Stinger.this.rainBullet.create((Teamc)this, unit.x, unit.y, (float)Mathf.random((int)360));
            }
        }
    }
}

