/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import ExtraUtilities.content.EUGet;
import ExtraUtilities.content.EUStatusEffects;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Geometry;
import arc.math.geom.Rect;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.struct.EnumSet;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.type.StatusEffect;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class WitchService
extends Block {
    public float width = 18.0f;
    public float height = 36.0f;
    public StatusEffect eType = EUStatusEffects.breakage;
    public float eTime = 600.0f;
    public ObjectMap<Unit, Float> findMap = new ObjectMap();
    public float AMP = 0.05f;
    public float timeApply = 60.0f;
    public StatusEffect applyEffect = StatusEffects.slow;
    public Effect work;
    public Effect applyIn;
    public Effect applyOut;
    public Color workColor = Pal.techBlue;
    public DrawBlock drawer = new DrawDefault();

    public WitchService(String name) {
        super(name);
        this.rotate = true;
        this.drawArrow = false;
        this.update = true;
        this.solid = true;
        this.attacks = true;
        this.priority = 1.0f;
        this.group = BlockGroup.turrets;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.turret});
        this.applyIn = this.applyOut = Fx.none;
        this.work = this.applyOut;
        this.canOverdrive = false;
    }

    public void init() {
        this.updateClipRadius((this.height + 1.0f) * 8.0f);
        super.init();
    }

    protected Rect getRect(Rect rect, float x, float y, int rotation) {
        float w = this.width * 8.0f;
        float h = this.height * 8.0f;
        float rw = rotation % 2 == 0 ? h : w;
        float rh = rotation % 2 == 0 ? w : h;
        rect.setCentered(x, y, rw, rh);
        float len = 8.0f * (this.height - (float)this.size) / 2.0f;
        rect.x += (float)Geometry.d4x((int)rotation) * len;
        rect.y += (float)Geometry.d4y((int)rotation) * len;
        return rect;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        if (Vars.world.tile(x, y) != null && !this.canPlaceOn(Vars.world.tile(x, y), Vars.player.team(), rotation)) {
            this.drawPlaceText(Core.bundle.get("bar.extra-utilities-close"), x, y, valid);
        }
        x *= 8;
        y *= 8;
        x = (int)((float)x + this.offset);
        y = (int)((float)y + this.offset);
        Rect rect = this.getRect(Tmp.r1, x, y, rotation);
        Drawf.dashRect((Color)(valid ? Pal.accent : Pal.remove), (Rect)rect);
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        Rect rect = this.getRect(Tmp.r1, tile.worldx() + this.offset, tile.worldy() + this.offset, rotation).grow(0.1f);
        return !Vars.indexer.getFlagged(team, BlockFlag.turret).contains(b -> b instanceof ServiceBuild && this.getRect(Tmp.r2, b.x, b.y, b.rotation).overlaps(rect));
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.range);
        this.stats.add(Stat.range, t -> {
            t.row();
            t.add((CharSequence)("\u5bbd(width): " + Strings.autoFixed((float)this.height, (int)2) + StatUnit.blocks.localized())).left();
            t.row();
            t.add((CharSequence)("\u9ad8(height): " + Strings.autoFixed((float)this.width, (int)2) + StatUnit.blocks.localized())).left();
            t.row();
            t.table(Styles.grayPanel, r -> {
                int amount = (int)(3.0f + this.width % 3.0f);
                int line = (int)(this.height / this.width * (float)amount);
                for (int i = 0; i < amount; ++i) {
                    for (int j = 0; j < line; ++j) {
                        r.image(((TextureRegionDrawable)Tex.whiteui).tint(i == amount / 2 && j == 0 ? Pal.accent : Pal.stoneGray)).size(16.0f).left().pad(4.0f);
                    }
                    r.row();
                }
            }).left().margin(5.0f);
            t.row();
        });
        if (this.eType != StatusEffects.none) {
            this.stats.add(Stat.abilities, t -> {
                t.row();
                t.add((CharSequence)Core.bundle.get("statValue.showStatus")).left();
                t.row();
                t.table(Styles.grayPanel, inner -> {
                    inner.left().defaults().left();
                    inner.row();
                    inner.add((Element)EUGet.selfStyleImageButton((Drawable)new TextureRegionDrawable(this.eType.uiIcon), Styles.emptyi, () -> Vars.ui.content.show((UnlockableContent)this.eType))).padTop(4.0f).padBottom(6.0f).size(42.0f);
                    inner.add((CharSequence)this.eType.localizedName).padLeft(5.0f);
                }).left().growX().margin(6.0f).pad(5.0f).padBottom(-5.0f).row();
            });
        }
    }

    public boolean outputsItems() {
        return false;
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    protected TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    public class ServiceBuild
    extends Building
    implements Ranged {
        protected Rect r1 = new Rect();
        protected Rect r2 = new Rect();
        public float reload;
        public boolean working;
        Seq<Unit> inRange;

        public ServiceBuild() {
            this.reload = WitchService.this.timeApply;
            this.working = false;
            this.inRange = new Seq();
        }

        public Rect getR() {
            return this.r1;
        }

        public float range() {
            return WitchService.this.height * 8.0f;
        }

        public float getDelta() {
            float p = WitchService.this.hasPower ? Time.delta * this.power.status : Time.delta;
            return WitchService.this.hasLiquids ? p * Math.min(this.liquids.currentAmount() / WitchService.this.liquidCapacity, 1.0f) : p;
        }

        public void updateTile() {
            float f;
            Rect r = WitchService.this.getRect(this.r1, this.x, this.y, this.rotation);
            this.reload += this.getDelta();
            if (f >= WitchService.this.timeApply) {
                Units.nearbyEnemies((Team)this.team, (Rect)r, u -> {
                    if (u.targetable(this.team) && !u.inFogTo(this.team)) {
                        if (!u.hasEffect(WitchService.this.eType)) {
                            if (!WitchService.this.findMap.containsKey(u)) {
                                WitchService.this.findMap.put(u, (Object)Float.valueOf(WitchService.this.AMP));
                            } else {
                                WitchService.this.findMap.put(u, (Object)Float.valueOf(((Float)WitchService.this.findMap.get(u)).floatValue() + WitchService.this.AMP));
                            }
                            this.working = true;
                            WitchService.this.applyIn.at(u.x, u.y, u.rotation, u);
                            u.apply(WitchService.this.applyEffect, WitchService.this.timeApply / 2.0f);
                        } else if (u.isAdded() && !u.dead && WitchService.this.findMap.containsKey(u)) {
                            WitchService.this.findMap.remove(u);
                        }
                    }
                });
                for (Unit u2 : WitchService.this.findMap.keys()) {
                    if (u2 == null || !u2.isAdded() || u2.dead || u2.hasEffect(WitchService.this.eType)) {
                        WitchService.this.findMap.remove((Object)u2);
                        continue;
                    }
                    WitchService.this.findMap.put((Object)u2, (Object)Float.valueOf(((Float)WitchService.this.findMap.get((Object)u2)).floatValue() + WitchService.this.AMP));
                    WitchService.this.applyOut.at(u2.x, u2.y, u2.rotation, (Object)u2);
                    if (!(((Float)WitchService.this.findMap.get((Object)u2)).floatValue() >= 1.0f)) continue;
                    u2.apply(WitchService.this.eType, WitchService.this.eTime);
                    WitchService.this.findMap.remove((Object)u2);
                }
                this.reload = 0.0f;
            }
            if (this.working) {
                WitchService.this.work.at(this.x, this.y, (float)this.rotation * 90.0f, WitchService.this.workColor, (Object)r);
                this.working = false;
            }
        }

        public boolean shouldConsume() {
            return super.shouldConsume() && WitchService.this.findMap.size > 0;
        }

        public void drawSelect() {
            if (this.team != null) {
                Drawf.dashRect((Color)this.team.color, (Rect)WitchService.this.getRect(this.r2, this.x, this.y, this.rotation));
            }
        }

        public void draw() {
            WitchService.this.drawer.draw((Building)this);
        }
    }

    public static enum elementsType {
        breakage;

    }
}

