/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret.wall;

import ExtraUtilities.content.EUFx;
import ExtraUtilities.content.EUItems;
import ExtraUtilities.net.EUCall;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.ui.Bar;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.Wall;
import mindustry.world.meta.Stat;

public class ReleaseShieldWall
extends Wall {
    public float chargeChance = 0.8f;
    public float maxHandle = 180.0f;
    public float lifetime = 150.0f;

    public ReleaseShieldWall(String name) {
        super(name);
        this.update = true;
    }

    public void setBars() {
        super.setBars();
        this.addBar("charge", entity -> new Bar(() -> Core.bundle.get("bar.extra-utilities-charge"), () -> EUItems.lightninAlloy.color, entity::getCharge));
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.abilities, Core.bundle.format("stat.extra-utilities-charge", new Object[]{Float.valueOf(this.maxHandle), Float.valueOf(this.chargeChance * 100.0f)}), new Object[0]);
    }

    public static void setDamage(Tile tile, float damage) {
        if (tile == null || !(tile.build instanceof ReleaseShieldWallBuild)) {
            return;
        }
        ((ReleaseShieldWallBuild)tile.build).setDamage(damage);
    }

    public class ReleaseShieldWallBuild
    extends Wall.WallBuild {
        public float totalDamage;
        public float clientDamage;
        public float shieldLife;
        public Bullet shieldBullet;
        public boolean acceptDamage;
        public float rePacketTimer;

        public ReleaseShieldWallBuild() {
            super((Wall)ReleaseShieldWall.this);
            this.totalDamage = 0.0f;
            this.clientDamage = 0.0f;
            this.shieldLife = 0.0f;
            this.shieldBullet = null;
            this.acceptDamage = true;
            this.rePacketTimer = 0.0f;
        }

        public float getCharge() {
            return (Vars.net.client() ? this.clientDamage : this.totalDamage) / ReleaseShieldWall.this.maxHandle;
        }

        public void updateTile() {
            this.rePacketTimer = Math.min(this.rePacketTimer + Time.delta, 60.0f);
            this.timeScale = this.getCharge();
            if (this.totalDamage > ReleaseShieldWall.this.maxHandle) {
                EUCall.ReleaseShieldWallBuildSync(this.tile, this.totalDamage);
                this.shieldBullet = new ShieldBullet(ReleaseShieldWall.this.size * 64).create((Entityc)this.tile.build, this.team, this.x, this.y, 0.0f);
                this.shieldLife = ReleaseShieldWall.this.lifetime;
                this.acceptDamage = false;
                this.totalDamage = 0.0f;
                this.clientDamage = 0.0f;
            }
            if (this.shieldLife > 0.0f) {
                if (this.shieldBullet != null) {
                    this.shieldBullet.set(this.x, this.y);
                    this.shieldBullet.time = 0.0f;
                }
                this.shieldLife -= Time.delta;
            } else {
                this.shieldBullet = null;
                this.acceptDamage = true;
            }
        }

        public void damage(float damage) {
            super.damage(damage);
            if (this.acceptDamage) {
                if (!Vars.net.client()) {
                    if (Mathf.chance((double)ReleaseShieldWall.this.chargeChance)) {
                        this.totalDamage += damage;
                    }
                } else if (Mathf.chance((double)ReleaseShieldWall.this.chargeChance)) {
                    this.clientDamage += damage;
                }
            }
        }

        public void setDamage(float v) {
            if (Vars.net.client()) {
                this.totalDamage = v;
            }
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.totalDamage);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.totalDamage = read.f();
        }
    }

    public static class ShieldBullet
    extends BulletType {
        public float range;
        public Effect openEffect;

        public ShieldBullet(float range) {
            this.range = range;
            this.openEffect = new Effect(35.0f, e -> {
                Draw.color((Color)e.color);
                Lines.stroke((float)(e.fout() * 4.0f));
                Lines.poly((float)e.x, (float)e.y, (int)6, (float)(range * 0.525f + 75.0f * e.fin()));
            });
            this.hittable = false;
            this.absorbable = false;
            this.hitEffect = this.despawnEffect = Fx.none;
            this.lifetime = 60.0f;
            this.damage = 0.0f;
            this.speed = 0.0f;
            this.collides = false;
            this.collidesAir = false;
            this.collidesGround = false;
            this.keepVelocity = false;
            this.reflectable = false;
        }

        public void update(Bullet b) {
            float realRange = this.range * b.fout();
            Groups.bullet.intersect(b.x - realRange, b.y - realRange, realRange * 2.0f, realRange * 2.0f, trait -> {
                if (trait.type.absorbable && trait.team != b.team && Intersector.isInsideHexagon((float)trait.getX(), (float)trait.getY(), (float)realRange, (float)b.x, (float)b.y)) {
                    trait.absorb();
                    EUFx.shieldDefense.at(trait.getX(), trait.getY(), EUItems.lightninAlloy.color);
                }
            });
        }

        public void init(Bullet b) {
            if (b == null) {
                return;
            }
            this.openEffect.at(b.x, b.y, b.fout(), EUItems.lightninAlloy.color);
        }

        public void draw(Bullet b) {
            Draw.color((Color)EUItems.lightninAlloy.color);
            float fout = Math.min(b.fout(), 0.5f) * 2.0f;
            Lines.stroke((float)(fout * 3.0f));
            Lines.poly((float)b.x, (float)b.y, (int)6, (float)(this.range * 0.525f * fout * fout));
        }
    }
}

