/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.unit;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Team;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.payloads.PayloadSource;
import mindustry.world.blocks.storage.CoreBlock;

public class ADCPayloadSource
extends PayloadSource {
    private final Team[] teams = new Team[]{Team.derelict, Team.sharded, Team.crux, Team.green, Team.malis, Team.blue};

    public ADCPayloadSource(String name) {
        super(name);
        this.noUpdateDisabled = false;
        this.unitCapModifier = 1;
        this.targetable = false;
        this.underBullets = true;
        this.destructible = false;
        this.config(Block.class, (build, block) -> {
            if (this.canProduce((Block)block) && build.configBlock != block) {
                build.configBlock = block;
                build.unit = null;
                build.payload = null;
                build.scl = 0.0f;
            }
        });
        this.config(UnitType.class, (build, unit) -> {
            if (this.canProduce((UnitType)unit) && build.unit != unit) {
                build.unit = unit;
                build.configBlock = null;
                build.payload = null;
                build.scl = 0.0f;
            }
        });
        this.config(Integer.class, (build, i) -> {
            build.unit = null;
            build.configBlock = null;
            build.payload = null;
            build.scl = 0.0f;
        });
        this.configClear(build -> {
            build.configBlock = null;
            build.unit = null;
            build.payload = null;
            build.scl = 0.0f;
        });
    }

    public boolean canProduce(Block b) {
        return b.isVisible() && !(b instanceof CoreBlock) && !Vars.state.rules.isBanned(b) && b.environmentBuildable();
    }

    public class ADCPayloadSourceBuild
    extends PayloadSource.PayloadSourceBuild {
        public ADCPayloadSourceBuild() {
            super((PayloadSource)ADCPayloadSource.this);
        }

        public void updateTile() {
            this.enabled = true;
            super.updateTile();
        }

        public void buildConfiguration(Table table) {
            ButtonGroup g = new ButtonGroup();
            Table cont = new Table();
            cont.defaults().size(55.0f);
            for (int i = 0; i < ADCPayloadSource.this.teams.length; ++i) {
                Team team1 = ADCPayloadSource.this.teams[i];
                ImageButton button = (ImageButton)cont.button(((TextureRegionDrawable)Tex.whiteui).tint(team1.color), Styles.clearTogglei, 35.0f, () -> {}).group(g).get();
                button.changed(() -> {
                    if (button.isChecked()) {
                        if (Vars.player.team() == this.team) {
                            this.configure(team1.id);
                        } else {
                            this.deselect();
                        }
                    }
                });
                button.update(() -> button.setChecked(this.team == team1));
            }
            table.add((Element)cont).maxHeight(Scl.scl((float)110.0f)).left();
            table.row();
            ItemSelection.buildTable((Block)ADCPayloadSource.this, (Table)table, (Seq)Vars.content.blocks().select(ADCPayloadSource.this::canProduce).as().add(Vars.content.units().select(arg_0 -> ((ADCPayloadSource)ADCPayloadSource.this).canProduce(arg_0)).as()), () -> (UnlockableContent)this.config(), this::configure, (boolean)false, (int)ADCPayloadSource.this.selectionRows, (int)ADCPayloadSource.this.selectionColumns);
        }

        public void configure(Object value) {
            if (Vars.player.team() == this.team) {
                super.configure(value);
            } else {
                this.deselect();
            }
        }

        public void configured(Unit builder, Object value) {
            super.configured(builder, value);
            if (!(value instanceof Integer)) {
                return;
            }
            if (builder != null && builder.isPlayer()) {
                Team team;
                builder.team = team = Team.get((int)((Integer)value));
                builder.getPlayer().team(team);
                this.onRemoved();
                this.changeTeam(team);
                this.onProximityUpdate();
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)ADCPayloadSource.this.region, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)ADCPayloadSource.this.outRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            Draw.color((Color)this.team.color);
            Draw.rect((TextureRegion)ADCPayloadSource.this.teamRegion, (float)this.x, (float)this.y);
            Draw.color();
            Draw.scl((float)this.scl);
            this.drawPayload();
            Draw.reset();
        }

        public void damage(float damage) {
        }

        public boolean canPickup() {
            return false;
        }
    }
}

