/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.unit;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUFx;
import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.EnumSet;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.units.UnitFactory;
import mindustry.world.meta.BlockFlag;

public class DerivativeUnitFactory
extends UnitFactory {
    public int areaSize = 14;
    public Effect aboveEffect = new Effect(24.0f, e -> {
        Draw.color((Color)e.color);
        Fill.circle((float)e.x, (float)e.y, (float)(e.rotation * e.fout()));
    });

    public DerivativeUnitFactory(String name) {
        super(name);
        this.ambientSound = Sounds.bioLoop;
        this.ambientSoundVolume = 0.1f;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.factory});
    }

    public void init() {
        super.init();
        for (UnitFactory.UnitPlan plan : this.plans) {
            this.areaSize = Math.max((int)plan.unit.hitSize / 8, this.areaSize);
        }
    }

    public Rect getRect(Rect rect, float x, float y, int rotation) {
        rect.setCentered(x, y, (float)(this.areaSize * 8));
        float len = (float)(8 * (this.areaSize + this.size)) / 2.0f;
        rect.x += (float)Geometry.d4x((int)rotation) * len;
        rect.y += (float)Geometry.d4y((int)rotation) * len;
        return rect;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        x *= 8;
        y *= 8;
        x = (int)((float)x + this.offset);
        y = (int)((float)y + this.offset);
        Rect rect = this.getRect(Tmp.r1, x, y, rotation);
        Drawf.dashRect((Color)(valid ? Pal.accent : Pal.remove), (Rect)rect);
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        Rect rect = this.getRect(Tmp.r1, tile.worldx() + this.offset, tile.worldy() + this.offset, rotation).grow(0.1f);
        return !Vars.indexer.getFlagged(team, BlockFlag.factory).contains(b -> b instanceof DerivativeBuild && this.getRect(Tmp.r2, b.x, b.y, b.rotation).overlaps(rect));
    }

    public class DerivativeBuild
    extends UnitFactory.UnitFactoryBuild {
        public Vec2 v1;
        public Vec2 v2;
        public Vec2 offset;
        public Vec2 end;
        private final Object[] objects;
        private final Effect espEffect;

        public DerivativeBuild() {
            super((UnitFactory)DerivativeUnitFactory.this);
            this.v1 = new Vec2();
            this.v2 = new Vec2();
            this.offset = new Vec2();
            this.end = new Vec2();
            this.objects = new Object[4];
            this.espEffect = EUFx.edessp(24.0f);
        }

        public Vec2 getUnitSpawn() {
            float len = (float)(8 * (DerivativeUnitFactory.this.areaSize + DerivativeUnitFactory.this.size)) / 2.0f;
            float unitX = this.x + (float)Geometry.d4x((int)this.rotation) * len;
            float unitY = this.y + (float)Geometry.d4y((int)this.rotation) * len;
            this.v2.set(unitX, unitY);
            return this.v2;
        }

        public void updateTile() {
            if (!DerivativeUnitFactory.this.configurable) {
                this.currentPlan = 0;
            }
            if (this.currentPlan < 0 || this.currentPlan >= DerivativeUnitFactory.this.plans.size) {
                this.currentPlan = -1;
            }
            if (this.efficiency > 0.0f && this.currentPlan != -1) {
                this.time += this.edelta() * this.speedScl * Vars.state.rules.unitBuildSpeed(this.team);
                this.progress += this.edelta() * Vars.state.rules.unitBuildSpeed(this.team);
                this.speedScl = Mathf.lerpDelta((float)this.speedScl, (float)1.0f, (float)0.05f);
            } else {
                this.speedScl = Mathf.lerpDelta((float)this.speedScl, (float)0.0f, (float)0.05f);
            }
            this.moveOutPayload();
            if (this.currentPlan != -1 && this.payload == null) {
                UnitFactory.UnitPlan plan = (UnitFactory.UnitPlan)DerivativeUnitFactory.this.plans.get(this.currentPlan);
                if (plan.unit.isBanned()) {
                    this.currentPlan = -1;
                    return;
                }
                if (this.progress >= plan.time) {
                    this.progress %= 1.0f;
                    Unit unit = plan.unit.create(this.team);
                    if (unit.type != null) {
                        Vec2 v = this.getUnitSpawn();
                        float dst = v.dst((Position)this);
                        float a = this.angleTo((Position)v);
                        this.objects[0] = unit.type.fullIcon;
                        this.objects[1] = Float.valueOf(dst);
                        this.objects[2] = Float.valueOf(90.0f * (float)this.rotation - 90.0f);
                        this.objects[3] = Float.valueOf(180.0f);
                        this.espEffect.lifetime = 24.0f / (this.timeScale + 0.001f);
                        this.espEffect.at(this.x, this.y, a, (Object)this.objects);
                    }
                    if (this.commandPos != null && unit.isCommandable()) {
                        unit.command().commandPosition(this.commandPos);
                    }
                    this.payload = new UnitPayload(unit);
                    this.payVector.setZero();
                    this.consume();
                    Events.fire((Object)new EventType.UnitCreateEvent(((UnitPayload)this.payload).unit, (Building)this));
                }
                this.progress = Mathf.clamp((float)this.progress, (float)0.0f, (float)plan.time);
            } else {
                this.progress = 0.0f;
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)DerivativeUnitFactory.this.region, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)DerivativeUnitFactory.this.outRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            Draw.rect((TextureRegion)DerivativeUnitFactory.this.topRegion, (float)this.x, (float)this.y);
            Vec2 v = this.getUnitSpawn();
            float z = Draw.z();
            if (this.currentPlan != -1) {
                UnitFactory.UnitPlan plan = (UnitFactory.UnitPlan)DerivativeUnitFactory.this.plans.get(this.currentPlan);
                Draw.draw((float)35.0f, () -> Drawf.construct((float)v.x, (float)v.y, (TextureRegion)plan.unit.fullIcon, (float)(this.rotdeg() - 90.0f), (float)(this.progress / plan.time + 0.05f), (float)this.speedScl, (float)this.time));
                if (this.efficiency > 0.001f) {
                    Draw.color((Color)Pal.accent);
                    Draw.z((float)122.0f);
                    Fill.circle((float)this.x, (float)this.y, (float)(3.0f * this.efficiency * this.speedScl));
                    Drawf.buildBeam((float)this.x, (float)this.y, (float)v.x, (float)v.y, (float)(plan.unit.hitSize / 2.0f * this.efficiency * this.speedScl));
                    if (plan.unit != null) {
                        int i;
                        Draw.z((float)110.0f);
                        Fill.circle((float)this.x, (float)this.y, (float)(1.8f * this.efficiency * this.speedScl));
                        Lines.stroke((float)(2.5f * this.efficiency * this.speedScl));
                        for (i = 1; i <= 3; ++i) {
                            this.end.set(v).sub(this.x, this.y);
                            this.end.setLength(Math.max(2.0f, this.end.len()));
                            this.end.add(this.offset.trns(this.time / 2.0f + (float)(60 * i), Mathf.sin((float)(this.time * 2.0f + (float)(30 * i)), (float)50.0f, (float)(plan.unit.hitSize * 0.6f))));
                            this.end.add(this.x, this.y);
                            Lines.line((float)this.x, (float)this.y, (float)this.end.x, (float)this.end.y);
                            DerivativeUnitFactory.this.aboveEffect.at(this.end.x, this.end.y, 2.0f, Pal.accent);
                            if (Vars.state.isPaused() || !Mathf.chance((double)0.01f)) continue;
                            Fx.hitLancer.at((Position)this.end);
                            Sounds.spark.at(this.end.x, this.end.y, 0.5f, 0.3f);
                        }
                        Draw.color((Color)this.team.color);
                        Lines.arc((float)v.x, (float)v.y, (float)(plan.unit.hitSize * 1.2f), (float)(1.0f - this.progress / plan.time), (float)(this.rotation * 90));
                        Vars.control.sound.loop(DerivativeUnitFactory.this.ambientSound, (Position)this.self(), DerivativeUnitFactory.this.ambientSoundVolume * this.speedScl * this.efficiency);
                        for (i = 0; i < 2; ++i) {
                            float rot = this.rotation * 90 - 90 + 180 * i;
                            float ax = v.x + Angles.trnsx((float)rot, (float)(plan.unit.hitSize * 1.1f));
                            float ay = v.y + Angles.trnsy((float)rot, (float)(plan.unit.hitSize * 1.1f));
                            for (int a = 0; a < 3; ++a) {
                                float sin = Math.max(0.0f, Mathf.sin((float)(this.time + (float)a * 60.0f), (float)55.0f, (float)1.0f)) * this.speedScl;
                                Draw.rect((TextureRegion)Core.atlas.find(ExtraUtilitiesMod.name("aim-shoot")), (float)(ax + Angles.trnsx((float)(rot + 180.0f), (float)-4.0f) * (4.0f + (float)a * 2.8f)), (float)(ay + Angles.trnsy((float)(rot + 180.0f), (float)-4.0f) * (4.0f + (float)a * 2.8f)), (float)(45.0f * sin), (float)(45.0f * sin), (float)(rot + 90.0f));
                            }
                        }
                    }
                }
            }
            Draw.z((float)z);
            Draw.reset();
        }

        public void drawSelect() {
            super.drawSelect();
            Drawf.dashRect((Color)Pal.accent, (Rect)DerivativeUnitFactory.this.getRect(Tmp.r1, this.x, this.y, this.rotation));
        }
    }
}

