/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUGet;
import ExtraUtilities.content.EUItems;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Interval;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.graphics.Drawf;

public class ArbiterPart
extends DrawPart {
    public int amount;
    public float fade = 0.2f;
    public float fadeInterval = 3.0f;
    public Color lineColor;
    public TextureRegion arrow;
    public float rotSpeed;
    public float adr;
    public float wx;
    public float wy;
    public DrawPart.PartProgress progressWarmup;
    public DrawPart.PartProgress progressReload;
    private final float[] lines;
    private final Interval timer;

    public ArbiterPart(int amount) {
        this.lineColor = EUItems.lightninAlloy.color;
        this.rotSpeed = 1.0f;
        this.adr = 20.0f;
        this.progressWarmup = DrawPart.PartProgress.warmup;
        this.progressReload = DrawPart.PartProgress.reload;
        this.amount = amount;
        this.lines = new float[amount];
        this.timer = new Interval(amount);
    }

    public void draw(DrawPart.PartParams partParams) {
        float warmup = this.progressWarmup.getClamp(params);
        float reload = 1.0f - this.progressReload.getClamp(params);
        float rot = ArbiterPart.params.rotation - 90.0f;
        float ax = ArbiterPart.params.x + Angles.trnsx((float)rot, (float)this.wx, (float)this.wy);
        float ay = ArbiterPart.params.y + Angles.trnsy((float)rot, (float)this.wx, (float)this.wy);
        float z = Draw.z();
        if (warmup > 1.0E-4f) {
            int i;
            Draw.z((float)110.0f);
            for (i = 0; i < this.amount; ++i) {
                float gly;
                float glx;
                float ag = 360.0f / (float)this.amount * (float)i + Time.time * this.rotSpeed;
                float lx = EUGet.dx(ax, this.adr, ag);
                float ly = EUGet.dy(ay, this.adr, ag);
                if (this.timer.get(i, this.fadeInterval)) {
                    this.lines[i] = Mathf.lerpDelta((float)this.lines[i], (float)Math.max(0.0f, Mathf.random((float)-32.0f, (float)(16.0f * (float)Core.settings.getInt("sfxvol") / 100.0f))), (float)this.fade);
                }
                Lines.stroke((float)(2.0f * warmup), (Color)this.lineColor);
                Lines.lineAngle((float)lx, (float)ly, (float)ag, (float)(this.lines[i] + 0.1f));
                Lines.lineAngle((float)lx, (float)ly, (float)(ag - 180.0f), (float)(this.lines[i] * 2.0f + 0.1f));
                if (i < this.amount / 2) {
                    glx = EUGet.dx(ax, this.adr + 2.0f * (float)i, rot);
                    gly = EUGet.dy(ay, this.adr + 2.0f * (float)i, rot);
                    Lines.stroke((float)(1.5f * warmup), (Color)this.lineColor);
                    Lines.lineAngle((float)glx, (float)gly, (float)(rot + 90.0f), (float)(this.lines[i] * 0.5f + 0.1f));
                    Lines.lineAngle((float)glx, (float)gly, (float)(rot - 90.0f), (float)(this.lines[i] * 0.5f + 0.1f));
                    continue;
                }
                glx = EUGet.dx(ax, this.adr + 2.0f * ((float)i - (float)this.amount / 2.0f), rot - 180.0f);
                gly = EUGet.dy(ay, this.adr + 2.0f * ((float)i - (float)this.amount / 2.0f), rot - 180.0f);
                Lines.stroke((float)(1.5f * warmup), (Color)this.lineColor);
                Lines.lineAngle((float)glx, (float)gly, (float)(rot + 90.0f), (float)(this.lines[i] * 0.5f + 0.1f));
                Lines.lineAngle((float)glx, (float)gly, (float)(rot - 90.0f), (float)(this.lines[i] * 0.5f + 0.1f));
            }
            Draw.color((Color)this.lineColor);
            for (i = 0; i < 3; ++i) {
                Drawf.tri((float)ax, (float)ay, (float)(this.adr / 4.0f * warmup), (float)(15 * (i == 0 ? 2 : 1)), (float)(rot - 90.0f + (float)(120 * i)));
            }
            Draw.color((Color)Tmp.c1.set(this.lineColor).a(warmup));
            for (int s : Mathf.signs) {
                float aix = ArbiterPart.params.x + Angles.trnsx((float)rot, (float)(16 * s), (float)-8.0f);
                float aiy = ArbiterPart.params.y + Angles.trnsy((float)rot, (float)(16 * s), (float)-8.0f);
                int sp = 10;
                float ln = 50.0f;
                int i2 = 0;
                while ((float)i2 <= ln / (float)sp) {
                    Tmp.v1.trns(rot + 90.0f, (float)(i2 * sp));
                    float track = Mathf.curve((float)Interp.pow2Out.apply(reload), (float)0.0f, (float)0.25f) * Mathf.curve((float)Interp.pow4Out.apply(reload), (float)0.0f, (float)0.3f) * reload;
                    float f = Interp.pow3Out.apply(Mathf.clamp((float)((reload * ln - (float)(i2 * sp)) / (float)sp))) * (0.6f + track * 0.4f);
                    Draw.rect((TextureRegion)this.arrow, (float)(aix + Tmp.v1.x), (float)(aiy + Tmp.v1.y), (float)(135.0f * Draw.scl * f), (float)(135.0f * Draw.scl * f), (float)rot);
                    ++i2;
                }
            }
            Draw.z((float)25.0f);
            Lines.stroke((float)(1.7f * warmup), (Color)Tmp.c2.set(this.lineColor).a(warmup));
            Lines.circle((float)ArbiterPart.params.x, (float)ArbiterPart.params.y, (float)36.0f);
            for (int i3 = 0; i3 < 4; ++i3) {
                float a = (float)(i3 * 90) + Time.time * warmup;
                float rx = EUGet.dx(ArbiterPart.params.x, 36.0f, a);
                float ry = EUGet.dy(ArbiterPart.params.y, 36.0f, a);
                Draw.rect((TextureRegion)this.arrow, (float)rx, (float)ry, (float)(a + 90.0f));
            }
        }
        Draw.z((float)z);
    }

    public void load(String s) {
        this.arrow = Core.atlas.find(ExtraUtilitiesMod.name("aim-shoot"));
    }
}

