/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.ExtraUtilitiesMod;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;

public class DrawArrow
extends DrawPart {
    public float arrowSpacing = 2.0f;
    public float arrowOffset = 0.0f;
    public float arrowPeriod = 0.4f;
    public float arrowTimeScl = 12.0f;
    public float arrowSize = 35.0f;
    public float len = 6.0f;
    public float x;
    public float y;
    public float layer = -1.0f;
    public float layerOffset = 0.0f;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public Color color = Color.white;

    public void draw(DrawPart.PartParams params) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        if (this.under && this.turretShading) {
            Draw.z((float)(z - 1.0E-4f));
        }
        Draw.z((float)(Draw.z() + this.layerOffset));
        int i = params.sideOverride == -1 ? 0 : params.sideOverride;
        float sign = (i == 0 ? 1 : -1) * params.sideMultiplier;
        Tmp.v1.set(this.x * sign, this.y).rotate(params.rotation - 90.0f);
        float rx = params.x + Tmp.v1.x;
        float ry = params.y + Tmp.v1.y;
        int arrows = (int)(this.len / this.arrowSpacing);
        Draw.color((Color)this.color);
        for (int a = 0; a < arrows; ++a) {
            Draw.alpha((float)(Mathf.absin((float)((float)a - Time.time / this.arrowTimeScl), (float)this.arrowPeriod, (float)1.0f) * this.progress.getClamp(params)));
            Draw.rect((TextureRegion)Core.atlas.find(ExtraUtilitiesMod.name("arrow")), (float)(rx + Angles.trnsx((float)(params.rotation + 180.0f), (float)(-this.arrowSpacing)) * ((float)a * this.arrowSpacing + this.arrowOffset)), (float)(ry + Angles.trnsy((float)(params.rotation + 180.0f), (float)(-this.arrowSpacing)) * ((float)a * this.arrowSpacing + this.arrowOffset)), (float)this.arrowSize, (float)this.arrowSize, (float)params.rotation);
        }
        Draw.color();
        Draw.alpha((float)1.0f);
    }

    public void load(String name) {
    }
}

