/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.part.DrawPart;

public class DrawBall
extends DrawPart {
    public float x;
    public float y;
    public int id = 0;
    public float scl = 15.0f;
    public float radius = 8.0f;
    public float size = 2.5f;
    public int trailLen = 15;
    public Color bColor = Color.white;
    public boolean mirror = false;
    public float rotate = 0.0f;
    public float layer = -1.0f;
    public float layerOffset = 0.0f;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public Vec2 offsetVec;
    public Vec2 endVec;
    public boolean line = false;

    public void draw(DrawPart.PartParams params) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        if (this.under && this.turretShading) {
            Draw.z((float)(z - 1.0E-4f));
        }
        Draw.z((float)(Draw.z() + this.layerOffset));
        float p = this.progress.getClamp(params);
        float r = this.radius * p;
        int len = this.mirror && params.sideOverride == -1 ? 2 : 1;
        for (int s = 0; s < len; ++s) {
            int i = params.sideOverride == -1 ? s : params.sideOverride;
            float sign = (i == 0 ? 1 : -1) * params.sideMultiplier;
            Tmp.v1.set(this.x * sign, this.y).rotate(params.rotation - 90.0f);
            float rx = params.x + Tmp.v1.x;
            float ry = params.y + Tmp.v1.y;
            this.drawBall(rx, ry, this.rotate, this.trailLen, p, this.offsetVec, this.endVec, this.bColor);
        }
    }

    public void load(String name) {
    }

    public void drawBall(float x, float y, float rotation, int trailLen, float p, Vec2 lastEnd, Vec2 offset, Color color) {
        if ((double)p < 0.001) {
            return;
        }
        Fx.rand.setSeed((long)this.id);
        float trailWid = this.size * p;
        lastEnd.add(offset.trns(Fx.rand.random(360.0f) + Time.time * 2.0f, Mathf.sin((float)(Time.time + Fx.rand.random(200.0f)), (float)this.scl, (float)(this.radius * 1.5f)))).rotate(rotation);
        lastEnd.add(x, y);
        float sin = Mathf.sin((float)Time.time, (float)6.0f, (float)0.6f) * p;
        Draw.color((Color)color);
        if (this.line) {
            Lines.stroke((float)(trailWid / 2.0f + sin));
            Lines.circle((float)lastEnd.x, (float)lastEnd.y, (float)(trailWid + sin));
        } else {
            Fill.circle((float)lastEnd.x, (float)lastEnd.y, (float)(trailWid + sin));
        }
    }
}

