/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.part.DrawPart;

public class DrawElectric
extends DrawPart {
    public float x;
    public float y;
    public float radius = 8.0f;
    public float linMti = 1.0f;
    public Color bColor = Color.white;
    public Color lColor = Color.white;
    public boolean mirror = false;
    public float rotateSpeed = 3.0f;
    public float layer = -1.0f;
    public float layerOffset = 0.0f;
    public float colorChose = 0.0f;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public int point = 5;
    public boolean circle = true;
    public boolean square = true;
    public boolean colorful = true;
    public float[] xp = new float[this.point];
    public float[] yp = new float[this.point];
    public float timer = 0.0f;

    public void draw(DrawPart.PartParams params) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        if (this.under && this.turretShading) {
            Draw.z((float)(z - 1.0E-4f));
        }
        Draw.z((float)(Draw.z() + this.layerOffset));
        float p = this.progress.getClamp(params);
        float r = this.radius * p;
        int len = this.mirror && params.sideOverride == -1 ? 2 : 1;
        float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f);
        float baseRot = Time.time * this.rotateSpeed;
        Draw.color((Color)this.lColor, (Color)this.bColor, (float)(this.colorful ? sin : this.colorChose));
        for (int s = 0; s < len; ++s) {
            int a;
            int i = params.sideOverride == -1 ? s : params.sideOverride;
            float sign = (i == 0 ? 1 : -1) * params.sideMultiplier;
            Tmp.v1.set(this.x * sign, this.y).rotate(params.rotation - 90.0f);
            float rx = params.x + Tmp.v1.x;
            float ry = params.y + Tmp.v1.y;
            Lines.stroke((float)(1.2f * p));
            if (this.square) {
                Lines.square((float)rx, (float)ry, (float)this.radius, (float)(-baseRot));
            }
            Lines.stroke((float)(2.0f * p));
            if (this.circle) {
                Lines.circle((float)rx, (float)ry, (float)(this.radius * 1.2f));
            }
            if (this.point < 2 || (double)p < 1.0E-4) {
                return;
            }
            Lines.stroke((float)(1.5f * p));
            if (!Vars.state.isPaused()) {
                float f = this.timer;
                this.timer = f + 1.0f;
                if (f > 3.0f) {
                    for (a = 0; a < this.point; ++a) {
                        this.xp[a] = rx + Mathf.range((float)(r * this.linMti));
                        this.yp[a] = ry + Mathf.range((float)(r * this.linMti));
                    }
                    this.timer = 0.0f;
                }
            }
            for (a = 0; a < this.point; ++a) {
                Draw.color((Color)this.bColor, (Color)this.lColor, (float)(a % 2));
                int A = (a + 1) % this.point;
                Lines.line((float)this.xp[a], (float)this.yp[a], (float)this.xp[A], (float)this.yp[A]);
            }
            Draw.color();
        }
    }

    public void load(String name) {
    }
}

