/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.content.EUGet;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import java.time.LocalDateTime;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Fonts;

public class DrawFunc {
    public static void circlePercent(float x, float y, float rad, float percent, float angle) {
        Lines.arc((float)x, (float)y, (float)rad, (float)percent, (float)angle);
    }

    public static void drawSnow(float x, float y, float rad, float rot, Color color) {
        Draw.color((Color)color);
        for (int i = 0; i < 6; ++i) {
            float angle = (float)(60 * i) + rot;
            Drawf.tri((float)(x + Angles.trnsx((float)angle, (float)rad)), (float)(y + Angles.trnsy((float)angle, (float)rad)), (float)(rad / 3.0f), (float)rad, (float)(angle - 180.0f));
            Drawf.tri((float)(x + Angles.trnsx((float)angle, (float)rad)), (float)(y + Angles.trnsy((float)angle, (float)rad)), (float)(rad / 3.0f), (float)(rad / 4.0f), (float)angle);
        }
        Draw.reset();
    }

    public static void drawClockTable(Building build, int size, float clockSize, float fontSize, float fontHeight, Color backColor) {
        float z = Draw.z();
        Draw.z((float)220.0f);
        float totalHeight = clockSize + fontHeight;
        float dy = build.y + (float)size / 2.0f * 8.0f;
        float bx = dy + totalHeight / 2.0f;
        Draw.color((Color)backColor);
        Fill.rect((float)build.x, (float)bx, (float)clockSize, (float)totalHeight);
        float cy = dy + fontHeight + clockSize / 2.0f;
        Draw.color((Color)Pal.lightishGray);
        float showSize = clockSize / 2.0f;
        Fill.circle((float)build.x, (float)cy, (float)showSize);
        float angle = 90.0f;
        for (int i = 12; i > 0; --i) {
            float len = 5.0f;
            if (i % 3 == 0) {
                len *= 1.8f;
            }
            float lx = EUGet.dx(build.x, showSize, angle);
            float ly = EUGet.dy(cy, showSize, angle);
            Lines.stroke((float)2.0f, (Color)Color.white);
            Lines.lineAngle((float)lx, (float)ly, (float)(angle + 180.0f), (float)len);
            Lines.stroke((float)1.0f, (Color)Color.black);
            Lines.lineAngle((float)lx, (float)ly, (float)(angle + 180.0f), (float)len);
            angle += 30.0f;
        }
        LocalDateTime localDate = LocalDateTime.now();
        int s = localDate.getSecond();
        int m = localDate.getMinute();
        int h = localDate.getHour();
        int mt = localDate.getMonthValue();
        int dt = localDate.getDayOfMonth();
        float ha = (float)(90 - h % 12 * 30) - 30.0f * ((float)m / 60.0f);
        Lines.stroke((float)3.0f, (Color)Color.black);
        Lines.lineAngle((float)build.x, (float)cy, (float)ha, (float)(showSize * 0.5f));
        Lines.stroke((float)1.5f, (Color)Color.white);
        Lines.lineAngle((float)build.x, (float)cy, (float)ha, (float)(showSize * 0.5f));
        float ma = 90.0f - (float)m / 60.0f * 360.0f - 6.0f * ((float)s / 60.0f);
        Lines.stroke((float)3.0f, (Color)Color.black);
        Lines.lineAngle((float)build.x, (float)cy, (float)ma, (float)(showSize * 0.8f));
        Lines.stroke((float)1.5f, (Color)Color.white);
        Lines.lineAngle((float)build.x, (float)cy, (float)ma, (float)(showSize * 0.8f));
        float sa = 90.0f - (float)s / 60.0f * 360.0f;
        Lines.stroke((float)1.0f, (Color)Color.white);
        Lines.lineAngle((float)build.x, (float)cy, (float)sa, (float)(showSize * 0.9f));
        Lines.stroke((float)0.5f, (Color)Color.black);
        Lines.lineAngle((float)build.x, (float)cy, (float)sa, (float)(showSize * 0.9f));
        float fy = dy + fontHeight / 2.0f;
        Fonts.outline.draw((CharSequence)(DrawFunc.zeroTime(h) + " : " + DrawFunc.zeroTime(m) + " : " + DrawFunc.zeroTime(s)), build.x, fy + fontSize * 8.0f, Color.white, fontSize, false, 1);
        Fonts.outline.draw((CharSequence)(DrawFunc.zeroTime(mt) + " M " + DrawFunc.zeroTime(dt) + " D "), build.x, fy - fontSize * 8.0f, Color.white, fontSize, false, 1);
        Draw.reset();
        Draw.z((float)z);
    }

    public static void drawClockTable(Building build, int size, float clockSize, float fontSize, float fontHeight, Color backColor, TextureRegion clock, TextureRegion st, TextureRegion mt, TextureRegion ht) {
        DrawFunc.drawClockTable(220.0f, build, size, clockSize, fontSize, fontHeight, backColor, clock, st, mt, ht);
    }

    public static void drawClockTable(float layer, Building build, int size, float clockSize, float fontSize, float fontHeight, Color backColor, TextureRegion clock, TextureRegion st, TextureRegion mt, TextureRegion ht) {
        float z = Draw.z();
        if (layer >= -11.0f) {
            Draw.z((float)layer);
        }
        float totalHeight = clockSize + fontHeight;
        float dy = build.y + (float)size / 2.0f * 8.0f;
        float by = size > 0 ? dy + totalHeight / 2.0f : build.y;
        Draw.color((Color)backColor);
        Fill.rect((float)build.x, (float)by, (float)clockSize, (float)totalHeight);
        float cy = size > 0 ? dy + fontHeight + clockSize / 2.0f : build.y;
        Draw.color();
        Draw.rect((TextureRegion)clock, (float)build.x, (float)cy, (float)clockSize, (float)clockSize);
        LocalDateTime localDate = LocalDateTime.now();
        int s = localDate.getSecond();
        int m = localDate.getMinute();
        int h = localDate.getHour();
        int mth = localDate.getMonthValue();
        int day = localDate.getDayOfMonth();
        float ha = (float)(-(h % 12) * 30) - (float)(m % 60) / 2.0f;
        Draw.rect((TextureRegion)ht, (float)build.x, (float)cy, (float)clockSize, (float)clockSize, (float)ha);
        float ma = -((float)m / 60.0f * 360.0f) - (float)(s % 60) / 10.0f;
        Draw.rect((TextureRegion)mt, (float)build.x, (float)cy, (float)clockSize, (float)clockSize, (float)ma);
        float sa = -((float)s / 60.0f * 360.0f);
        Draw.rect((TextureRegion)st, (float)build.x, (float)cy, (float)clockSize, (float)clockSize, (float)sa);
        if (fontHeight > 0.0f) {
            float fy = dy + fontHeight / 2.0f;
            Fonts.outline.draw((CharSequence)(DrawFunc.zeroTime(h) + " : " + DrawFunc.zeroTime(m) + " : " + DrawFunc.zeroTime(s)), build.x, fy + fontSize * 8.0f, Color.white, fontSize, false, 1);
            Fonts.outline.draw((CharSequence)(DrawFunc.zeroTime(mth) + " M " + DrawFunc.zeroTime(day) + " D "), build.x, fy - fontSize * 8.0f, Color.white, fontSize, false, 1);
        }
        Draw.reset();
        Draw.z((float)z);
    }

    public static String zeroTime(int time) {
        if (time < 10) {
            return "0" + time;
        }
        return "" + time;
    }
}

