/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.worlds.blocks.heat.HeatDriver;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Eachable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawHeatDriver
extends DrawBlock {
    public TextureRegion turretPart;
    public TextureRegion turretLine;
    public TextureRegion lPart;
    public TextureRegion rPart;
    public TextureRegion lLine;
    public TextureRegion rLine;
    public TextureRegion eff1;
    public TextureRegion eff2;
    public TextureRegion arrow;
    public TextureRegion preview;
    public float arrowSpacing = 4.0f;
    public float arrowOffset = 2.0f;
    public float arrowPeriod = 0.4f;
    public float arrowTimeScl = 6.2f;
    public Color dc1 = Color.valueOf((String)"ea8878");

    public void draw(Building build) {
        HeatDriver block = (HeatDriver)build.block;
        HeatDriver.HeatDriverBuild b = (HeatDriver.HeatDriverBuild)build;
        float x = build.x;
        float y = build.y;
        this.drawMain(block, b, x, y);
    }

    public void drawMain(HeatDriver block, HeatDriver.HeatDriverBuild build, float x, float y) {
        float angle;
        int i;
        float progress = build.progress;
        float rotation = build.rotation;
        float resProgress = build.resProgress;
        Draw.z((float)50.0f);
        float move = 3.0f * progress;
        Drawf.shadow((TextureRegion)this.turretPart, (float)x, (float)y, (float)(rotation - 90.0f));
        Drawf.shadow((TextureRegion)this.lPart, (float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)0.0f, (float)(-move)) - (float)block.size / 2.0f), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)0.0f, (float)(-move)) - (float)block.size / 2.0f), (float)(rotation - 90.0f));
        Drawf.shadow((TextureRegion)this.rPart, (float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)0.0f, (float)move) - (float)block.size / 2.0f), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)0.0f, (float)move) - (float)block.size / 2.0f), (float)(rotation - 90.0f));
        Draw.rect((TextureRegion)this.rLine, (float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)0.0f, (float)move)), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)0.0f, (float)move)), (float)(rotation - 90.0f));
        Draw.rect((TextureRegion)this.lLine, (float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)0.0f, (float)(-move))), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)0.0f, (float)(-move))), (float)(rotation - 90.0f));
        Draw.rect((TextureRegion)this.turretLine, (float)x, (float)y, (float)(rotation - 90.0f));
        Draw.rect((TextureRegion)this.turretPart, (float)x, (float)y, (float)(rotation - 90.0f));
        Draw.rect((TextureRegion)this.lPart, (float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)0.0f, (float)(-move))), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)0.0f, (float)(-move))), (float)(rotation - 90.0f));
        Draw.rect((TextureRegion)this.rPart, (float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)0.0f, (float)move)), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)0.0f, (float)move)), (float)(rotation - 90.0f));
        float p = Math.min(build.heat / block.visualMaxHeat * build.power.status, 1.0f);
        Draw.color((Color)this.dc1);
        Draw.alpha((float)p);
        Draw.z((float)110.0f);
        if (progress > 0.01f) {
            Draw.rect((TextureRegion)this.eff1, (float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)-8.0f)), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)-8.0f)), (float)(10.0f * progress), (float)(10.0f * progress), (float)(rotation - 90.0f - Time.time * 2.0f));
            Draw.rect((TextureRegion)this.eff2, (float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)-8.0f)), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)-8.0f)), (float)(6.0f * progress), (float)(6.0f * progress), (float)(rotation - 90.0f + Time.time * 2.0f));
            for (i = 0; i < 4; ++i) {
                angle = (float)i * 360.0f / 4.0f;
                Drawf.tri((float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)-8.0f) + Angles.trnsx((float)(angle + Time.time), (float)5.0f)), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)-8.0f) + Angles.trnsy((float)(angle + Time.time), (float)5.0f)), (float)6.0f, (float)(2.0f * progress), (float)(angle + Time.time));
            }
        }
        if (resProgress > 0.01f) {
            Draw.alpha((float)1.0f);
            Lines.stroke((float)(1.0f * resProgress));
            Lines.circle((float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)10.0f)), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)10.0f)), (float)5.0f);
            Lines.circle((float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)10.0f)), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)10.0f)), (float)3.0f);
            for (i = 0; i < 3; ++i) {
                angle = (float)i * 360.0f / 3.0f;
                Drawf.tri((float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)10.0f) + Angles.trnsx((float)(angle - Time.time), (float)5.0f)), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)10.0f) + Angles.trnsy((float)(angle - Time.time), (float)5.0f)), (float)4.0f, (float)(-2.0f * resProgress), (float)(angle - Time.time));
                Drawf.tri((float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)10.0f) + Angles.trnsx((float)(angle + Time.time), (float)3.0f)), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)10.0f) + Angles.trnsy((float)(angle + Time.time), (float)3.0f)), (float)3.0f, (float)(1.0f * resProgress), (float)(angle + Time.time));
            }
        }
        if (build.linkValid()) {
            Building other = Vars.world.build(build.link);
            if (!Angles.near((float)rotation, (float)build.angleTo((Position)other), (float)2.0f)) {
                return;
            }
            Draw.color();
            float dist = build.dst((Position)other) / this.arrowSpacing - (float)block.size;
            int arrows = (int)(dist / this.arrowSpacing);
            for (int a = 0; a < arrows; ++a) {
                Draw.alpha((float)(Mathf.absin((float)((float)a - Time.time / this.arrowTimeScl), (float)this.arrowPeriod, (float)1.0f) * progress * Renderer.bridgeOpacity * p));
                Draw.rect((TextureRegion)this.arrow, (float)(x + Angles.trnsx((float)(rotation + 180.0f), (float)(-this.arrowSpacing)) * (4.0f + (float)a * this.arrowSpacing + this.arrowOffset)), (float)(y + Angles.trnsy((float)(rotation + 180.0f), (float)(-this.arrowSpacing)) * (4.0f + (float)a * this.arrowSpacing + this.arrowOffset)), (float)25.0f, (float)25.0f, (float)rotation);
            }
        }
    }

    public void load(Block block) {
        this.turretPart = Core.atlas.find(block.name + "-turret");
        this.turretLine = Core.atlas.find(block.name + "-turret-outline");
        this.lPart = Core.atlas.find(block.name + "-l");
        this.lLine = Core.atlas.find(block.name + "-l-outline");
        this.rPart = Core.atlas.find(block.name + "-r");
        this.rLine = Core.atlas.find(block.name + "-r-outline");
        this.eff1 = Core.atlas.find(block.name + "-effect");
        this.eff2 = Core.atlas.find(block.name + "-effect");
        this.arrow = Core.atlas.find(block.name + "-arrow");
        this.preview = Core.atlas.find(block.name + "-preview");
    }

    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.preview, (float)plan.drawx(), (float)plan.drawy());
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.preview};
    }
}

