/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawLAE
extends DrawBlock {
    public Color[] colors;
    public float move;
    public float width;
    public float strokeFrom = 2.0f;
    public float strokeTo = 0.5f;
    public float pointyScaling = 0.75f;
    public float backLength = 3.0f;
    public float frontLength = 5.0f;
    public float oscScl = 3.0f;
    public float oscMag = 0.4f;
    public int divisions = 10;

    public DrawLAE(Color[] colors, float move, float width) {
        this.colors = colors;
        this.move = move;
        this.width = width;
    }

    public void draw(Building build) {
        Block block = build.block;
        float x = build.x;
        float y = build.y;
        if (this.move == 0.0f) {
            this.move = (float)block.size / 2.0f * 8.0f;
        }
        if (build.warmup() > 0.0f) {
            for (float mx : new float[]{this.move, -this.move}) {
                for (float my : new float[]{this.move, -this.move}) {
                    float rx = x + mx;
                    float ry = y + my;
                    float rot = build.angleTo(rx, ry) + 180.0f;
                    float baseLen = build.dst(rx, ry) / 1.3f * build.warmup();
                    for (int i = 0; i < this.colors.length; ++i) {
                        Draw.color((Color)Tmp.c1.set(this.colors[i]).mul(1.0f + Mathf.absin((float)Time.time, (float)1.0f, (float)0.1f)));
                        Draw.alpha((float)0.6f);
                        float colorFin = (float)i / (float)(this.colors.length - 1);
                        float baseStroke = Mathf.lerp((float)this.strokeFrom, (float)this.strokeTo, (float)colorFin);
                        float stroke = (this.width + Mathf.absin((float)Time.time, (float)this.oscScl, (float)this.oscMag)) * baseStroke * (build.efficiency > 0.0f ? build.efficiency / 2.0f : build.warmup());
                        float ellipseLenScl = Mathf.lerp((float)(1.0f - (float)i / (float)this.colors.length), (float)1.0f, (float)this.pointyScaling);
                        Lines.stroke((float)stroke);
                        Lines.lineAngle((float)rx, (float)ry, (float)rot, (float)((baseLen - this.frontLength) * build.warmup()), (boolean)false);
                        Drawf.flameFront((float)rx, (float)ry, (int)this.divisions, (float)(rot + 180.0f), (float)this.backLength, (float)(stroke / 2.0f));
                        Tmp.v1.trnsExact(rot, (baseLen - this.frontLength) * build.warmup());
                        Drawf.flameFront((float)(rx + Tmp.v1.x), (float)(ry + Tmp.v1.y), (int)this.divisions, (float)rot, (float)(this.frontLength * ellipseLenScl * build.warmup()), (float)(stroke / 2.0f));
                    }
                    Tmp.v1.trns(rot, baseLen * 1.1f * build.warmup());
                    Draw.reset();
                }
            }
        }
    }
}

