/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Teamc;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.draw.DrawBlock;

public class DrawTrail
extends DrawBlock {
    public float x = 0.0f;
    public float y = -25.0f;
    public float scl = 15.0f;
    public float radius = 16.0f;
    public float size;
    public int length;
    public Color color;
    public int id = 0;
    public Vec2 endVec = new Vec2();
    public Vec2 offsetVec = new Vec2();
    public BulletType ball;

    public DrawTrail(float size, Color color, int length) {
        this.size = size;
        this.color = color;
        this.length = length;
        this.ball = new Ball(color, size, length);
    }

    public void draw(Building build) {
        if (!(build instanceof Turret.TurretBuild)) {
            return;
        }
        Turret.TurretBuild build1 = (Turret.TurretBuild)build;
        if (this.ball != null && build1.wasShooting) {
            Tmp.v1.set(this.x, this.y).rotate(build1.rotation - 90.0f);
            float rx = build.x + Tmp.v1.x;
            float ry = build.y + Tmp.v1.y;
            this.drawBall(build, rx, ry, 0.0f, build.warmup(), this.endVec, this.offsetVec, this.color);
        }
    }

    public void drawBall(Building build, float x, float y, float rotation, float p, Vec2 lastEnd, Vec2 offset, Color color) {
        if ((double)p < 0.001) {
            return;
        }
        rand.setSeed((long)(build.id + this.id));
        lastEnd.add(offset.trns(rand.random(360.0f) + Time.time * 2.0f, Mathf.sin((float)(Time.time + rand.random(200.0f)), (float)this.scl, (float)(this.radius * 1.5f)))).rotate(rotation);
        lastEnd.add(x, y);
        Bullet tb = this.ball.create((Teamc)build, x, y, 0.0f);
        tb.set(lastEnd.x, lastEnd.y);
        tb.time(Math.min(tb.time, 10.0f));
    }

    public static class Ball
    extends BulletType {
        public Color color;
        public float size;

        public Ball(Color color, float size, int length) {
            this.color = color;
            this.size = size;
            this.trailColor = color;
            this.trailLength = length;
            this.trailWidth = size / 2.0f;
            this.despawnEffect = this.healEffect = Fx.none;
            this.absorbable = false;
            this.hittable = false;
            this.collidesGround = false;
            this.collidesAir = false;
            this.collides = false;
            this.speed = 0.0f;
            this.damage = 0.0f;
            this.lifetime = 20.0f;
        }

        public void draw(Bullet b) {
            super.draw(b);
            float p = b.time < 10.0f ? b.time / 10.0f : 1.0f - (b.time - 10.0f) / 10.0f;
            float sin1 = Mathf.sin((float)Time.time, (float)6.0f, (float)0.6f) * p;
            float ra = this.size * p;
            Draw.color((Color)this.color);
            Fill.circle((float)b.x, (float)b.y, (float)(ra + sin1));
        }
    }
}

