/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.content.EUGet;
import ExtraUtilities.content.EUItems;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.graphics.Drawf;

public class PartBow
extends DrawPart {
    public float bowMoveY = -32.0f;
    public float bowFY = -8.0f;
    public float bowWidth = 36.0f;
    public float bowHeight = 15.0f;
    public float bowTk = 8.0f;
    public float turretTk = 15.0f;
    public float visRad = 12.0f;
    public Color color;
    public String arrowSp;
    public DrawPart.PartProgress progressWarmup;
    public DrawPart.PartProgress progressReload;

    public PartBow() {
        this.color = EUItems.lightninAlloy.color;
        this.arrowSp = null;
        this.progressWarmup = DrawPart.PartProgress.warmup;
        this.progressReload = DrawPart.PartProgress.reload;
    }

    public void draw(DrawPart.PartParams params) {
        float warmup = this.progressWarmup.getClamp(params);
        float p = 1.0f - this.progressReload.getClamp(params);
        float rot = params.rotation - 90.0f;
        if ((double)warmup < 0.001) {
            return;
        }
        float rp = Math.min(p * 1.2f, 1.0f);
        float bx = params.x + Angles.trnsx((float)rot, (float)0.0f, (float)this.bowHeight);
        float by = params.y + Angles.trnsy((float)rot, (float)0.0f, (float)this.bowHeight);
        float rx = bx + Angles.trnsx((float)rot, (float)0.0f, (float)(this.bowMoveY * rp + this.bowFY));
        float ry = by + Angles.trnsy((float)rot, (float)0.0f, (float)(this.bowMoveY * rp + this.bowFY));
        Draw.z((float)(95.0f + 15.0f * warmup));
        Draw.color((Color)this.color);
        Fill.circle((float)rx, (float)ry, (float)(3.0f * warmup));
        Lines.stroke((float)(3.0f * warmup));
        for (int i : new int[]{-1, 1}) {
            Tmp.v2.set(this.turretTk * (float)i, this.bowHeight).rotate(rot);
            Tmp.v3.set(this.turretTk * (float)i, this.bowHeight + this.bowTk).rotate(rot);
            float x1 = params.x + Tmp.v2.x;
            float x2 = params.x + Tmp.v3.x;
            float y1 = params.y + Tmp.v2.y;
            float y2 = params.y + Tmp.v3.y;
            float dx = EUGet.dx(x1, this.bowWidth, rot + 270.0f + (70.0f * warmup - this.visRad * rp * warmup) * (float)i);
            float dy = EUGet.dy(y1, this.bowWidth, rot + 270.0f + (70.0f * warmup - this.visRad * rp * warmup) * (float)i);
            Tmp.v1.set(this.bowTk / 2.0f * warmup * (float)i, 0.0f).rotate(rot);
            float dx1 = dx + Tmp.v1.x;
            float dy1 = dy + Tmp.v1.y;
            Fill.tri((float)x1, (float)y1, (float)x2, (float)y2, (float)dx, (float)dy);
            Fill.tri((float)x2, (float)y2, (float)dx, (float)dy, (float)dx1, (float)dy1);
            Lines.line((float)dx, (float)dy, (float)rx, (float)ry);
        }
        Draw.z((float)110.0f);
        Tmp.v1.set(0.0f, this.bowMoveY + this.bowFY).rotate(rot);
        float pullx = bx + Tmp.v1.x;
        float pully = by + Tmp.v1.y;
        Lines.stroke((float)(2.0f * warmup));
        Lines.circle((float)pullx, (float)pully, (float)4.0f);
        float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.5f);
        for (int i = 0; i < 3; ++i) {
            float angle = (float)i * 360.0f / 3.0f;
            Drawf.tri((float)(pullx + Angles.trnsx((float)(angle - Time.time), (float)(5.0f + sin))), (float)(pully + Angles.trnsy((float)(angle - Time.time), (float)(5.0f + sin))), (float)4.0f, (float)(-2.0f * warmup), (float)(angle - Time.time));
        }
        float arx = rx + Angles.trnsx((float)rot, (float)0.0f, (float)(-this.bowMoveY / 2.0f));
        float ary = ry + Angles.trnsy((float)rot, (float)0.0f, (float)(-this.bowMoveY / 2.0f));
        Draw.color((Color)this.color.cpy().a(p));
        if (this.arrowSp != null) {
            Draw.rect((TextureRegion)Core.atlas.find(this.arrowSp), (float)arx, (float)ary, (float)(32.0f * warmup), (float)50.0f, (float)rot);
        } else {
            Drawf.tri((float)arx, (float)ary, (float)(16.0f * warmup), (float)20.0f, (float)(rot + 90.0f));
        }
        Drawf.tri((float)arx, (float)ary, (float)(12.0f * warmup), (float)8.0f, (float)(rot - 90.0f));
        Draw.reset();
    }

    public void load(String s) {
    }
}

