/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.ability;

import ExtraUtilities.content.EUFx;
import ExtraUtilities.worlds.entity.bullet.ElectricStorm;
import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.core.Renderer;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.effect.MultiEffect;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.ammo.PowerAmmoType;
import mindustry.ui.Bar;
import mindustry.world.blocks.power.PowerGraph;
import mindustry.world.blocks.power.PowerNode;

public class BatteryAbility
extends Ability {
    public float capacity;
    public float shieldRange;
    public float range;
    public float px;
    public float py;
    public Effect abEff = EUFx.shieldDefense;
    public BulletType deathElc;
    public static Effect absorb;
    private static Unit paramUnit;
    public static float rangeS;
    private static final Cons<Bullet> cons;
    Building target = null;
    float timerRetarget = 0.0f;
    float amount = 0.0f;

    public BatteryAbility(float capacity, float shieldRange, float range, float px, float py) {
        this.capacity = capacity;
        this.shieldRange = shieldRange;
        this.range = range;
        this.px = px;
        this.py = py;
        this.deathElc = new ElectricStorm(capacity / 100.0f, Pal.heal, 20){
            {
                this.lifetime = 300.0f;
                this.splashDamageRadius = 160.0f;
                this.despawnEffect = this.hitEffect = new MultiEffect(new Effect[]{EUFx.ElectricExp(60.0f, 15.0f, this.splashDamageRadius), EUFx.diffEffect(90.0f, 1.8f, 192.0f, 10, 56.0f, 24.0f, 10.0f, Pal.heal, 0.0f), EUFx.layerCircle(90.0f, 192.0f)});
            }
        };
    }

    protected void setupColor(float satisfaction) {
        Draw.color((Color)Color.white, (Color)Pal.powerLight, (float)((1.0f - satisfaction) * 0.86f + Mathf.absin((float)3.0f, (float)0.1f)));
        Draw.alpha((float)Renderer.laserOpacity);
    }

    protected void findTarget(Unit unit) {
        if (this.target != null) {
            return;
        }
        Vars.indexer.allBuildings(unit.x, unit.y, this.range, other -> {
            if (other.block != null && other.team == unit.team && other.block instanceof PowerNode) {
                this.target = other;
            }
        });
    }

    protected void updateTarget(Unit unit) {
        this.timerRetarget += Time.delta;
        if (this.timerRetarget > 5.0f) {
            this.target = null;
            this.findTarget(unit);
            this.timerRetarget = 0.0f;
        }
    }

    public String localized() {
        return Core.bundle.format("ability.extra-utilities-BatteryAbility", new Object[]{Float.valueOf(this.capacity), Float.valueOf(this.range / 8.0f)});
    }

    public void draw(Unit unit) {
        float x = unit.x + Angles.trnsx((float)unit.rotation, (float)this.py, (float)this.px);
        float y = unit.y + Angles.trnsy((float)unit.rotation, (float)this.py, (float)this.px);
        if (unit.shield > 0.0f) {
            Draw.color((Color)Pal.heal);
            Draw.z((float)110.0f);
            Lines.stroke((float)1.5f);
            Lines.poly((float)unit.x, (float)unit.y, (int)6, (float)this.shieldRange);
        }
        if (this.target == null || this.target.block == null) {
            return;
        }
        if (Mathf.zero((float)Renderer.laserOpacity)) {
            return;
        }
        float z = Draw.z();
        Draw.z((float)70.0f);
        this.setupColor(this.target.power.graph.getSatisfaction());
        ((PowerNode)this.target.block).drawLaser(x, y, this.target.x, this.target.y, 2, this.target.block.size);
        Draw.z((float)z);
        Draw.reset();
    }

    public void update(Unit unit) {
        paramUnit = unit;
        rangeS = this.shieldRange;
        absorb = this.abEff;
        this.updateTarget(unit);
        Groups.bullet.intersect(unit.x - this.shieldRange, unit.y - this.shieldRange, this.shieldRange * 2.0f, this.shieldRange * 2.0f, cons);
        this.amount = unit.shield * 10.0f;
        if (Vars.state.rules.unitAmmo && this.amount > 0.0f) {
            Units.nearby((Team)unit.team, (float)unit.x, (float)unit.y, (float)this.range, other -> {
                float powerPerAmmo;
                float ammoRequired;
                float powerRequired;
                float powerTaken;
                if (other.type.ammoType instanceof PowerAmmoType && (powerTaken = Math.min(this.amount, powerRequired = (ammoRequired = (float)other.type.ammoCapacity - other.ammo) * (powerPerAmmo = ((PowerAmmoType)other.type.ammoType).totalPower / (float)other.type.ammoCapacity))) > 1.0f) {
                    unit.shield -= powerTaken / 10.0f;
                    other.ammo += powerTaken / powerPerAmmo;
                    Fx.itemTransfer.at(unit.x, unit.y, Math.max(powerTaken / 100.0f, 1.0f), Pal.power, other);
                }
            });
        }
        if (this.target == null || this.target.block == null) {
            return;
        }
        PowerGraph g = this.target.power.graph;
        if (g.getPowerBalance() > 0.0f) {
            this.amount = Math.min(this.amount + g.getLastPowerProduced() * Time.delta, this.capacity);
        }
        unit.shield = this.amount / 10.0f;
    }

    public void displayBars(Unit unit, Table bars) {
        bars.add((Element)new Bar(Core.bundle.format("bar.extra-utilities-unitBattery", new Object[0]), Pal.power, () -> this.amount / this.capacity)).row();
    }

    public void death(Unit unit) {
        this.deathElc.create((Teamc)unit, unit.x, unit.y, 0.0f);
    }

    static {
        cons = b -> {
            if (b.team != BatteryAbility.paramUnit.team && b.type.absorbable && Intersector.isInsideHexagon((float)BatteryAbility.paramUnit.x, (float)BatteryAbility.paramUnit.y, (float)(rangeS * 2.0f), (float)b.getX(), (float)b.getY()) && BatteryAbility.paramUnit.shield > 0.0f) {
                b.absorb();
                absorb.at(b.getX(), b.getY(), Pal.heal);
                BatteryAbility.paramUnit.shield = Math.max(BatteryAbility.paramUnit.shield - b.damage, 0.0f);
            }
        };
    }
}

