/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.ability;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUFx;
import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.abilities.ShieldArcAbility;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Unit;

public class PcShieldArcAbility
extends ShieldArcAbility {
    private static Unit paramUnit;
    private static PcShieldArcAbility paramField;
    private static final Vec2 paramPos;
    private static final Cons<Bullet> shieldConsumer;
    protected float widthScale;
    protected float alpha;

    public void update(Unit unit) {
        if (this.data < this.max) {
            this.data += Time.delta * this.regen;
        }
        boolean active = this.data > 0.0f && (unit.isShooting || !this.whenShooting);
        this.alpha = Math.max(this.alpha - Time.delta / 10.0f, 0.0f);
        if (active) {
            this.widthScale = Mathf.lerpDelta((float)this.widthScale, (float)1.0f, (float)0.06f);
            paramUnit = unit;
            paramField = this;
            paramPos.set(this.x, this.y).rotate(unit.rotation - 90.0f).add((Position)unit);
            Groups.bullet.intersect(unit.x - this.radius, unit.y - this.radius, this.radius * 2.0f, this.radius * 2.0f, shieldConsumer);
        } else {
            this.widthScale = Mathf.lerpDelta((float)this.widthScale, (float)0.0f, (float)0.11f);
        }
    }

    public void draw(Unit unit) {
        Vec2 pos = paramPos.set(this.x, this.y).rotate(unit.rotation - 90.0f).add((Position)unit);
        if (this.widthScale > 0.001f) {
            Draw.z((float)125.0f);
            Draw.color((Color)unit.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.alpha));
            if (!Vars.renderer.animateShields) {
                Draw.alpha((float)0.4f);
            }
            if (this.region != null) {
                Vec2 rp = this.offsetRegion ? pos : Tmp.v1.set((Position)unit);
                Draw.yscl = this.widthScale;
                Draw.rect((String)this.region, (float)rp.x, (float)rp.y, (float)(unit.rotation - 90.0f));
                Draw.yscl = 1.0f;
            }
            if (this.drawArc) {
                Lines.stroke((float)(this.width * this.widthScale));
                Lines.arc((float)pos.x, (float)pos.y, (float)this.radius, (float)(this.angle / 360.0f), (float)(unit.rotation + this.angleOffset - this.angle / 2.0f));
            }
        } else {
            Draw.z((float)90.0f);
            Lines.stroke((float)6.0f, (Color)unit.team.color);
            Lines.arc((float)pos.x, (float)pos.y, (float)this.radius, (float)((1.0f - -this.data / (this.cooldown * this.regen)) * this.angle / 360.0f), (float)(unit.rotation - this.angle / 2.0f));
        }
        Draw.reset();
    }

    public String localized() {
        return Core.bundle.format("ability." + ExtraUtilitiesMod.name("EUArcFieldAbility"), new Object[0]);
    }

    static {
        paramPos = new Vec2();
        shieldConsumer = b -> {
            if (b.team != PcShieldArcAbility.paramUnit.team && b.type.absorbable && PcShieldArcAbility.paramField.data > 0.0f && !b.within((Position)paramPos, PcShieldArcAbility.paramField.radius - PcShieldArcAbility.paramField.width / 2.0f) && Tmp.v1.set((Position)b).add(b.vel).within((Position)paramPos, PcShieldArcAbility.paramField.radius + PcShieldArcAbility.paramField.width / 2.0f) && Angles.within((float)paramPos.angleTo((Position)b), (float)(PcShieldArcAbility.paramUnit.rotation + PcShieldArcAbility.paramField.angleOffset), (float)(PcShieldArcAbility.paramField.angle / 2.0f))) {
                b.absorb();
                Fx.absorb.at((Position)b);
                if (PcShieldArcAbility.paramField.data <= b.damage()) {
                    PcShieldArcAbility.paramField.data = 0.0f;
                    PcShieldArcAbility.paramField.data -= PcShieldArcAbility.paramField.cooldown * PcShieldArcAbility.paramField.regen;
                    EUFx.arcShieldBreak.at(PcShieldArcAbility.paramPos.x, PcShieldArcAbility.paramPos.y, 0.0f, PcShieldArcAbility.paramUnit.team.color, (Object)paramUnit);
                } else {
                    PcShieldArcAbility.paramField.data -= b.damage();
                }
                PcShieldArcAbility.paramField.alpha = 1.0f;
            }
        };
    }
}

