/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUFx;
import ExtraUtilities.content.EUGet;
import ExtraUtilities.content.EUStatusEffects;
import ExtraUtilities.worlds.entity.unit.bossEntity;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.pooling.Pools;
import java.util.Objects;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.effect.MultiEffect;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Trail;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.world.Block;

public class ArbiterBulletType
extends BulletType {
    public float estRange = 96.0f;
    public int maxAbs = 24;
    public BulletType dateBullet = new EntBulletType();
    public BulletType starBar = new BulletType(){
        {
            this.absorbable = false;
            this.reflectable = false;
            this.status = EUStatusEffects.awsl;
            this.statusDuration = 15.0f;
            this.splashDamageRadius = 48.0f;
            this.splashDamage = 200.0f;
            this.pierceArmor = true;
            this.homingRange = 120.0f;
            this.homingDelay = 18.0f;
            this.homingPower = 0.1f;
            this.trailWidth = 2.0f;
            this.trailLength = 9;
            this.lifetime = 120.0f;
            this.collides = false;
            this.buildingDamageMultiplier = 0.2f;
            this.despawnEffect = EUFx.layerCircle(45.0f, this.splashDamageRadius);
            this.hitSound = this.despawnSound = Sounds.explosion;
        }

        public void update(Bullet b) {
            this.updateTrail(b);
            if (b.time < this.homingDelay) {
                return;
            }
            this.updateHoming(b);
            Teamc target = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)(this.splashDamageRadius / 4.0f), e -> e != null && e.checkTarget(this.collidesAir, this.collidesGround) && !b.hasCollided(e.id), t -> t != null && this.collidesGround && !b.hasCollided(t.id));
            if (target != null) {
                b.remove();
            }
        }

        public void updateHoming(Bullet b) {
            Teamc target = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)this.homingRange, e -> e != null && e.checkTarget(this.collidesAir, this.collidesGround) && !b.hasCollided(e.id), t -> t != null && this.collidesGround && !b.hasCollided(t.id));
            Teamc dateTarget = null;
            Object object = b.data;
            if (object instanceof Teamc) {
                Teamc t2;
                dateTarget = t2 = (Teamc)object;
            }
            if (target != null) {
                b.vel.setAngle(Angles.moveToward((float)b.rotation(), (float)b.angleTo((Position)target), (float)(this.homingPower * Time.delta * 50.0f)));
            } else if (dateTarget != null) {
                b.vel.setAngle(Angles.moveToward((float)b.rotation(), (float)b.angleTo((Position)dateTarget), (float)(this.homingPower * Time.delta * 50.0f)));
            }
        }

        public void drawTrail(Bullet b) {
            if (this.trailLength > 0 && b.trail != null) {
                float z = Draw.z();
                Draw.z((float)(z - 1.0E-4f));
                b.trail.draw(b.team.color, this.trailWidth);
                Draw.z((float)z);
            }
        }

        public void draw(Bullet b) {
            this.drawTrail(b);
            Draw.color((Color)b.team.color);
            Drawf.tri((float)b.x, (float)b.y, (float)3.0f, (float)10.0f, (float)0.0f);
            Drawf.tri((float)b.x, (float)b.y, (float)3.0f, (float)10.0f, (float)180.0f);
            Drawf.tri((float)b.x, (float)b.y, (float)2.0f, (float)7.0f, (float)90.0f);
            Drawf.tri((float)b.x, (float)b.y, (float)2.0f, (float)7.0f, (float)270.0f);
        }

        public void despawned(Bullet b) {
            this.despawnSound.at((Position)b);
            this.createSplashDamage(b, b.x, b.y);
            this.despawnEffect.at(b.x, b.y, this.splashDamageRadius, b.team.color);
        }
    };

    public ArbiterBulletType() {
        this.absorbable = false;
        this.reflectable = false;
        this.collides = false;
        this.trailLength = 30;
        this.trailWidth = 15.0f;
        this.lifetime = 720.0f;
        this.speed = 0.7f;
        this.splashDamage = 1500.0f;
        this.splashDamageRadius = 192.0f;
        this.intervalBullet = this.starBar;
        this.bulletInterval = 45.0f;
        this.intervalBullets = 1;
        this.despawnEffect = new MultiEffect(new Effect[]{EUFx.diffEffect(90.0f, 0.0f, this.splashDamageRadius, 12, this.splashDamageRadius, 32.0f, 24.0f, null, 0.0f), EUFx.airAsh(90.0f, this.splashDamageRadius, this.splashDamageRadius / 6.0f, null, 3.0f, 30)});
        this.hitSound = this.despawnSound = Sounds.titanExplosion;
    }

    public float continuousDamage() {
        return this.damage;
    }

    public void updateBulletInterval(Bullet b) {
        if (!(b instanceof Arbiter)) {
            return;
        }
        Arbiter a = (Arbiter)b;
        if (b.timer.get(1, this.bulletInterval)) {
            a.ibs.add((Object)this.intervalBullet.create((Entityc)b, b.team, b.x, b.y, b.rotation()));
        }
        if (a.ibs.size > 0) {
            for (Bullet e : a.ibs) {
                int ta = Mathf.randomSeed((long)e.id, (int)80, (int)150);
                float tg = Mathf.randomSeed((long)e.id, (float)360.0f);
                float angle = b.time * 2.0f * (float)(ta % 2 == 0 ? 1 : -1) + tg;
                float tx = EUGet.txy(b.x, b.y, ta, (float)ta / 2.5f, tg, angle, 0);
                float ty = EUGet.txy(b.x, b.y, ta, (float)ta / 2.5f, tg, angle, 1);
                EUGet.movePoint(e, tx, ty, 0.1f);
                e.rotation(e.angleTo(tx, ty));
                e.initVel(e.rotation(), 0.0f);
                e.time = 0.0f;
                Teamc target = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)(this.estRange * 2.0f), en -> en != null && en.checkTarget(this.collidesAir, this.collidesGround), Objects::nonNull);
                if (target == null) continue;
                e.data = target;
                e.initVel(e.angleTo((Position)target), 3.0f);
                a.ibs.remove((Object)e);
            }
        }
    }

    public void update(Bullet b) {
        float ty;
        float tx;
        float angle;
        float tg;
        float fout;
        if (!(b instanceof Arbiter)) {
            return;
        }
        Arbiter a = (Arbiter)b;
        this.updateTrail(b);
        this.updateBulletInterval(b);
        if (!Vars.headless) {
            Vars.control.sound.loop(Sounds.wind, (Position)b, 1.2f);
        }
        float fin = Math.min(b.finpow() * 10.0f, 1.0f);
        float f = fout = b.time > b.lifetime - 24.0f ? Interp.smoother.apply((b.lifetime - b.time) / 24.0f) : 1.0f;
        if (b.timer.get(1.0f)) {
            for (int i = 1; i <= 3; ++i) {
                for (int j = 0; j < 6; ++j) {
                    float ag = (float)(j * 60) + b.time * 2.5f * (float)(i % 2 == 0 ? 1 : -1);
                    float ax = EUGet.dx(b.x, this.estRange * fin * fout * (float)i / 3.0f, ag + (float)(20 * i));
                    float ay = EUGet.dy(b.y, this.estRange * fin * fout * (float)i / 3.0f, ag + (float)(20 * i));
                    EUFx.audioEffect.at(ax, ay, b.team.color);
                    EUFx.normalTrail.at(ax, ay, 3.0f, b.team.color);
                }
            }
        }
        if (b.timer.get(3, 5.0f)) {
            Units.nearbyBuildings((float)b.x, (float)b.y, (float)this.estRange, bd -> {
                if (bd != null && bd.team != b.team) {
                    if (bd.health <= b.damage / 12.0f * this.buildingDamageMultiplier && a.ens.size < this.maxAbs && bd.block != null && bd.block.size <= 3) {
                        a.ens.addUnique((Object)this.dateBullet.create((Entityc)b, b.team, bd.x, bd.y, 0.0f, -1.0f, 0.0f, 1.0f, (Object)bd.block));
                        bd.kill();
                    } else {
                        bd.damagePierce(b.damage / 12.0f * this.buildingDamageMultiplier);
                    }
                }
            });
            Units.nearbyEnemies((Team)b.team, (float)b.x, (float)b.y, (float)this.estRange, ut -> {
                if (ut != null && ut.type != null && ut.targetable(b.team) && !ut.inFogTo(b.team)) {
                    if (ut.type.armor > 80.0f) {
                        if (ut.health <= b.damage * ut.type.armor) {
                            ut.kill();
                            ut.remove();
                        } else {
                            ut.health -= b.damage * ut.type.armor;
                        }
                    } else if ((ut.health <= ut.maxHealth * 0.01f / 12.0f * (1.0f + ut.hitSize / 100.0f) || ut.health <= b.damage / 12.0f) && a.ens.size < this.maxAbs && ut.type.hitSize <= 20.0f) {
                        if (!(ut instanceof bossEntity)) {
                            a.ens.addUnique((Object)this.dateBullet.create((Entityc)b, b.team, ut.x, ut.y, 0.0f, -1.0f, 1.0f, 1.0f, (Object)ut.type));
                            ut.kill();
                            ut.remove();
                        }
                    } else {
                        ut.damagePierce(b.damage / 12.0f);
                        ut.health -= ut.maxHealth * 0.01f / 12.0f * (1.0f + ut.type.hitSize / 100.0f);
                        if (ut.hasEffect(EUStatusEffects.breakage)) {
                            float dmg = b.damage / 24.0f;
                            if (ut.health <= dmg) {
                                ut.kill();
                            } else {
                                ut.health -= dmg;
                            }
                        }
                    }
                }
            });
        }
        Groups.bullet.intersect(b.x - this.estRange, b.y - this.estRange, this.estRange * 2.0f, this.estRange * 2.0f, bullet -> {
            if (bullet.type != null && bullet.team != b.team && b.within((Position)bullet, this.estRange) && bullet.damage >= b.damage / 12.0f) {
                bullet.vel.limit(3.0f);
                bullet.damage -= Time.delta;
            }
            if (bullet.type != null && bullet.team != b.team && b.within((Position)bullet, this.estRange) && (bullet.type.absorbable || bullet.type.hittable) && bullet.type.reflectable && bullet.damage < this.damage / 12.0f && a.ebs.size < this.maxAbs) {
                a.ebs.addUnique(bullet);
            }
        });
        a.ens.removeAll(e -> e == null || !e.isAdded());
        a.ebs.removeAll(e -> e == null || !e.isAdded());
        if (a.ens.size > 0) {
            for (Bullet e2 : a.ens) {
                int ta = Mathf.randomSeed((long)e2.id, (int)80, (int)150);
                tg = Mathf.randomSeed((long)e2.id, (float)360.0f);
                angle = b.time * 2.0f * (float)(ta % 2 == 0 ? 1 : -1) + tg;
                tx = EUGet.txy(b.x, b.y, ta, (float)ta / 2.5f, tg, angle, 0);
                ty = EUGet.txy(b.x, b.y, ta, (float)ta / 2.5f, tg, angle, 1);
                EUGet.movePoint(e2, tx, ty, 0.1f);
                e2.rotation(e2.angleTo(tx, ty));
                e2.initVel(e2.rotation(), 0.0f);
                e2.time = 0.0f;
            }
        }
        if (a.ebs.size > 0) {
            for (Bullet e3 : a.ebs) {
                int ta = Mathf.randomSeed((long)e3.id, (int)80, (int)150);
                tg = Mathf.randomSeed((long)e3.id, (float)360.0f);
                angle = b.time * 2.0f * (float)(ta % 2 == 0 ? 1 : -1) + tg;
                tx = EUGet.txy(b.x, b.y, ta, (float)ta / 2.5f, tg, angle, 0);
                ty = EUGet.txy(b.x, b.y, ta, (float)ta / 2.5f, tg, angle, 1);
                EUGet.movePoint(e3, tx, ty, 0.1f);
                e3.rotation(e3.angleTo(tx, ty));
                e3.initVel(e3.rotation(), 0.0f);
                e3.team(b.team);
                e3.owner(b.owner);
                e3.time = 0.0f;
            }
        }
    }

    public void updateTrail(Bullet b) {
        super.updateTrail(b);
        if (!(b instanceof Arbiter)) {
            return;
        }
        Arbiter a = (Arbiter)b;
        if (!Vars.headless) {
            float fin = Math.min(b.finpow() * 10.0f, 1.0f);
            float fout = b.time > b.lifetime - 24.0f ? Interp.smoother.apply((b.lifetime - b.time) / 24.0f) : 1.0f;
            for (int i = 0; i < 6; ++i) {
                float angle = (float)(i * 60) + b.time * 5.0f;
                float tx = EUGet.txy(b.x, b.y, 50.0f * fin * fout, 20.0f * fin * fout, b.rotation() - 90.0f, angle, 0);
                float ty = EUGet.txy(b.x, b.y, 50.0f * fin * fout, 20.0f * fin * fout, b.rotation() - 90.0f, angle, 1);
                if (a.trails[i] == null) {
                    a.trails[i] = new Trail(24);
                }
                a.trails[i].length = 12;
                a.trails[i].update(tx, ty, this.trailInterp.apply(b.fin()));
            }
        }
    }

    public void drawTrail(Bullet b) {
        float z;
        if (this.trailLength > 0 && b.trail != null) {
            float fin = Math.min(b.finpow() * 10.0f, 1.0f);
            float fout = b.time > b.lifetime - 24.0f ? Interp.smoother.apply((b.lifetime - b.time) / 24.0f) : 1.0f;
            z = Draw.z();
            Draw.z((float)(z - 1.0E-4f));
            b.trail.draw(b.team.color, this.trailWidth * fin * fout);
            Draw.z((float)z);
        }
        if (!(b instanceof Arbiter)) {
            return;
        }
        Arbiter a = (Arbiter)b;
        for (int i = 0; i < 6; ++i) {
            if (a.trails[i] == null) continue;
            z = Draw.z();
            Draw.z((float)(z - 1.0E-4f));
            a.trails[i].draw(b.team.color, 3.0f);
            Draw.z((float)z);
        }
    }

    public void draw(Bullet b) {
        super.draw(b);
        float fin = Math.min(b.finpow() * 10.0f, 1.0f);
        float fout = b.time > b.lifetime - 15.0f ? Interp.smoother.apply((b.lifetime - b.time) / 15.0f) : 1.0f;
        float z = Draw.z();
        Draw.z((float)160.0f);
        Draw.color((Color)Color.black);
        Fill.circle((float)b.x, (float)b.y, (float)(20.0f * fin * fout));
        Draw.z((float)100.0f);
        Draw.color((Color)b.team.color);
        Fill.circle((float)b.x, (float)b.y, (float)(24.0f * fin * fout));
        Draw.z((float)z);
    }

    public void removed(Bullet b) {
    }

    public void despawned(Bullet b) {
        this.createSplashDamage(b, b.x, b.y);
        Damage.status((Team)b.team, (float)b.x, (float)b.y, (float)this.splashDamageRadius, (StatusEffect)EUStatusEffects.awsl, (float)30.0f, (boolean)this.collidesAir, (boolean)this.collidesGround);
        Damage.status((Team)b.team, (float)b.x, (float)b.y, (float)this.splashDamageRadius, (StatusEffect)StatusEffects.freezing, (float)300.0f, (boolean)this.collidesAir, (boolean)this.collidesGround);
        Damage.status((Team)b.team, (float)b.x, (float)b.y, (float)this.splashDamageRadius, (StatusEffect)StatusEffects.electrified, (float)300.0f, (boolean)this.collidesAir, (boolean)this.collidesGround);
        Damage.status((Team)b.team, (float)b.x, (float)b.y, (float)this.splashDamageRadius, (StatusEffect)StatusEffects.wet, (float)300.0f, (boolean)this.collidesAir, (boolean)this.collidesGround);
        Damage.status((Team)b.team, (float)b.x, (float)b.y, (float)this.splashDamageRadius, (StatusEffect)StatusEffects.sapped, (float)300.0f, (boolean)this.collidesAir, (boolean)this.collidesGround);
        if (!Vars.headless) {
            this.despawnSound.at(b.x, b.y, 2.0f);
        }
        Effect.shake((float)5.0f, (float)5.0f, (Position)b);
        EUFx.layerCircle.at(b.x, b.y, this.splashDamageRadius, b.team.color);
        this.despawnEffect.at(b.x, b.y, b.team.color);
        if (!(b instanceof Arbiter)) {
            return;
        }
        Arbiter a = (Arbiter)b;
        if (a.ens.size > 0) {
            for (Bullet e : a.ens) {
                e.initVel(e.rotation(), 3.0f);
            }
        }
        if (a.ebs.size > 0) {
            for (Bullet e : a.ebs) {
                if (e.type == null) continue;
                e.initVel(e.rotation(), e.type.speed);
            }
        }
        if (a.ibs.size > 0) {
            for (Bullet e : a.ibs) {
                e.remove();
            }
        }
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY, @Nullable Teamc target) {
        Arbiter bullet = Arbiter.create();
        for (int i = 0; i < 6; ++i) {
            if (bullet.trails[i] == null) continue;
            bullet.trails[i].clear();
        }
        bullet.ens.clear();
        bullet.ebs.clear();
        bullet.ibs.clear();
        return EUGet.anyOtherCreate(bullet, this, shooter, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
    }

    public static class EntBulletType
    extends BulletType {
        public EntBulletType() {
            this.lifetime = 120.0f;
            this.speed = 0.0f;
            this.damage = 200.0f;
            this.splashDamageRadius = 64.0f;
            this.splashDamage = 200.0f;
            this.pierceArmor = true;
            this.homingRange = 192.0f;
            this.homingDelay = 18.0f;
            this.homingPower = 0.1f;
            this.hittable = false;
            this.absorbable = false;
            this.reflectable = false;
            this.pierce = true;
            this.pierceBuilding = true;
            this.buildingDamageMultiplier = 0.2f;
            this.trailLength = 10;
            this.despawnEffect = EUFx.layerCircle(45.0f, this.splashDamageRadius);
            this.hitEffect = Fx.hitLaserBlast;
            this.hitSound = this.despawnSound = Sounds.explosion;
        }

        public void update(Bullet b) {
            super.update(b);
            if (b.time < this.homingDelay || !(b.data instanceof UnlockableContent)) {
                return;
            }
            Teamc target = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)(this.splashDamageRadius / 3.0f), e -> e != null && e.checkTarget(this.collidesAir, this.collidesGround), t -> t != null && this.collidesGround);
            if (target != null) {
                b.remove();
            }
            if (b.timer.get(3, 30.0f)) {
                b.collided.clear();
            }
        }

        public void hit(Bullet b, float x, float y) {
            this.hitEffect.at(x, y, this.splashDamageRadius, b.team.color);
            if (Vars.headless) {
                this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
            }
            Effect.shake((float)1.0f, (float)1.0f, (Position)b);
        }

        public void draw(Bullet b) {
            Object object = b.data;
            if (!(object instanceof UnlockableContent)) {
                return;
            }
            UnlockableContent content = (UnlockableContent)object;
            float z = Draw.z();
            Draw.z((float)90.0f);
            Draw.rect((TextureRegion)content.fullIcon, (float)b.x, (float)b.y, (float)(b.rotation() - 90.0f));
            Draw.z((float)z);
            super.draw(b);
        }

        public void drawTrail(Bullet b) {
            float size;
            Object object = b.data;
            if (!(object instanceof UnlockableContent)) {
                return;
            }
            UnlockableContent content = (UnlockableContent)object;
            if (content instanceof UnitType) {
                UnitType ut = (UnitType)content;
                size = ut.hitSize / 2.0f;
            } else if (content instanceof Block) {
                Block bk = (Block)content;
                size = bk.size * 4;
            } else {
                size = 0.0f;
            }
            if (this.trailLength > 0 && b.trail != null) {
                float z = Draw.z();
                Draw.z((float)89.9999f);
                b.trail.draw(b.team.color, size);
                Draw.z((float)z);
            }
        }

        public void despawned(Bullet b) {
            if (!Vars.headless) {
                this.despawnSound.at((Position)b);
            }
            this.createSplashDamage(b, b.x, b.y);
            this.despawnEffect.at(b.x, b.y, this.splashDamageRadius, b.team.color);
        }
    }

    public static class Arbiter
    extends Bullet {
        @Nullable
        public Trail[] trails = new Trail[6];
        public Seq<Bullet> ens = new Seq();
        public Seq<Bullet> ebs = new Seq();
        public Seq<Bullet> ibs = new Seq();

        public static Arbiter create() {
            return (Arbiter)((Object)Pools.obtain(Arbiter.class, Arbiter::new));
        }
    }
}

