/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUFx;
import ExtraUtilities.graphics.MainRenderer;
import arc.Core;
import arc.graphics.Color;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.type.unit.MissileUnitType;

public class BlackHoleBullet
extends BulletType {
    public float inRad;
    public float outRad;
    public float rotateSpeed;
    public int minLength = 13;
    public int midLength = 18;
    public int maxLength = 25;
    public float minWidth = 0.9f;
    public float maxWidth = 2.2f;
    public float minSpeed = 0.5f;
    public float midSpeed = 0.7f;
    public float maxSpeed = 1.8f;
    public float impulse = 0.667f;
    public Color accColor = Color.valueOf((String)"B778FF");
    public int amount = 2;

    public BlackHoleBullet() {
        this.speed = 0.0f;
        this.damage = 0.0f;
        this.lifetime = 300.0f;
        this.hittable = false;
        this.absorbable = false;
        this.collidesAir = false;
        this.collidesGround = false;
        this.collides = false;
        this.keepVelocity = false;
        this.despawnEffect = this.healEffect = Fx.none;
    }

    public void draw(Bullet b) {
        float in = b.time <= b.lifetime - 72.0f ? Math.min(b.time / 60.0f, 1.0f) : (b.lifetime - b.time) / 72.0f;
        in = Interp.fastSlow.apply(in);
        MainRenderer.addBlackHole(b.x, b.y, this.inRad * in, this.outRad * in, Math.min(1.0f, in + 0.1f));
        super.draw(b);
    }

    public void drawLight(Bullet b) {
    }

    public void update(Bullet b) {
        float in = b.time <= b.lifetime - 72.0f ? Math.min(b.time / 60.0f, 1.0f) : (b.lifetime - b.time) / 72.0f;
        float finalIn = in = Interp.fastSlow.apply(in);
        Units.nearbyEnemies((Team)b.team, (float)b.x, (float)b.y, (float)(this.outRad * 2.0f), e -> {
            if (e != null && e.targetable(b.team)) {
                float p = this.F(b.x, b.y, e.x, e.y, this.impulse * Math.abs(e.mass() + 1.0f), this.outRad * 2.0f);
                if (e.type instanceof MissileUnitType) {
                    p = this.F(b.x, b.y, e.x, e.y, this.impulse * 2000.0f, this.outRad * 2.0f);
                }
                e.impulseNet(Tmp.v3.set((Position)e).sub((Position)b).nor().scl(-p * Time.delta * finalIn));
                e.vel.limit(5.0f);
            }
        });
        Groups.bullet.intersect(b.x - this.outRad * 2.0f, b.y - this.outRad * 2.0f, this.outRad * 4.0f, this.outRad * 4.0f, bullet -> {
            if (bullet != null && bullet.within((Position)b, this.outRad * 2.0f) && bullet.team != b.team && bullet.type != null && (bullet.type.absorbable || bullet.type.hittable)) {
                float p = this.F(b.x, b.y, bullet.x, bullet.y, this.impulse * 10.0f, this.outRad * 2.0f);
                Vec2 v = Tmp.v4.set((Position)bullet).sub((Position)b).nor().scl(-p * Time.delta * finalIn);
                bullet.vel.add(v.x, v.y);
                bullet.vel.limit(5.0f);
                if (bullet.within((Position)b, this.inRad)) {
                    bullet.damage = 0.0f;
                    bullet.remove();
                }
            }
        });
        if (!Vars.headless && Core.settings != null && Core.settings.getBool("eu-show-hole-acc-disk") && b.time <= b.lifetime - 72.0f) {
            for (int i = 0; i < this.amount; ++i) {
                EUFx.ateData data = EUFx.ateData.create();
                float outRDI = i % 2 == 0 ? this.outRad * 1.2f : this.outRad;
                data.width = Mathf.random((float)this.minWidth, (float)this.maxWidth) * in;
                data.inRad = this.inRad * 0.9f * in;
                data.outRad = Math.max(data.inRad, Mathf.random((float)(this.inRad * 1.1f), (float)outRDI) * in);
                data.speed = data.outRad > this.inRad * 1.5f ? Mathf.random((float)this.minSpeed, (float)this.midSpeed) : Mathf.random((float)(this.midSpeed * 2.0f), (float)this.maxSpeed);
                data.length = data.speed < this.midSpeed ? Mathf.random((int)this.midLength, (int)this.maxLength) : Mathf.random((int)this.minLength, (int)this.midLength);
                data.owner = b;
                if (i % 2 == 0) {
                    data.out = true;
                }
                EUFx.AccretionDiskEffect.at(b.x, b.y, 0.0f, this.accColor, (Object)data);
            }
        }
    }

    public float F(float x, float y, float tx, float ty, float G, float r) {
        float dst = Mathf.dst((float)x, (float)y, (float)tx, (float)ty);
        float ptr = 1.0f - dst / r;
        return G * ptr;
    }
}

