/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUGet;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.struct.FloatSeq;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;

public class ChainLightningFade
extends BulletType {
    public Color color;
    public float linkSpace;
    public float stroke;
    public boolean large = false;
    public boolean back = false;
    public float layer = 100.1f;

    public ChainLightningFade(float lifetime, float linkSpace, float stroke, Color color, float damage, Effect hitEffect) {
        this.keepVelocity = false;
        this.collidesTiles = false;
        this.collides = false;
        this.hittable = false;
        this.absorbable = false;
        this.speed = 0.0f;
        this.despawnEffect = Fx.none;
        this.lifetime = lifetime;
        this.linkSpace = linkSpace;
        this.stroke = stroke;
        this.color = color;
        this.damage = damage;
        this.hitEffect = hitEffect;
        this.status = StatusEffects.shocked;
    }

    private void init(chain b) {
        float ty;
        float tx;
        Object object = b.data;
        if (object instanceof Position) {
            Position p = (Position)object;
            tx = p.getX();
            ty = p.getY();
        } else {
            object = b.data;
            if (object instanceof Float) {
                Float f = (Float)object;
                tx = EUGet.pointAngleX(b.x, b.rotation(), f.floatValue());
                ty = EUGet.pointAngleY(b.y, b.rotation(), f.floatValue());
            } else {
                return;
            }
        }
        float dst = Mathf.dst((float)b.x, (float)b.y, (float)tx, (float)ty);
        Tmp.v1.set(tx, ty).sub(b.x, b.y).nor();
        float normx = Tmp.v1.x;
        float normy = Tmp.v1.y;
        float lp = b.linkSpaceOverride > 0.0f ? b.linkSpaceOverride : this.linkSpace;
        int links = Mathf.ceil((float)(dst / lp));
        float spacing = dst / (float)links;
        b.random.setSeed((long)b.id);
        float ox = b.x;
        float oy = b.y;
        b.px.add(b.x);
        b.py.add(b.y);
        for (int i = 0; i < links; ++i) {
            float ny;
            float nx;
            if (i == links - 1) {
                nx = tx;
                ny = ty;
            } else {
                float len = (float)(i + 1) * spacing;
                Tmp.v1.setToRandomDirection(b.random).scl(lp / 2.0f);
                nx = b.x + normx * len + Tmp.v1.x;
                ny = b.y + normy * len + Tmp.v1.y;
            }
            b.px.add(nx);
            b.py.add(ny);
            if (this.damage > 0.0f) {
                float length = Mathf.dst((float)ox, (float)oy, (float)nx, (float)ny);
                float angle = Angles.angle((float)ox, (float)oy, (float)nx, (float)ny);
                Damage.collideLine((Bullet)b, (Team)b.team, (float)ox, (float)oy, (float)angle, (float)length, (boolean)this.large, (boolean)false);
            }
            ox = nx;
            oy = ny;
        }
    }

    public void init(Bullet b) {
        super.init(b);
        if (!(b instanceof chain)) {
            return;
        }
        this.init((chain)b);
    }

    private void draw(chain b) {
        if (b.px.size != b.py.size) {
            return;
        }
        if (b.px.size > 0) {
            float z = Draw.z();
            Draw.z((float)this.layer);
            Lines.stroke((float)(this.stroke * Mathf.curve((float)b.fout(), (float)0.0f, (float)0.7f)));
            Draw.color((Color)Color.white, (Color)this.color, (float)b.fin());
            b.random.setSeed((long)b.id);
            float fin = Mathf.curve((float)b.fin(), (float)0.0f, (float)0.5f);
            int i = 0;
            while ((float)i < (float)(b.px.size - 1) * fin) {
                float ny;
                float nx;
                float oy;
                float ox;
                if (!this.back) {
                    ox = b.px.get(i);
                    oy = b.py.get(i);
                    nx = b.px.get(i + 1);
                    ny = b.py.get(i + 1);
                } else {
                    int fi = b.px.size - 1 - i;
                    ox = b.px.get(fi);
                    oy = b.py.get(fi);
                    nx = b.px.get(fi - 1);
                    ny = b.py.get(fi - 1);
                }
                Lines.line((float)ox, (float)oy, (float)nx, (float)ny);
                ++i;
            }
            Draw.z((float)z);
            Draw.reset();
        }
    }

    public void despawned(Bullet b) {
        Object object = b.data;
        if (!(object instanceof Position)) {
            return;
        }
        Position p = (Position)object;
        if (this.back) {
            this.createSplashDamage(b, b.x, b.y);
        } else {
            this.createSplashDamage(b, p.getX(), p.getY());
        }
        if (this.despawnEffect != Fx.none) {
            if (!this.back) {
                this.despawnEffect.at(p.getX(), p.getY(), b.rotation(), this.hitColor);
            } else {
                this.despawnEffect.at(b.x, b.y, b.rotation(), this.hitColor);
            }
        }
        if (this.despawnSound != Sounds.none) {
            this.despawnSound.at((Position)b);
        }
        Effect.shake((float)this.despawnShake, (float)this.despawnShake, (Position)b);
    }

    public void draw(Bullet b) {
        if (!(b instanceof chain)) {
            return;
        }
        this.draw((chain)b);
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY, @Nullable Teamc target) {
        chain bullet = chain.create();
        bullet.resetXY();
        bullet.linkSpaceOverride = -1.0f;
        return EUGet.anyOtherCreate(bullet, this, shooter, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, Mover mover, float aimX, float aimY, @Nullable Teamc target, float linkSpaceOverride) {
        chain bullet = chain.create();
        bullet.resetXY();
        bullet.linkSpaceOverride = linkSpaceOverride;
        return EUGet.anyOtherCreate(bullet, this, owner, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, float linkSpaceOverride) {
        return this.create(owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, null, -1.0f, -1.0f, null, linkSpaceOverride);
    }

    public static class chain
    extends Bullet {
        public final Rand random = new Rand();
        public FloatSeq px = new FloatSeq();
        public FloatSeq py = new FloatSeq();
        public float linkSpaceOverride = -1.0f;

        public void resetXY() {
            this.px.clear();
            this.py.clear();
        }

        public static chain create() {
            return (chain)((Object)Pools.obtain(chain.class, chain::new));
        }
    }
}

