/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUFx;
import ExtraUtilities.content.EUGet;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Healthc;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;

public class ElectricStorm
extends BulletType {
    public Color color;
    public int maxTarget;
    public Sound sound = Sounds.spark;
    Effect chain4 = EUFx.chainLightningFadeOverride(4.0f);

    public ElectricStorm(float damage, Color color, int maxTarget) {
        this.damage = damage;
        this.splashDamage = damage * 10.0f;
        this.color = color;
        this.maxTarget = maxTarget;
        this.collidesGround = false;
        this.collidesAir = false;
        this.collides = false;
        this.hittable = false;
        this.absorbable = false;
        this.keepVelocity = false;
        this.despawnEffect = this.hitEffect = Fx.none;
        this.despawnSound = Sounds.explosionbig;
        this.speed = 0.0f;
    }

    public void update(Bullet b) {
        if (b.time >= b.lifetime - EUFx.chainLightningFade.lifetime) {
            return;
        }
        float baseRange = this.splashDamageRadius * 0.1f + this.splashDamageRadius * 0.9f * b.finpow();
        if (b.timer.get(this.lifetime / 15.0f)) {
            Seq t = new Seq();
            Vars.indexer.allBuildings(b.x, b.y, baseRange, building -> {
                if (building.team != b.team && Mathf.chance((double)0.5) && t.size < this.maxTarget) {
                    t.addUnique(building);
                }
            });
            Units.nearbyEnemies((Team)b.team, (float)b.x, (float)b.y, (float)baseRange, unit -> {
                if (Mathf.chance((double)0.5) && t.size < this.maxTarget) {
                    t.addUnique(unit);
                }
            });
            t.removeAll(hc -> hc == null || hc.dead());
            if (t.size > 0) {
                this.sound.at((Position)b);
            }
            for (int i = 0; i < t.size; ++i) {
                Healthc hc2 = (Healthc)t.get(i);
                if (hc2 == null) continue;
                this.chain4.at(b.x, b.y, 0.0f, this.color.cpy().a(0.3f), (Object)hc2);
                Fx.randLifeSpark.at(hc2.getX(), hc2.getY(), b.angleTo((Position)hc2), this.color);
                if (hc2 instanceof Building) {
                    Building bd = (Building)hc2;
                    bd.applySlowdown(0.0f, 300.0f);
                }
                if (hc2 instanceof Unit) {
                    Unit uc = (Unit)hc2;
                    uc.apply(StatusEffects.disarmed, 300.0f);
                }
                hc2.damage(this.damage * Vars.state.rules.unitCrashDamage(b.team));
                if (!((double)hc2.health() < (double)hc2.maxHealth() * 0.04)) continue;
                hc2.kill();
            }
        }
        if (!Vars.state.isPaused()) {
            Effect.shake((float)2.0f, (float)2.0f, (Position)b);
        }
    }

    public void draw(Bullet b) {
        int i;
        float baseRange = this.splashDamageRadius * 0.1f + this.splashDamageRadius * 0.9f * b.finpow();
        Draw.color((Color)this.color);
        Draw.z((float)89.9f);
        Draw.alpha((float)0.3f);
        Fill.circle((float)b.x, (float)b.y, (float)baseRange);
        Draw.z((float)100.0f);
        Lines.stroke((float)(this.splashDamageRadius / 12.0f * b.finpow()), (Color)this.color);
        Lines.circle((float)b.x, (float)b.y, (float)baseRange);
        Draw.color((Color)this.color);
        for (i = 0; i < 2; ++i) {
            Drawf.tri((float)b.x, (float)b.y, (float)(12.0f * b.finpow()), (float)(baseRange * 1.5f), (float)(i * 180));
            Drawf.tri((float)b.x, (float)b.y, (float)(6.0f * b.finpow()), (float)(baseRange / 3.0f), (float)(i * 180 + 90));
        }
        if (b.timer.get(1, 27.0f * b.foutpow() + 3.0f)) {
            if (b.time >= b.lifetime - EUFx.chainLightningFade.lifetime) {
                return;
            }
            for (i = 0; i < 3; ++i) {
                float a = Mathf.random((int)360);
                float x = EUGet.dx(b.x, baseRange, a);
                float y = EUGet.dy(b.y, baseRange, a);
                EUFx.chainLightningFade.at(x, y, 0.0f, this.color, (Object)b);
            }
        }
    }
}

