/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUGet;
import arc.audio.Sound;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Nullable;
import arc.util.pooling.Pools;
import mindustry.entities.Mover;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;

public class FawnFarsiaBit
extends BulletType {
    public ShootBullet shootBullet = (b, s) -> {};
    public Sound shootSound = Sounds.none;
    public float pit = 1.0f;
    public float vol = 1.0f;
    public Approach approach = b -> {};
    public BulletDrawer drawer = b -> {};
    public float ready = 60.0f;
    public float rotateSpeed = 2.0f;
    public float retarget = 12.0f;

    public FawnFarsiaBit() {
        this.lifetime = 180.0f;
        this.hittable = false;
        this.absorbable = false;
        this.collides = false;
        this.keepVelocity = false;
        this.homingRange = 80.0f;
        this.speed = 4.0f;
    }

    public void updateBulletInterval(Bullet b) {
    }

    public void update(Bullet b) {
        super.update(b);
        if (b instanceof Bit) {
            Bit bit = (Bit)b;
            this.update(bit);
        }
    }

    public void update(Bit b) {
        if (b.time > this.ready) {
            b.initVel(b.rotation(), 0.0f);
            if (b.timer.get(4, this.retarget)) {
                float rx = b.x;
                float ry = b.y;
                if (b.target != null) {
                    rx = b.target.x();
                    ry = b.target.y();
                }
                b.target = Units.closestTarget((Team)b.team, (float)rx, (float)ry, (float)this.homingRange, e -> e != null && e.checkTarget(this.collidesAir, this.collidesGround), t -> t != null && this.collidesGround);
            }
            if (b.target != null) {
                this.approach.update(b);
                if (b.within((Position)b.target, this.homingRange + 8.0f) && this.intervalBullet != null && b.timer.get(3, this.bulletInterval)) {
                    this.shootBullet.update(b, this.intervalBullet);
                    this.shootSound.at(b.x, b.y, this.pit, this.vol);
                }
            } else {
                b.ang = Mathf.random((int)360);
            }
        } else {
            float fout = 1.0f - Math.min(1.0f, b.time / this.ready);
            b.initVel(b.rotation(), this.speed * Interp.slowFast.apply(fout));
        }
    }

    public void draw(Bullet b) {
        super.draw(b);
        if (b instanceof Bit) {
            Bit bit = (Bit)b;
            this.drawer.draw(bit);
        }
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY, @Nullable Teamc target) {
        Bit bit = Bit.create();
        bit.target = null;
        bit.ang = Mathf.random((int)360);
        return EUGet.anyOtherCreate(bit, this, shooter, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
    }

    public static interface ShootBullet {
        public void update(Bit var1, BulletType var2);
    }

    public static interface Approach {
        public void update(Bit var1);
    }

    public static interface BulletDrawer {
        public void draw(Bit var1);
    }

    public static class Bit
    extends Bullet {
        @Nullable
        public Teamc target = null;
        public float ang;

        public static Bit create() {
            return (Bit)((Object)Pools.obtain(Bit.class, Bit::new));
        }
    }
}

