/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUFx;
import arc.graphics.Color;
import arc.math.Angles;
import arc.math.geom.Position;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;

public class FlameBulletType
extends BulletType {
    public float flameLength;
    public float flameCone;
    public int particleNumber;

    public FlameBulletType(Color colorBegin, Color colorTo, Color colorEnd, float length, float cone, int number, float lifetime) {
        this.flameLength = length;
        this.flameCone = cone;
        this.particleNumber = number;
        this.lifetime = 0.0f;
        this.damage = 48.0f;
        this.speed = 0.0f;
        this.hitEffect = Fx.none;
        this.smokeEffect = Fx.none;
        this.trailEffect = Fx.none;
        this.despawnEffect = Fx.none;
        this.pierce = true;
        this.collidesAir = false;
        this.absorbable = false;
        this.hittable = false;
        this.keepVelocity = false;
        this.status = StatusEffects.burning;
        this.statusDuration = 240.0f;
        this.buildingDamageMultiplier = 0.4f;
        this.despawnHit = true;
        this.shootEffect = EUFx.flameShoot(colorBegin, colorTo, colorEnd, length, cone, number, lifetime);
    }

    public void hit(Bullet b) {
        if (this.absorbable && b.absorbed) {
            return;
        }
        Units.nearbyEnemies((Team)b.team, (float)b.x, (float)b.y, (float)this.flameLength, unit -> {
            if (Angles.within((float)b.rotation(), (float)b.angleTo((Position)unit), (float)this.flameCone) && unit.checkTarget(this.collidesAir, this.collidesGround)) {
                Fx.hitFlameSmall.at((Position)unit);
                unit.damage(b.damage);
                unit.apply(this.status, this.statusDuration);
            }
        });
        Vars.indexer.allBuildings(b.x, b.y, this.flameLength, other -> {
            if (other.team != b.team && Angles.within((float)b.rotation(), (float)b.angleTo((Position)other), (float)this.flameCone)) {
                Fx.hitFlameSmall.at((Position)other);
                other.damage(b.damage * this.buildingDamageMultiplier);
            }
        });
    }
}

