/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.unit.MissileUnitType;

public class antiMissile
extends BasicBulletType {
    public antiMissile(float homingRange, String sprite) {
        this.homingRange = homingRange;
        this.sprite = sprite;
        this.shrinkY = 0.0f;
        this.width = 8.0f;
        this.height = 9.0f;
        this.trailChance = 0.8f;
        this.trailColor = Color.valueOf((String)"6f6f6f");
        this.damage = 0.0f;
        this.speed = 15.0f;
        this.hitEffect = Fx.blastExplosion;
        this.shootEffect = new Effect(10.0f, e -> {
            Draw.color((Color)Color.white, (Color)Pal.heal, (float)e.fin());
            Lines.stroke((float)(e.fout() * 2.0f + 0.2f));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 13.0f));
        });
        this.smokeEffect = Fx.none;
        this.splashDamage = 0.0f;
        this.splashDamageRadius = 8.0f;
        this.lifetime = homingRange * 2.5f / 15.0f;
        this.absorbable = false;
        this.hittable = false;
        this.reflectable = false;
        this.collides = false;
        this.collidesTiles = false;
        this.collidesAir = false;
        this.collidesGround = false;
    }

    protected float calculateRange() {
        return this.homingRange * 2.5f;
    }

    public void update(Bullet b) {
        Unit target = Units.closestEnemy((Team)b.team, (float)b.x, (float)b.y, (float)this.homingRange, unit -> unit.type instanceof MissileUnitType);
        if (target == null) {
            target = (Teamc)Groups.bullet.intersect(b.x - this.homingRange, b.y - this.homingRange, this.homingRange * 2.0f, this.homingRange * 2.0f).min(bt -> bt.team != b.team && bt.type() != null && (bt.type().homingPower > 0.0f || bt.type().spawnUnit != null), bt -> bt.dst2(b.x, b.y));
        }
        if (target instanceof Bullet) {
            Bullet bt2 = (Bullet)target;
            b.vel.setAngle(Angles.moveToward((float)b.rotation(), (float)b.angleTo((Position)target), (float)(30.0f * Time.delta)));
            if (target.within(b.x, b.y, bt2.type().homingRange * Math.max(Time.delta, 1.0f))) {
                bt2.vel.setAngle(Angles.moveToward((float)bt2.rotation(), (float)target.angleTo((Position)b), (float)(bt2.type().homingPower * Time.delta * 50.0f)));
            }
            if (target.within(b.x, b.y, this.splashDamageRadius * bt2.type().speed * Math.max(Time.delta, 1.0f))) {
                bt2.time += bt2.lifetime;
                b.remove();
            }
        }
        if (target instanceof Unit) {
            Unit ut = target;
            if (ut.type instanceof MissileUnitType) {
                b.vel.setAngle(Angles.moveToward((float)b.rotation(), (float)b.angleTo((Position)target), (float)(30.0f * Time.delta)));
                if (target.within(b.x, b.y, this.homingRange * Math.max(Time.delta, 1.0f))) {
                    ut.vel.setAngle(Angles.moveToward((float)ut.rotation(), (float)target.angleTo((Position)b), (float)(ut.type.rotateSpeed * Time.delta * 50.0f)));
                }
                if (target.within(b.x, b.y, this.splashDamageRadius * Math.max(Time.delta, 1.0f))) {
                    ut.kill();
                    b.remove();
                }
            }
        }
        if (Mathf.chanceDelta((double)this.trailChance)) {
            this.trailEffect.at(b.x, b.y, this.trailParam, this.trailColor);
        }
    }
}

