/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.unit;

import ExtraUtilities.content.EUUnitTypes;
import ExtraUtilities.worlds.entity.ability.bossUnitAbi;
import ExtraUtilities.worlds.entity.unit.bossType;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.StatusEffects;
import mindustry.entities.abilities.Ability;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.UnitEntity;

public class bossEntity
extends UnitEntity {
    private boolean b1 = false;
    public Seq<Building> bs = new Seq();
    public Seq<bossType.pickedBlock> pb = new Seq();
    public transient Interval timer = new Interval(6);

    public int classId() {
        return EUUnitTypes.bossId;
    }

    public void update() {
        super.update();
        if (!this.b1) {
            this.apply(StatusEffects.boss);
            this.b1 = true;
        }
    }

    public boolean reSp() {
        if (this.abilities.length == 0) {
            return false;
        }
        for (Ability ab : this.abilities) {
            if (!(ab instanceof bossUnitAbi)) continue;
            bossUnitAbi ba = (bossUnitAbi)ab;
            return ba.targetable();
        }
        return false;
    }

    public boolean hittable() {
        return !this.reSp() && super.hittable();
    }

    public boolean targetable(Team targeter) {
        return !this.reSp() && super.targetable(targeter);
    }

    public void damage(float amount) {
        if (this.reSp()) {
            return;
        }
        super.damage(Math.min(800.0f, amount * 0.1f));
    }

    public void damagePierce(float amount) {
        if (this.reSp()) {
            return;
        }
        super.damagePierce(Math.min(800.0f, amount * 0.15f));
    }

    public void damageContinuous(float amount) {
        if (this.reSp()) {
            return;
        }
        super.damageContinuous(Math.min(800.0f, amount * 0.1f));
    }

    public void damageContinuousPierce(float amount) {
        if (this.reSp()) {
            return;
        }
        super.damageContinuousPierce(Math.min(800.0f, amount * 0.15f));
    }

    public void kill() {
        if (!(this.type instanceof bossType) || this.abilities.length == 0) {
            return;
        }
        for (Ability ab : this.abilities) {
            if (!(ab instanceof bossUnitAbi)) continue;
            bossUnitAbi ba = (bossUnitAbi)ab;
            if (!ba.isS1()) {
                ba.setD1(true);
                continue;
            }
            super.kill();
        }
    }

    public void writeSync(Writes write) {
        super.writeSync(write);
        if (!(this.type instanceof bossType) || this.abilities.length == 0) {
            return;
        }
        for (Ability ab : this.abilities) {
            if (!(ab instanceof bossUnitAbi)) continue;
            bossUnitAbi ba = (bossUnitAbi)ab;
            write.bool(ba.isD1());
            write.bool(ba.isS1());
        }
    }

    public void readSync(Reads read) {
        super.readSync(read);
        if (!(this.type instanceof bossType) || this.abilities.length == 0) {
            return;
        }
        for (Ability ab : this.abilities) {
            if (!(ab instanceof bossUnitAbi)) continue;
            bossUnitAbi ba = (bossUnitAbi)ab;
            ba.setD1(read.bool());
            ba.setS1(read.bool());
        }
    }
}

