/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.weapon;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.audio.SoundLoop;
import mindustry.entities.Predict;
import mindustry.entities.Sized;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.type.Weapon;

public class BoostWeapon
extends Weapon {
    public void update(Unit unit, WeaponMount mount) {
        boolean can = !unit.disarmed;
        float lastReload = mount.reload;
        mount.reload = Math.max(mount.reload - Time.delta * unit.reloadMultiplier, 0.0f);
        mount.recoil = Mathf.approachDelta((float)mount.recoil, (float)0.0f, (float)(unit.reloadMultiplier / this.recoilTime));
        if (this.recoils > 0) {
            if (mount.recoils == null) {
                mount.recoils = new float[this.recoils];
            }
            for (int i = 0; i < this.recoils; ++i) {
                mount.recoils[i] = Mathf.approachDelta((float)mount.recoils[i], (float)0.0f, (float)(unit.reloadMultiplier / this.recoilTime));
            }
        }
        mount.smoothReload = Mathf.lerpDelta((float)mount.smoothReload, (float)(mount.reload / this.reload), (float)this.smoothReloadSpeed);
        mount.charge = mount.charging && this.shoot.firstShotDelay > 0.0f ? Mathf.approachDelta((float)mount.charge, (float)1.0f, (float)(1.0f / this.shoot.firstShotDelay)) : 0.0f;
        float warmupTarget = can && mount.shoot || this.continuous && mount.bullet != null || mount.charging ? 1.0f : 0.0f;
        mount.warmup = this.linearWarmup ? Mathf.approachDelta((float)mount.warmup, (float)warmupTarget, (float)this.shootWarmupSpeed) : Mathf.lerpDelta((float)mount.warmup, (float)warmupTarget, (float)this.shootWarmupSpeed);
        if (this.rotate && (mount.rotate || mount.shoot) && can) {
            float dst;
            float axisX = unit.x + Angles.trnsx((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
            float axisY = unit.y + Angles.trnsy((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
            mount.targetRotation = Angles.angle((float)axisX, (float)axisY, (float)mount.aimX, (float)mount.aimY) - unit.rotation;
            mount.rotation = Angles.moveToward((float)mount.rotation, (float)mount.targetRotation, (float)(this.rotateSpeed * Time.delta));
            if (this.rotationLimit < 360.0f && (dst = Angles.angleDist((float)mount.rotation, (float)this.baseRotation)) > this.rotationLimit / 2.0f) {
                mount.rotation = Angles.moveToward((float)mount.rotation, (float)this.baseRotation, (float)(dst - this.rotationLimit / 2.0f));
            }
        } else if (!this.rotate) {
            mount.rotation = this.baseRotation;
            mount.targetRotation = unit.angleTo(mount.aimX, mount.aimY);
        }
        float weaponRotation = unit.rotation - 90.0f + (this.rotate ? mount.rotation : this.baseRotation);
        float mountX = unit.x + Angles.trnsx((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
        float mountY = unit.y + Angles.trnsy((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
        float bulletX = mountX + Angles.trnsx((float)weaponRotation, (float)this.shootX, (float)this.shootY);
        float bulletY = mountY + Angles.trnsy((float)weaponRotation, (float)this.shootX, (float)this.shootY);
        float shootAngle = this.bulletRotation(unit, mount, bulletX, bulletY);
        if (!this.controllable && this.autoTarget) {
            float f;
            mount.retarget -= Time.delta;
            if (f <= 0.0f) {
                mount.target = this.findTarget(unit, mountX, mountY, this.bullet.range, this.bullet.collidesAir, this.bullet.collidesGround);
                float f2 = mount.retarget = mount.target == null ? this.targetInterval : this.targetSwitchInterval;
            }
            if (mount.target != null && this.checkTarget(unit, mount.target, mountX, mountY, this.bullet.range)) {
                mount.target = null;
            }
            boolean shoot = false;
            if (mount.target != null) {
                boolean bl = shoot = mount.target.within(mountX, mountY, this.bullet.range + Math.abs(this.shootY) + (mount.target instanceof Sized ? ((Sized)mount.target).hitSize() / 2.0f : 0.0f)) && can;
                if (this.predictTarget) {
                    Vec2 to = Predict.intercept((Position)unit, (Position)mount.target, (float)this.bullet.speed);
                    mount.aimX = to.x;
                    mount.aimY = to.y;
                } else {
                    mount.aimX = mount.target.x();
                    mount.aimY = mount.target.y();
                }
            }
            mount.shoot = mount.rotate = shoot;
        }
        if (this.alwaysShooting) {
            mount.shoot = true;
        }
        if (this.continuous && mount.bullet != null) {
            if (!mount.bullet.isAdded() || mount.bullet.time >= mount.bullet.lifetime || mount.bullet.type != this.bullet) {
                mount.bullet = null;
            } else {
                mount.bullet.rotation(weaponRotation + 90.0f);
                mount.bullet.set(bulletX, bulletY);
                mount.reload = this.reload;
                mount.recoil = 1.0f;
                unit.vel.add(Tmp.v1.trns(unit.rotation + 180.0f, mount.bullet.type.recoil * Time.delta));
                if (this.shootSound != Sounds.none && !Vars.headless) {
                    if (mount.sound == null) {
                        mount.sound = new SoundLoop(this.shootSound, 1.0f);
                    }
                    mount.sound.update(bulletX, bulletY, true);
                }
                if (this.alwaysContinuous && mount.shoot) {
                    mount.bullet.time = mount.bullet.lifetime * mount.bullet.type.optimalLifeFract * mount.warmup;
                    mount.bullet.keepAlive = true;
                    unit.apply(this.shootStatus, this.shootStatusDuration);
                }
            }
        } else {
            mount.heat = Math.max(mount.heat - Time.delta * unit.reloadMultiplier / this.cooldownTime, 0.0f);
            if (mount.sound != null) {
                mount.sound.update(bulletX, bulletY, false);
            }
        }
        boolean wasFlipped = mount.side;
        if (this.otherSide != -1 && this.alternate && mount.side == this.flipSprite && mount.reload <= this.reload / 2.0f && lastReload > this.reload / 2.0f) {
            unit.mounts[this.otherSide].side = !unit.mounts[this.otherSide].side;
            boolean bl = mount.side = !mount.side;
        }
        if (mount.shoot && can && (!this.useAmmo || unit.ammo > 0.0f || !Vars.state.rules.unitAmmo || unit.team.rules().infiniteAmmo) && (!this.alternate || wasFlipped == this.flipSprite) && mount.warmup >= this.minWarmup && unit.vel.len() >= this.minShootVelocity && (mount.reload <= 1.0E-4f || this.alwaysContinuous && mount.bullet == null) && (this.alwaysShooting || Angles.within((float)(this.rotate ? mount.rotation : unit.rotation + this.baseRotation), (float)mount.targetRotation, (float)this.shootCone))) {
            this.shoot(unit, mount, bulletX, bulletY, shootAngle);
            mount.reload = this.reload;
            if (this.useAmmo) {
                unit.ammo -= 1.0f;
                if (unit.ammo < 0.0f) {
                    unit.ammo = 0.0f;
                }
            }
        }
    }
}

