/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.weapon;

import ExtraUtilities.worlds.entity.weapon.mounts.reRotMount;
import arc.math.Angles;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Unit;
import mindustry.type.weapons.PointDefenseWeapon;

public class ReRotPointDefenseWeapon
extends PointDefenseWeapon {
    public float reRotateTime = 180.0f;

    public ReRotPointDefenseWeapon(String name) {
        super(name);
        this.mountType = reRotMount::new;
    }

    public void update(Unit unit, WeaponMount m) {
        super.update(unit, m);
        float mountX = unit.x + Angles.trnsx((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
        float mountY = unit.y + Angles.trnsy((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
        reRotMount mount = (reRotMount)m;
        mount.reRotate = mount.target != null ? this.reRotateTime : Math.max(mount.reRotate - Time.delta, 0.0f);
        if (mount.target == null && !mount.shoot && !Angles.within((float)mount.rotation, (float)mount.weapon.baseRotation, (float)0.01f) && mount.reRotate <= 0.0f) {
            mount.rotate = true;
            Tmp.v1.trns(unit.rotation + mount.weapon.baseRotation, 5.0f);
            mount.aimX = mountX + Tmp.v1.x;
            mount.aimY = mountY + Tmp.v1.y;
        }
    }
}

