/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.weapon;

import ExtraUtilities.worlds.entity.weapon.BoostWeapon;
import arc.Core;
import arc.math.geom.Position;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import mindustry.entities.Units;
import mindustry.entities.bullet.MissileBulletType;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import mindustry.type.unit.MissileUnitType;

public class antiMissileWeapon
extends BoostWeapon {
    public float loadSpeed;

    public antiMissileWeapon(String name) {
        this.name = name;
        this.predictTarget = false;
        this.controllable = false;
        this.autoTarget = true;
        this.useAmmo = true;
        this.rotate = true;
        this.rotateSpeed = 30.0f;
    }

    public void addStats(UnitType u, Table t) {
        super.addStats(u, t);
        t.row();
        t.add((CharSequence)Core.bundle.format("stat.extra-utilities-antiWeapon", new Object[]{Float.valueOf(this.bullet.range / 8.0f - 1.0f)}));
    }

    protected Teamc findTarget(Unit unit, float x, float y, float range, boolean air, boolean ground) {
        Unit target = Units.closestEnemy((Team)unit.team, (float)x, (float)y, (float)range, u -> u.type instanceof MissileUnitType);
        if (target != null) {
            return target;
        }
        return (Teamc)Groups.bullet.intersect(x - range, y - range, range * 2.0f, range * 2.0f).min(b -> b.team != unit.team && b.type() != null && (b.type() instanceof MissileBulletType || b.type().homingPower > 0.0f), b -> b.dst2(x, y));
    }

    protected boolean checkTarget(Unit unit, Teamc target, float x, float y, float range) {
        return !target.within((Position)unit, range) || target.team() == unit.team || (!(target instanceof Bullet) || ((Bullet)target).type == null) && (!(target instanceof Unit) || ((Unit)target).type == null);
    }

    @Override
    public void update(Unit unit, WeaponMount mount) {
        super.update(unit, mount);
        if (mount.target == null) {
            mount.rotation += Time.delta * this.loadSpeed;
        }
    }
}

