/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.weapon;

import ExtraUtilities.worlds.entity.weapon.BoostWeapon;
import arc.math.geom.Position;
import arc.scene.ui.layout.Table;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Healthc;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class healConeWeapon
extends BoostWeapon {
    public boolean targetBuildings = true;

    public healConeWeapon(String name) {
        this.name = name;
        this.shootSound = Sounds.pulse;
        this.cooldownTime = 180.0f;
        this.shoot.firstShotDelay = 60.0f;
        this.continuous = true;
    }

    public void addStats(UnitType u, Table t) {
        super.addStats(u, t);
        t.row();
        int healTime = (int)(100.0f / this.bullet.healPercent);
        int reloadNeed = (int)((float)healTime / (this.bullet.lifetime / 60.0f));
        int reloadRest = (int)((float)reloadNeed * this.reload / 60.0f);
        t.add((CharSequence)("[lightgray]" + Stat.repairTime.localized() + ": [white]" + 1.5f * (float)(healTime + reloadRest) / (float)(this.mirror ? 2 : 1) + " " + StatUnit.seconds.localized()));
    }

    protected Teamc findTarget(Unit unit, float x, float y, float range, boolean air, boolean ground) {
        Unit out = Units.closest((Team)unit.team, (float)x, (float)y, (float)range, u -> u != unit && u.damaged());
        if (out != null || !this.targetBuildings) {
            return out;
        }
        return Units.findAllyTile((Team)unit.team, (float)x, (float)y, (float)range, Building::damaged);
    }

    protected boolean checkTarget(Unit unit, Teamc target, float x, float y, float range) {
        return !target.within((Position)unit, range + unit.hitSize / 2.0f) || target.team() != unit.team || !(target instanceof Healthc) || !((Healthc)target).damaged() || !((Healthc)target).isValid();
    }
}

