"""constraint_name

迁移 ID: 7d23eb54c6be
父迁移: 14175fde8186
创建时间: 2025-01-01 20:54:51.070023

"""

from __future__ import annotations

from collections.abc import Sequence

from alembic import op

revision: str = "7d23eb54c6be"
down_revision: str | Sequence[str] | None = "14175fde8186"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("nonebot_plugin_uninfo_botmodel", schema=None) as batch_op:
        batch_op.drop_constraint(
            "unique_bot",
            type_="unique",
        )
        batch_op.create_unique_constraint(
            "nonebot_plugin_uninfo_unique_bot",
            ["self_id", "adapter"],
        )

    with op.batch_alter_table("nonebot_plugin_uninfo_scenemodel", schema=None) as batch_op:
        batch_op.drop_constraint(
            "unique_scene",
            type_="unique",
        )
        batch_op.create_unique_constraint(
            "nonebot_plugin_uninfo_unique_scene",
            ["bot_persist_id", "scene_id", "scene_type"],
        )

    with op.batch_alter_table("nonebot_plugin_uninfo_usermodel", schema=None) as batch_op:
        batch_op.drop_constraint(
            "unique_user",
            type_="unique",
        )
        batch_op.create_unique_constraint(
            "nonebot_plugin_uninfo_unique_user",
            ["bot_persist_id", "user_id"],
        )

    with op.batch_alter_table("nonebot_plugin_uninfo_sessionmodel", schema=None) as batch_op:
        batch_op.drop_constraint(
            "unique_session",
            type_="unique",
        )
        batch_op.create_unique_constraint(
            "nonebot_plugin_uninfo_unique_session",
            ["bot_persist_id", "scene_persist_id", "user_persist_id"],
        )
    # ### end Alembic commands ###


def downgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("nonebot_plugin_uninfo_sessionmodel", schema=None) as batch_op:
        batch_op.drop_constraint(
            "nonebot_plugin_uninfo_unique_session",
            type_="unique",
        )
        batch_op.create_unique_constraint(
            "unique_session",
            ["bot_persist_id", "scene_persist_id", "user_persist_id"],
        )

    with op.batch_alter_table("nonebot_plugin_uninfo_usermodel", schema=None) as batch_op:
        batch_op.drop_constraint(
            "nonebot_plugin_uninfo_unique_user",
            type_="unique",
        )
        batch_op.create_unique_constraint(
            "unique_user",
            ["bot_persist_id", "user_id"],
        )

    with op.batch_alter_table("nonebot_plugin_uninfo_scenemodel", schema=None) as batch_op:
        batch_op.drop_constraint(
            "nonebot_plugin_uninfo_unique_scene",
            type_="unique",
        )
        batch_op.create_unique_constraint(
            "unique_scene",
            ["bot_persist_id", "scene_id", "scene_type"],
        )

    with op.batch_alter_table("nonebot_plugin_uninfo_botmodel", schema=None) as batch_op:
        batch_op.drop_constraint(
            "nonebot_plugin_uninfo_unique_bot",
            type_="unique",
        )
        batch_op.create_unique_constraint(
            "unique_bot",
            ["self_id", "adapter"],
        )
    # ### end Alembic commands ###
