# Miniature Underwater Robot (MUR)

<p align="center">
  <img src="./images/renders/render_27.png" alt="MUR Swarm Render" width="100%"/>
</p>

The **Miniature Underwater Robot (MUR)** is an open-source, versatile platform designed for underwater exploration, data collection, and research. Combining hardware with advanced software capabilities, MUR provides researchers, educators, and hobbyists with an accessible tool for aquatic studies and underwater robotics development.

| MUR Intro | Example Deployments |
|-----------|---------------------|
| [![▶️ MUR Intro](https://img.youtube.com/vi/NzxzlQSZj9Q/0.jpg)](https://www.youtube.com/watch?v=NzxzlQSZj9Q) | [![▶️ Example Deployments](https://img.youtube.com/vi/NDeZn8o2X9w/0.jpg)](https://www.youtube.com/watch?v=NDeZn8o2X9w) |
| [▶️ Watch on YouTube](https://www.youtube.com/watch?v=NzxzlQSZj9Q) | [▶️ Watch on YouTube](https://www.youtube.com/watch?v=NDeZn8o2X9w) |


## Table of Contents

- [Miniature Underwater Robot (MUR)](#miniature-underwater-robot-mur)
  - [Table of Contents](#table-of-contents)
  - [Overview](#overview)
  - [Features](#features)
  - [Bill of Materials (BOM) \& Cost](#bill-of-materials-bom--cost)
  - [Hardware Components](#hardware-components)
  - [Software Architecture](#software-architecture)
    - [Integration Workflow](#integration-workflow)
  - [Installation](#installation)
    - [Prerequisites](#prerequisites)
    - [Building the Packages](#building-the-packages)
  - [Usage](#usage)
    - [Launching the System](#launching-the-system)
    - [Operating the Robot](#operating-the-robot)
  - [Configuration](#configuration)
    - [Configuration Files](#configuration-files)
    - [Customizing Parameters](#customizing-parameters)
  - [Documentation](#documentation)
  - [License](#license)

## Overview

The **Miniature Underwater Robot (MUR)** is engineered to operate in various underwater environments, offering capabilities such as precise navigation, environmental monitoring, and autonomous operations. The project is modular, allowing users to customize and expand functionalities based on specific research or application needs.

MUR integrates multiple ROS (Robot Operating System) packages that work in unison to manage different aspects of the robot's operation. These packages handle control mechanisms, sensor management, modeling, and overall system orchestration, ensuring seamless and reliable performance in underwater settings.

## Features

- **Comprehensive Sensor Suite**: Equipped with multiple IMUs, pressure sensors, leak detectors, temperature and humidity sensors, and more to provide extensive environmental awareness.
- **Versatile Communication Methods**: Supports acoustic (via BlueBuzz modem), radio, WiFi, and tethered Ethernet communication for reliable data transmission in diverse conditions.
- **Modular Hardware Design**: Easily customizable and scalable hardware architecture, enabling users to integrate additional components or modify existing ones.
- **Control Systems**: Combines manual keyboard inputs with PID-based automated controls for precise maneuvering and stabilization.
- **Robust Localization**: Implements visual-based localization using ArUco tags and other advanced techniques for accurate positioning.
- **Emergency Handling**: Incorporates emergency stop and reset functionalities to ensure safe operations.
- **Simplified Launch Process**: Utilize a single launch file to initialize all necessary components, streamlining deployment and reducing setup complexity.

## Bill of Materials (BOM) & Cost

|                  | Other Thrusters | T200 Thrusters |
|------------------|----------------|---------------|
| Self Printing   | $858.69         | $1,878.69     |
| Commercial Printing | $1,019.66    | $2,039.66     |

[View Full BOM](hardware/BOM/MUR_BOM.xlsx)

## Hardware Components

MUR's hardware is designed to withstand the challenges of underwater environments while providing the necessary functionalities for exploration and data collection. Key hardware components include:

- **Inertial Measurement Units (IMUs)**: For precise orientation and motion tracking.
- **Pressure Sensors**: To monitor depth and internal/external pressure.
- **Leak Detectors**: To ensure the integrity of the robot in underwater environments.
- **Temperature and Humidity Sensors**: To monitor the internal conditions of the robot.
- **Communication Modules**: Including acoustic (BlueBuzz modem), radio, WiFi, and Ethernet interfaces for versatile data transmission.
- **Thrusters**: For propulsion and maneuvering, controlled via ROS packages.
- **Power Management System**: Ensures reliable power distribution to all components.
- **Structural Frame**: Built from durable materials to protect internal electronics and sensors.

The hardware is designed to be modular, allowing users to add or replace components as needed. Detailed CAD designs, PCB schematics, and assembly instructions are available in the documentation.

## Software Architecture

MUR's software architecture leverages the power and flexibility of ROS to manage various aspects of the robot's operation. The system is divided into several ROS packages, each responsible for specific functionalities:

- **mur**: The central orchestrator that manages configurations and launches all other packages.
- **mur_control**: Handles control mechanisms, combining manual and PID-based controls for thruster management.
- **mur_model**: Responsible for the robot's modeling and simulation components, enabling testing and validation of control strategies.
- **mur_sensors**: Manages all sensor-related functionalities, including data acquisition, processing, and communication.

Each package is designed to be modular and scalable, allowing for easy integration of additional functionalities or modifications.

### Integration Workflow

1. **Initialization**: The `mur` package's main launch file (`mur.launch`) initializes the system by loading configuration parameters and launching all essential sub-packages.
2. **Sensor Management**: The `mur_sensors` package initializes sensor nodes, ensuring real-time data acquisition and processing.
3. **Modeling and Simulation**: The `mur_model` package sets up the robot's physical and dynamic models, facilitating simulation and testing.
4. **Control Systems**: The `mur_control` package manages thruster commands, integrating manual inputs with automated PID controls to achieve desired movements and stability.
5. **Communication**: All packages communicate via ROS topics and services, ensuring synchronized and coordinated operations across the system.

## Installation

Note: The MUR uses the **Robot Operating System (ROS)** instead of **ROS 2**. This choice enables deployment on lower-end systems and ensures compatibility with a wide range of legacy packages, making the MUR accessible to users with constrained hardware resources.
### Prerequisites

- **ROS**: Ensure that you have a compatible version of ROS installed (e.g., ROS Noetic, ROS Melodic).
- **Catkin Workspace**: Set up a Catkin workspace if you haven't already.

  ```bash
  mkdir -p ~/catkin_ws/src
  cd ~/catkin_ws/
  catkin_make
  source devel/setup.bash
  ```

- **Python Dependencies**: Install necessary Python libraries.

  ```bash
  pip install rospy pygame simple-pid tf2_ros numpy
  ```

  *Note: Some dependencies like `tf2_ros` may require additional ROS-specific installation steps. Refer to the [ROS documentation](http://wiki.ros.org/tf2_ros) for detailed instructions.*

### Building the Packages

1. **Clone the Repository**: Navigate to your Catkin workspace's `src` directory and clone the `mur` and related packages.

2. **Install Dependencies**: Ensure all dependencies listed above are installed.

3. **Build the Workspace**: Navigate back to the root of your workspace and build.

   ```bash
   cd ~/catkin_ws
   catkin_make
   ```

4. **Source the Workspace**: Source the setup file to make ROS aware of the new packages.

   ```bash
   source devel/setup.bash
   ```

## Usage

### Launching the System

The `mur` package provides a comprehensive launch file that initializes all necessary sub-packages and configurations required for the MUR system. By launching `mur.launch`, you start the sensor modules, modeling components, and control systems in one streamlined process.

```bash
roslaunch mur mur.launch
```

This command performs the following actions:

1. **Loads Configuration Parameters**:
   - **Global Configurations**: Defines module information and communication parameters.
   - **Environment Configurations**: Specifies environmental parameters such as fluid type and density.

2. **Includes Sub-Launch Files**:
   - **mur_sensors.launch**: Initializes all sensor-related nodes, ensuring real-time data acquisition and processing.
   - **mur_model.launch**: Sets up the robot's modeling and simulation components, enabling testing and validation of control strategies.
   - **mur_control.launch**: Starts the control systems for maneuvering and stabilization, combining manual inputs with automated PID controls.

### Operating the Robot

Once the system is launched, you can interact with the robot using the provided control interfaces:

- **Manual Control**: Utilize keyboard inputs to manually adjust the robot's position and orientation.
- **Automated Control**: The PID controllers automatically stabilize and guide the robot towards desired setpoints.
- **Emergency Handling**: Activate emergency stops or reset functionalities as needed to ensure safe operations.

Refer to the individual package READMEs for detailed instructions on using specific functionalities.

## Configuration

MUR's operation is highly customizable through YAML configuration files. These files allow you to define environmental parameters, control settings, and module information, enabling the robot to adapt to different scenarios and requirements.

### Configuration Files

- **Global Configuration** (`mur/config/global_config.yaml`):
  - Defines module information, including names, MAC addresses, and communication ports.
  - Essential for setting up networked communication between different hardware modules.

- **Environment Configuration** (`mur/config/environment_info.yaml`):
  - Specifies environmental parameters such as the type and density of the operating fluid and the gravitational constant.
  - Crucial for accurate simulation, control, and sensor data interpretation.

- **Control Configuration** (`mur_control/config/control_info.yaml`):
  - Contains PID gains, control loop rates, and control modes for each degree of freedom (DOF).
  - Allows fine-tuning of the robot's responsiveness and stability.

### Customizing Parameters

- **Adjusting PID Gains**: Modify the `control_info.yaml` file to change the PID gains for different DOFs, enabling precise control over the robot's movements.
- **Changing Operational Environment**: Update the `environment_info.yaml` to switch between different fluid types (e.g., freshwater, seawater) by selecting the appropriate `type` and `density`.
- **Adding New Modules**: Extend the `global_config.yaml` by adding new modules with unique names, MAC addresses, and communication ports to integrate additional functionalities.

Ensure that only one configuration per category is active at a time to prevent conflicts and ensure system stability.

## Documentation

Comprehensive documentation for MUR is available in the each directory (Hardware and Software subdirectories). These provide detailed assembly instructions, operational guides, troubleshooting tips, and additional resources to help you get the most out of your MUR system.


## License

This project is licensed under the [MIT License](LICENSE.MIT.md) for software and [CERN-OHL-P-2.0](LICENSE.CERN-OHL-P-2.0.md) for hardware. The combined license is listed in [LICENSE.md](LICENSE.md).
