# MUR Hardware

Welcome to the **MUR Hardware** repository. This folder contains all the essential hardware design files and documentation for the Miniature Underwater Robot (MUR). The hardware components are meticulously designed to ensure reliable and efficient operation in underwater environments, supporting various functionalities from propulsion to data acquisition and processing.

## Folder Structure

- **Firmware**: Contains the embedded code and configuration files necessary for the operation of the MUR's hardware components. This includes the control algorithms, communication protocols, and sensor management software that run on the embedded systems.

- **PCB**: Houses the design files and documentation for the various printed circuit boards (PCBs) used in the MUR. This includes:
  - **MUR Compute Module Mini**: The central processing board managing overall system coordination.
  - **MUR Sensor and ESC Control PCB**: The board responsible for sensor data acquisition and motor control.
  - **MUR ESC to Thruster Control PCB**: The power distribution board handling ESC and thruster connections.

- **CAD**: Contains the mechanical design files for the MUR's chassis and housing. These files include 3D models, assembly drawings, and other relevant CAD data necessary for manufacturing and assembling the robot.

## Overview

The **hardware** folder is the backbone of the MUR, encompassing all the physical components required to build and operate the robot. From the electronic circuits to the mechanical structures, this folder provides everything needed to bring the MUR to life.