/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.loader;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ILanguageAdapter;

public class LanguageAdapterRegistry {
    private static final Map<String, ILanguageAdapter> adapterRegistry = Maps.newHashMap();

    public static void registerLanguageAdapter(String language, ILanguageAdapter languageAdapter) {
        if (adapterRegistry.containsKey(language)) {
            FMLLog.log.error("Language adapter {} of language {} already exists!", (Object)adapterRegistry.get(language).getClass().getName(), (Object)language);
        } else {
            adapterRegistry.put(language, languageAdapter);
            FMLLog.log.debug("Registering language adapter {} for language {}.", (Object)languageAdapter.getClass().getName(), (Object)language);
        }
    }

    public static ILanguageAdapter getAdapterFor(String language) {
        if (adapterRegistry.containsKey(language)) {
            return adapterRegistry.get(language);
        }
        return new ILanguageAdapter.JavaAdapter();
    }

    static {
        LanguageAdapterRegistry.registerLanguageAdapter("java", new ILanguageAdapter.JavaAdapter());
    }
}

